/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import com.google.auto.value.processor.TypeEncoder;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public final class SimpleMethod {
    private final String access;
    private final String name;
    private final String throwsString;

    SimpleMethod(ExecutableElement method) {
        this.access = SimpleMethod.access(method);
        this.name = method.getSimpleName().toString();
        this.throwsString = SimpleMethod.throwsString(method);
    }

    public String getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getThrows() {
        return this.throwsString;
    }

    static String access(ExecutableElement method) {
        Set<Modifier> mods = method.getModifiers();
        if (mods.contains((Object)Modifier.PUBLIC)) {
            return "public ";
        }
        if (mods.contains((Object)Modifier.PROTECTED)) {
            return "protected ";
        }
        return "";
    }

    private static String throwsString(ExecutableElement method) {
        if (method.getThrownTypes().isEmpty()) {
            return "";
        }
        return "throws " + method.getThrownTypes().stream().map(TypeEncoder::encode).collect(Collectors.joining(", "));
    }
}

