/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hop.pipeline.transforms.languagemodelchat.LanguageModelChatMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ModelType;

public class LanguageModel {
    private final ModelType type;
    private final String name;

    public LanguageModel(LanguageModelChatMeta meta) {
        this.type = ModelType.valueOf(meta.getModelType());
        switch (this.type) {
            case OPEN_AI: {
                this.name = meta.getOpenAiModelName();
                break;
            }
            case ANTHROPIC: {
                this.name = meta.getAnthropicModelName();
                break;
            }
            case OLLAMA: {
                this.name = meta.getOllamaModelName();
                break;
            }
            case MISTRAL: {
                this.name = meta.getMistralModelName();
                break;
            }
            case HUGGING_FACE: {
                this.name = meta.getHuggingFaceModelId();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid model type");
            }
        }
    }

    public ModelType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LanguageModel)) {
            return false;
        }
        LanguageModel model = (LanguageModel)o;
        return new EqualsBuilder().append((Object)this.type, (Object)model.type).append((Object)this.name, (Object)model.name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.type).append((Object)this.name).toHashCode();
    }
}

