/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.io;

import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.beam.sdk.extensions.avro.io.AvroIO;
import org.apache.beam.sdk.extensions.avro.io.AvroSink;
import org.apache.beam.sdk.extensions.avro.io.DynamicAvroDestinations;
import org.apache.beam.sdk.extensions.avro.io.SerializableAvroCodecFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ConstantAvroDestination<@UnknownKeyFor UserT, @UnknownKeyFor OutputT>
extends DynamicAvroDestinations<UserT, Void, OutputT> {
    private static final @UnknownKeyFor @NonNull @Initialized int METADATA_BYTES_MAX_LENGTH = 40;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy;
    private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Schema> schema;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> metadata;
    private final @UnknownKeyFor @NonNull @Initialized SerializableAvroCodecFactory codec;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction;
    private final @UnknownKeyFor @NonNull @Initialized AvroSink.DatumWriterFactory<OutputT> datumWriterFactory;

    public ConstantAvroDestination(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> metadata, @UnknownKeyFor @NonNull @Initialized CodecFactory codec, @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction) {
        this(filenamePolicy, schema, metadata, codec, formatFunction, null);
    }

    public ConstantAvroDestination(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> metadata, @UnknownKeyFor @NonNull @Initialized CodecFactory codec, @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction, @Nullable @UnknownKeyFor @Initialized AvroSink.DatumWriterFactory<OutputT> datumWriterFactory) {
        this.filenamePolicy = filenamePolicy;
        this.schema = Suppliers.compose((Function)new SchemaFunction(), (Supplier)Suppliers.ofInstance((Object)schema.toString()));
        this.metadata = metadata;
        this.codec = new SerializableAvroCodecFactory(codec);
        this.formatFunction = formatFunction;
        this.datumWriterFactory = datumWriterFactory;
    }

    public OutputT formatRecord(UserT record) {
        return (OutputT)this.formatFunction.apply(record);
    }

    public @Nullable @UnknownKeyFor @Initialized Void getDestination(UserT element) {
        return null;
    }

    public @Nullable @UnknownKeyFor @Initialized Void getDefaultDestination() {
        return null;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy getFilenamePolicy(@UnknownKeyFor @Nullable @Initialized Void destination) {
        return this.filenamePolicy;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema getSchema(@UnknownKeyFor @Nullable @Initialized Void destination) {
        return (Schema)this.schema.get();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getMetadata(@UnknownKeyFor @Nullable @Initialized Void destination) {
        return this.metadata;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CodecFactory getCodec(@UnknownKeyFor @Nullable @Initialized Void destination) {
        return this.codec.getCodec();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized AvroSink.DatumWriterFactory<OutputT> getDatumWriterFactory(@UnknownKeyFor @Nullable @Initialized Void destination) {
        return this.datumWriterFactory;
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        this.filenamePolicy.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"schema", (String)((Schema)this.schema.get()).toString()).withLabel("Record Schema"));
        builder.addIfNotDefault(DisplayData.item((String)"codec", (String)this.codec.getCodec().toString()).withLabel("Avro Compression Codec"), (Object)AvroIO.TypedWrite.DEFAULT_SERIALIZABLE_CODEC.toString());
        builder.include("Metadata", (HasDisplayData)new Metadata());
    }

    private class Metadata
    implements HasDisplayData {
        private Metadata() {
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            for (Map.Entry entry : ConstantAvroDestination.this.metadata.entrySet()) {
                DisplayData.Type type = DisplayData.inferType(entry.getValue());
                if (type != null) {
                    builder.add(DisplayData.item((String)((String)entry.getKey()), (DisplayData.Type)type, entry.getValue()));
                    continue;
                }
                String base64 = BaseEncoding.base64().encode((byte[])entry.getValue());
                String repr = base64.length() <= 40 ? base64 : base64.substring(0, 40) + "...";
                builder.add(DisplayData.item((String)((String)entry.getKey()), (String)repr));
            }
        }
    }

    private static class SchemaFunction
    implements Serializable,
    Function<String, Schema> {
        private SchemaFunction() {
        }

        public @UnknownKeyFor @NonNull @Initialized Schema apply(@UnknownKeyFor @NonNull @Initialized String input) {
            return new Schema.Parser().parse(input);
        }
    }
}

