/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type;

import com.datastax.oss.driver.api.core.type.DataType;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface MapType
extends DataType {
    @NonNull
    public DataType getKeyType();

    @NonNull
    public DataType getValueType();

    public boolean isFrozen();

    @Override
    @NonNull
    default public String asCql(boolean includeFrozen, boolean pretty) {
        String template = this.isFrozen() && includeFrozen ? "frozen<map<%s, %s>>" : "map<%s, %s>";
        return String.format(template, this.getKeyType().asCql(includeFrozen, pretty), this.getValueType().asCql(includeFrozen, pretty));
    }

    @Override
    default public int getProtocolCode() {
        return 33;
    }
}

