/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor.service;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.metrics.AcidMetricService;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionHeartbeatService;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorPipeline;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.service.CompactionService;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.Ref;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidCompactionService
extends CompactionService {
    private static final String CLASS_NAME = AcidCompactionService.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private final boolean collectMrStats;
    private StorageDescriptor sd;
    private ValidCompactorWriteIdList tblValidWriteIds;
    private AcidDirectory dir;

    public AcidCompactionService(HiveConf conf, IMetaStoreClient msc, CompactorFactory compactorFactory, boolean collectGenericStats, boolean collectMrStats) {
        super(conf, msc, compactorFactory, collectGenericStats);
        this.collectMrStats = collectMrStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcidDirectory getAcidStateForWorker(CompactionInfo ci, StorageDescriptor sd, ValidCompactorWriteIdList tblValidWriteIds) throws IOException, InterruptedException {
        if (CompactorUtil.runJobAsSelf(ci.runAs)) {
            return AcidUtils.getAcidState(null, new Path(sd.getLocation()), (Configuration)this.conf, (ValidWriteIdList)tblValidWriteIds, (Ref<Boolean>)Ref.from((Object)false), true);
        }
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
        try {
            AcidDirectory acidDirectory = (AcidDirectory)ugi.doAs(() -> AcidUtils.getAcidState(null, new Path(sd.getLocation()), (Configuration)this.conf, (ValidWriteIdList)tblValidWriteIds, (Ref<Boolean>)Ref.from((Object)false), true));
            return acidDirectory;
        }
        finally {
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
            catch (IOException exception) {
                LOG.error("Could not clean up file-system handles for UGI: " + String.valueOf(ugi) + " for " + ci.getFullPartitionName(), (Throwable)exception);
            }
        }
    }

    @Override
    public void cleanupResultDirs(CompactionInfo ci) {
        Path resultDir = QueryCompactor.Util.getCompactionResultDir(this.sd, (ValidWriteIdList)this.tblValidWriteIds, this.conf, ci.type == CompactionType.MAJOR, false, this.dir);
        LOG.info("Deleting result directories created by the compactor:\n");
        try {
            FileSystem fs = resultDir.getFileSystem((Configuration)this.conf);
            LOG.info(resultDir.toString());
            fs.delete(resultDir, true);
            if (ci.type == CompactionType.MINOR) {
                Path deleteDeltaDir = QueryCompactor.Util.getCompactionResultDir(this.sd, (ValidWriteIdList)this.tblValidWriteIds, this.conf, false, true, this.dir);
                LOG.info(deleteDeltaDir.toString());
                fs.delete(deleteDeltaDir, true);
            }
        }
        catch (IOException ex) {
            LOG.error("Caught exception while cleaning result directories:", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean compact(Table table, CompactionInfo ci) throws Exception {
        try (CompactionTxn compactionTxn = new CompactionTxn();){
            Partition p;
            if (ci.isRebalanceCompaction() && table.getSd().getNumBuckets() > 0) {
                LOG.error("Cannot execute rebalancing compaction on bucketed tables.");
                ci.errorMessage = "Cannot execute rebalancing compaction on bucketed tables.";
                this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                Boolean bl = false;
                return bl;
            }
            if (!ci.type.equals((Object)CompactionType.REBALANCE) && ci.numberOfBuckets > 0 && LOG.isWarnEnabled()) {
                LOG.warn("Only the REBALANCE compaction accepts the number of buckets clause (CLUSTERED INTO {N} BUCKETS). Since the compaction request is {}, it will be ignored.", (Object)ci.type);
            }
            String fullTableName = TxnUtils.getFullTableName((String)table.getDbName(), (String)table.getTableName());
            try {
                p = CompactorUtil.resolvePartition(this.conf, this.msc, ci.dbname, ci.tableName, ci.partName, CompactorUtil.METADATA_FETCH_MODE.REMOTE);
                if (p == null && ci.partName != null) {
                    ci.errorMessage = "Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped and moving on.";
                    LOG.warn(ci.errorMessage + " Compaction info: {}", (Object)ci);
                    this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                    Boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                LOG.error("Unexpected error during resolving partition.", (Throwable)e);
                ci.errorMessage = e.getMessage();
                this.msc.markFailed(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                Boolean bl = false;
                return bl;
            }
            CompactorUtil.checkInterrupt(CLASS_NAME);
            this.sd = CompactorUtil.resolveStorageDescriptor(table, p);
            if (this.isTableSorted(this.sd, ci)) {
                Boolean e = false;
                return e;
            }
            if (ci.runAs == null) {
                ci.runAs = TxnUtils.findUserToRunAs((String)this.sd.getLocation(), (Table)table, (Configuration)this.conf);
            }
            CompactorUtil.checkInterrupt(CLASS_NAME);
            compactionTxn.open(ci);
            ValidTxnList validTxnList = this.msc.getValidTxns(compactionTxn.getTxnId());
            this.tblValidWriteIds = TxnUtils.createValidCompactWriteIdList((TableValidWriteIds)((TableValidWriteIds)this.msc.getValidWriteIds(Collections.singletonList(fullTableName), validTxnList.writeToString()).get(0)));
            LOG.debug("ValidCompactWriteIdList: " + this.tblValidWriteIds.writeToString());
            this.conf.set("hive.txn.valid.txns", validTxnList.writeToString());
            ValidTxnWriteIdList txnWriteIds = new ValidTxnWriteIdList(Long.valueOf(compactionTxn.getTxnId()));
            txnWriteIds.addTableValidWriteIdList((ValidWriteIdList)this.tblValidWriteIds);
            this.conf.set("hive.txn.tables.valid.writeids", txnWriteIds.toString());
            this.msc.addWriteIdsToMinHistory(compactionTxn.getTxnId(), (Map)ImmutableMap.of((Object)fullTableName, (Object)txnWriteIds.getMinOpenWriteId(fullTableName)));
            ci.highestWriteId = this.tblValidWriteIds.getHighWatermark();
            this.msc.updateCompactorState(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci), compactionTxn.getTxnId());
            CompactorUtil.checkInterrupt(CLASS_NAME);
            if (this.isDynPartAbort(table, ci)) {
                this.msc.markCompacted(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                compactionTxn.wasSuccessful();
                Boolean bl = false;
                return bl;
            }
            this.dir = this.getAcidStateForWorker(ci, this.sd, this.tblValidWriteIds);
            if (!AcidCompactionService.isEnoughToCompact(ci, this.dir, this.sd)) {
                if (AcidCompactionService.needsCleaning(this.dir, this.sd)) {
                    this.msc.markCompacted(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                } else {
                    ci.errorMessage = "None of the compaction thresholds met, compaction request is refused!";
                    LOG.debug(ci.errorMessage + " Compaction info: {}", (Object)ci);
                    this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                }
                compactionTxn.wasSuccessful();
                Boolean bl = false;
                return bl;
            }
            if (!ci.isMajorCompaction() && !CompactorUtil.isMinorCompactionSupported(this.conf, table.getParameters(), this.dir)) {
                ci.errorMessage = "Query based Minor compaction is not possible for full acid tables having raw format (non-acid) data in them.";
                LOG.error(ci.errorMessage + " Compaction info: {}", (Object)ci);
                try {
                    this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                }
                catch (Throwable tr) {
                    LOG.error("Caught an exception while trying to mark compaction {} as failed: {}", (Object)ci, (Object)tr);
                }
                Boolean tr = false;
                return tr;
            }
            CompactorUtil.checkInterrupt(CLASS_NAME);
            try {
                this.failCompactionIfSetForTest();
                CompactorPipeline compactorPipeline = this.compactorFactory.getCompactorPipeline(table, this.conf, ci, this.msc);
                this.computeStats = compactorPipeline.isMRCompaction() && this.collectMrStats || this.collectGenericStats;
                LOG.info("Starting " + ci.type.toString() + " compaction for " + ci.getFullPartitionName() + ", id:" + ci.id + " in " + String.valueOf(compactionTxn) + " with compute stats set to " + this.computeStats);
                CompactorContext compactorContext = new CompactorContext(this.conf, table, p, this.sd, (ValidWriteIdList)this.tblValidWriteIds, ci, this.dir);
                compactorPipeline.execute(compactorContext);
                LOG.info("Completed " + ci.type.toString() + " compaction for " + ci.getFullPartitionName() + " in " + String.valueOf(compactionTxn) + ", marking as compacted.");
                this.msc.markCompacted(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                compactionTxn.wasSuccessful();
                AcidMetricService.updateMetricsFromWorker((String)ci.dbname, (String)ci.tableName, (String)ci.partName, (CompactionType)ci.type, (int)this.dir.getCurrentDirectories().size(), (int)this.dir.getDeleteDeltas().size(), (Configuration)this.conf, (IMetaStoreClient)this.msc);
            }
            catch (Throwable e) {
                this.computeStats = false;
                throw e;
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Caught exception in " + CLASS_NAME + " while trying to compact " + String.valueOf(ci), (Throwable)e);
            throw e;
        }
    }

    static boolean isEnoughToCompact(CompactionInfo ci, AcidDirectory dir, StorageDescriptor sd) {
        boolean isEnoughToCompact;
        int deltaCount = dir.getCurrentDirectories().size();
        int origCount = dir.getOriginalFiles().size();
        StringBuilder deltaInfo = new StringBuilder().append(deltaCount);
        if (ci.isRebalanceCompaction()) {
            return true;
        }
        if (ci.isMajorCompaction()) {
            isEnoughToCompact = origCount > 0 || deltaCount + (dir.getBaseDirectory() == null ? 0 : 1) > 1;
        } else {
            boolean bl = isEnoughToCompact = deltaCount > 1;
            if (deltaCount == 2) {
                Map<String, Long> deltaByType = dir.getCurrentDirectories().stream().collect(Collectors.groupingBy(delta -> delta.isDeleteDelta() ? "delete_delta_" : "delta_", Collectors.counting()));
                isEnoughToCompact = deltaByType.size() != deltaCount;
                deltaInfo.append(" ").append(deltaByType);
            }
        }
        if (!isEnoughToCompact) {
            LOG.info("Not enough files in {} to compact; current base: {}, delta files: {}, originals: {}", new Object[]{sd.getLocation(), dir.getBaseDirectory(), deltaInfo, origCount});
        }
        return isEnoughToCompact;
    }

    public static boolean needsCleaning(AcidDirectory dir, StorageDescriptor sd) {
        boolean needsJustCleaning;
        int numObsoleteDirs = dir.getObsolete().size() + dir.getAbortedDirectories().size();
        boolean bl = needsJustCleaning = numObsoleteDirs > 0;
        if (needsJustCleaning) {
            LOG.info("{} obsolete directories in {} found; marked for cleaning.", (Object)numObsoleteDirs, (Object)sd.getLocation());
        }
        return needsJustCleaning;
    }

    class CompactionTxn
    implements AutoCloseable {
        private long txnId = 0L;
        private long lockId = 0L;
        private TxnStatus status = TxnStatus.UNKNOWN;
        private boolean successfulCompaction = false;

        CompactionTxn() {
        }

        void open(CompactionInfo ci) throws TException {
            this.txnId = AcidCompactionService.this.msc.openTxn(ci.runAs, CompactionType.REBALANCE == ci.type ? TxnType.REBALANCE_COMPACTION : TxnType.COMPACTION);
            this.status = TxnStatus.OPEN;
            LockRequest lockRequest = this.createLockRequest(ci);
            LockResponse res = AcidCompactionService.this.msc.lock(lockRequest);
            if (res.getState() != LockState.ACQUIRED) {
                throw new TException("Unable to acquire lock(s) on {" + ci.getFullPartitionName() + "}, status {" + String.valueOf(res.getState()) + "}, reason {" + res.getErrorMessage() + "}");
            }
            this.lockId = res.getLockid();
            CompactionHeartbeatService.getInstance(AcidCompactionService.this.conf).startHeartbeat(this.txnId, this.lockId, TxnUtils.getFullTableName((String)ci.dbname, (String)ci.tableName));
        }

        private LockRequest createLockRequest(CompactionInfo ci) {
            Pair lockAndOpType = Pair.of((Object)LockType.SHARED_READ, (Object)DataOperationType.SELECT);
            if (CompactionType.REBALANCE == ci.type) {
                lockAndOpType = Pair.of((Object)LockType.EXCL_WRITE, (Object)DataOperationType.UPDATE);
            }
            return CompactorUtil.createLockRequest(AcidCompactionService.this.conf, ci, this.txnId, (LockType)lockAndOpType.getKey(), (DataOperationType)lockAndOpType.getValue());
        }

        void wasSuccessful() {
            this.successfulCompaction = true;
        }

        @Override
        public void close() throws Exception {
            if (this.status == TxnStatus.UNKNOWN) {
                return;
            }
            try {
                CompactionHeartbeatService.getInstance(AcidCompactionService.this.conf).stopHeartbeat(this.txnId);
            }
            finally {
                if (this.successfulCompaction) {
                    this.commit();
                } else {
                    this.abort();
                }
            }
        }

        long getTxnId() {
            return this.txnId;
        }

        public String toString() {
            return "txnId=" + this.txnId + ", lockId=" + this.lockId + " (TxnStatus: " + String.valueOf(this.status) + ")";
        }

        private void commit() throws TException {
            if (this.status == TxnStatus.OPEN) {
                AcidCompactionService.this.msc.commitTxn(this.txnId);
                this.status = TxnStatus.COMMITTED;
            }
        }

        private void abort() throws TException {
            if (this.status == TxnStatus.OPEN) {
                AbortTxnRequest abortTxnRequest = new AbortTxnRequest(this.txnId);
                abortTxnRequest.setErrorCode(TxnErrorMsg.ABORT_COMPACTION_TXN.getErrorCode());
                AcidCompactionService.this.msc.rollbackTxn(abortTxnRequest);
                this.status = TxnStatus.ABORTED;
            }
        }
    }
}

