/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.compact;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

@Explain(displayName="Compact", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableCompactDesc
extends AbstractAlterTableDesc
implements DDLDesc.DDLDescWithWriteId {
    private final String tableName;
    private final Map<String, String> partitionSpec;
    private final String compactionType;
    private final boolean isBlocking;
    private final String poolName;
    private final int numberOfBuckets;
    private final Map<String, String> properties;
    private final String orderByClause;
    private final ExprNodeDesc filterExpr;
    private Long writeId;

    public AlterTableCompactDesc(TableName tableName, Map<String, String> partitionSpec, String compactionType, boolean isBlocking, String poolName, int numberOfBuckets, Map<String, String> properties, String orderByClause, ExprNodeDesc filterExpr) throws SemanticException {
        super(AlterTableType.COMPACT, tableName, partitionSpec, null, false, false, properties);
        this.tableName = tableName.getNotEmptyDbTable();
        this.partitionSpec = partitionSpec;
        this.compactionType = compactionType;
        this.isBlocking = isBlocking;
        this.poolName = poolName;
        this.numberOfBuckets = numberOfBuckets;
        this.properties = properties;
        this.orderByClause = orderByClause;
        this.filterExpr = filterExpr;
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Explain(displayName="partition spec", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    @Explain(displayName="compaction type", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getCompactionType() {
        return this.compactionType;
    }

    @Explain(displayName="blocking", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Explain(displayName="pool", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getPoolName() {
        return this.poolName;
    }

    @Explain(displayName="numberOfBuckets", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public int getNumberOfBuckets() {
        return this.numberOfBuckets;
    }

    @Explain(displayName="properties", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Explain(displayName="order by", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getOrderByClause() {
        return this.orderByClause;
    }

    public ExprNodeDesc getFilterExpr() {
        return this.filterExpr;
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    @Override
    public String getFullTableName() {
        return this.tableName;
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }
}

