/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.calcite.adapter.druid.DruidType;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.Period;

public class DruidSqlCastConverter
implements DruidSqlOperatorConverter {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.CAST;
    }

    @Override
    public String toDruidExpression(RexNode rexNode, RelDataType topRel, DruidQuery druidQuery) {
        RexNode operand = (RexNode)((RexCall)rexNode).getOperands().get(0);
        String operandExpression = DruidExpressions.toDruidExpression(operand, topRel, druidQuery);
        if (operandExpression == null) {
            return null;
        }
        SqlTypeName fromType = operand.getType().getSqlTypeName();
        String fromTypeString = DruidSqlCastConverter.dateTimeFormatString(fromType);
        SqlTypeName toType = rexNode.getType().getSqlTypeName();
        String timeZoneConf = druidQuery.getConnectionConfig().timeZone();
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneConf == null ? "UTC" : timeZoneConf);
        boolean nullEqualToEmpty = druidQuery.getConnectionConfig().nullEqualToEmpty();
        if (fromTypeString == null) {
            String string = fromTypeString = nullEqualToEmpty ? "" : null;
        }
        if (SqlTypeName.CHAR_TYPES.contains(fromType) && SqlTypeName.DATETIME_TYPES.contains(toType)) {
            return DruidSqlCastConverter.castCharToDateTime(toType == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE ? timeZone : DateTimeUtils.UTC_ZONE, operandExpression, toType, fromTypeString);
        }
        if (SqlTypeName.DATETIME_TYPES.contains(fromType) && SqlTypeName.CHAR_TYPES.contains(toType)) {
            return DruidSqlCastConverter.castDateTimeToChar(fromType == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE ? timeZone : DateTimeUtils.UTC_ZONE, operandExpression, fromType);
        }
        if (SqlTypeName.DATETIME_TYPES.contains(fromType) && toType == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            if (timeZone.equals(DateTimeUtils.UTC_ZONE)) {
                return operandExpression;
            }
            return DruidSqlCastConverter.castCharToDateTime(timeZone, DruidSqlCastConverter.castDateTimeToChar(DateTimeUtils.UTC_ZONE, operandExpression, fromType), toType, fromTypeString);
        }
        if (fromType == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE && SqlTypeName.DATETIME_TYPES.contains(toType)) {
            if (toType != SqlTypeName.DATE && timeZone.equals(DateTimeUtils.UTC_ZONE)) {
                return operandExpression;
            }
            return DruidSqlCastConverter.castCharToDateTime(DateTimeUtils.UTC_ZONE, DruidSqlCastConverter.castDateTimeToChar(timeZone, operandExpression, fromType), toType, fromTypeString);
        }
        DruidType fromExprType = DruidExpressions.EXPRESSION_TYPES.get(fromType);
        DruidType toExprType = DruidExpressions.EXPRESSION_TYPES.get(toType);
        if (fromExprType == null || toExprType == null) {
            return null;
        }
        String typeCastExpression = fromExprType != toExprType ? DruidQuery.format("CAST(%s, '%s')", operandExpression, toExprType.toString()) : operandExpression;
        if (toType == SqlTypeName.DATE) {
            return DruidExpressions.applyTimestampFloor(typeCastExpression, Period.days((int)1).toString(), "", TimeZone.getTimeZone(druidQuery.getConnectionConfig().timeZone()));
        }
        return typeCastExpression;
    }

    private static String castCharToDateTime(TimeZone timeZone, String operand, SqlTypeName toType, String format) {
        String timestampExpression = DruidExpressions.functionCall("timestamp_parse", (List<String>)ImmutableList.of((Object)operand, (Object)DruidExpressions.stringLiteral(format), (Object)DruidExpressions.stringLiteral(timeZone.getID())));
        if (toType == SqlTypeName.DATE) {
            return DruidExpressions.applyTimestampFloor(timestampExpression, Period.days((int)1).toString(), "", timeZone);
        }
        if (toType == SqlTypeName.TIMESTAMP || toType == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return timestampExpression;
        }
        throw new IllegalStateException(DruidQuery.format("Unsupported DateTime type[%s]", toType));
    }

    private static String castDateTimeToChar(TimeZone timeZone, String operand, SqlTypeName fromType) {
        return DruidExpressions.functionCall("timestamp_format", (List<String>)ImmutableList.of((Object)operand, (Object)DruidExpressions.stringLiteral(DruidSqlCastConverter.dateTimeFormatString(fromType)), (Object)DruidExpressions.stringLiteral(timeZone.getID())));
    }

    public static String dateTimeFormatString(SqlTypeName sqlTypeName) {
        if (sqlTypeName == SqlTypeName.DATE) {
            return "yyyy-MM-dd";
        }
        if (sqlTypeName == SqlTypeName.TIMESTAMP) {
            return "yyyy-MM-dd HH:mm:ss";
        }
        if (sqlTypeName == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        }
        return null;
    }
}

