/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TransactionalRetryProxy;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TxnUtils.class);

    public static ValidTxnList createValidTxnListForCleaner(GetOpenTxnsResponse txns, long minOpenTxn, boolean isAbortCleanup) {
        long txnId;
        long highWatermark = minOpenTxn - 1L;
        long[] exceptions = new long[txns.getOpen_txnsSize()];
        BitSet abortedBits = BitSet.valueOf(txns.getAbortedBits());
        int i = 0;
        Iterator iterator = txns.getOpen_txns().iterator();
        while (iterator.hasNext() && (txnId = ((Long)iterator.next()).longValue()) <= highWatermark) {
            if (abortedBits.get(i)) {
                exceptions[i] = txnId;
            } else if (isAbortCleanup) {
                exceptions[i] = txnId;
            } else assert (false) : JavaUtils.txnIdToString((long)txnId) + " is open and <= hwm:" + highWatermark;
            ++i;
        }
        exceptions = Arrays.copyOf(exceptions, i);
        if (!isAbortCleanup) {
            BitSet bitSet = new BitSet(exceptions.length);
            bitSet.set(0, exceptions.length);
            return new ValidReadTxnList(exceptions, bitSet, highWatermark, Long.MAX_VALUE);
        }
        return new ValidReadTxnList(exceptions, abortedBits, highWatermark, Long.MAX_VALUE);
    }

    public static ValidCompactorWriteIdList createValidCompactWriteIdList(TableValidWriteIds tableValidWriteIds) {
        String fullTableName = tableValidWriteIds.getFullTableName();
        List invalids = tableValidWriteIds.getInvalidWriteIds();
        BitSet abortedBits = BitSet.valueOf(tableValidWriteIds.getAbortedBits());
        long[] exceptions = new long[invalids.size()];
        int i = 0;
        Iterator iterator = invalids.iterator();
        while (iterator.hasNext()) {
            long writeId = (Long)iterator.next();
            if (!abortedBits.get(i)) continue;
            exceptions[i++] = writeId;
        }
        if (i < exceptions.length) {
            exceptions = Arrays.copyOf(exceptions, i);
        }
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0, exceptions.length);
        if (tableValidWriteIds.isSetMinOpenWriteId()) {
            long minOpenWriteId = tableValidWriteIds.getMinOpenWriteId();
            return new ValidCompactorWriteIdList(fullTableName, exceptions, bitSet, minOpenWriteId - 1L, minOpenWriteId);
        }
        return new ValidCompactorWriteIdList(fullTableName, exceptions, bitSet, tableValidWriteIds.getWriteIdHighWaterMark());
    }

    public static TxnStore getTxnStore(Configuration conf) {
        String className = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_STORE_IMPL);
        try {
            TxnStore handler = (TxnStore)JavaUtils.getClass((String)className, TxnStore.class).newInstance();
            handler.setConf(conf);
            handler = TransactionalRetryProxy.getProxy(handler.getRetryHandler(), handler.getJdbcResourceHolder(), handler);
            return handler;
        }
        catch (Exception e) {
            LOG.error("Unable to instantiate raw store directly in fastpath mode", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isTransactionalTable(Table table) {
        return table != null && TxnUtils.isTransactionalTable(table.getParameters());
    }

    public static boolean isTransactionalTable(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        String tableIsTransactional = parameters.get("transactional");
        return Boolean.parseBoolean(tableIsTransactional);
    }

    public static boolean isAcidTable(Table table) {
        return table != null && TxnUtils.isAcidTable(table.getParameters());
    }

    public static boolean isAcidTable(Map<String, String> parameters) {
        return TxnUtils.isTransactionalTable(parameters) && "default".equalsIgnoreCase(parameters.get("transactional_properties"));
    }

    public static boolean isInsertOnlyTable(Table table) {
        return TxnUtils.isTransactionalTable(table) && "insert_only".equalsIgnoreCase((String)table.getParameters().get("transactional_properties"));
    }

    public static boolean isTableSoftDeleteEnabled(Table table, boolean isSoftDelete) {
        return isSoftDelete && TxnUtils.isTransactionalTable(table) && Boolean.parseBoolean((String)table.getParameters().get("soft_delete"));
    }

    public static String getFullTableName(String dbName, String tableName) {
        return dbName.toLowerCase() + "." + tableName.toLowerCase();
    }

    public static String[] getDbTableName(String fullTableName) {
        return fullTableName.split("\\.");
    }

    public static List<Integer> buildQueryWithINClause(Configuration conf, List<String> queries, StringBuilder prefix, StringBuilder suffix, Collection<Long> inValues, String inColumn, boolean addParens, boolean notIn) {
        List<String> inValueStrings = inValues.stream().map(Object::toString).collect(Collectors.toList());
        return TxnUtils.buildQueryWithINClauseStrings(conf, queries, prefix, suffix, inValueStrings, inColumn, addParens, notIn);
    }

    public static List<Integer> buildQueryWithINClauseStrings(Configuration conf, List<String> queries, StringBuilder prefix, StringBuilder suffix, List<String> inList, String inColumn, boolean addParens, boolean notIn) {
        int maxQueryLength = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH);
        int batchSize = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_IN_CLAUSE);
        int maxParameters = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_MAX_PARAMETERS);
        if (inList == null || inList.size() == 0 || maxQueryLength <= 0 || batchSize <= 0) {
            throw new IllegalArgumentException("The IN list is empty!");
        }
        int inListSize = inList.size();
        StringBuilder buf = new StringBuilder();
        int cursor4InListArray = 0;
        int cursor4InClauseElements = 0;
        int cursor4queryOfInClauses = 0;
        boolean nextItemNeeded = true;
        boolean newInclausePrefixJustAppended = false;
        StringBuilder nextValue = new StringBuilder("");
        StringBuilder newInclausePrefix = new StringBuilder(notIn ? " and " + inColumn + " not in (" : " or " + inColumn + " in (");
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int currentCount = 0;
        while (cursor4InListArray < inListSize || !nextItemNeeded) {
            int querySize;
            if (cursor4queryOfInClauses == 0) {
                buf.append((CharSequence)prefix);
                if (addParens) {
                    buf.append("(");
                }
                buf.append(inColumn);
                if (notIn) {
                    buf.append(" not in (");
                } else {
                    buf.append(" in (");
                }
                ++cursor4queryOfInClauses;
                newInclausePrefixJustAppended = false;
            }
            if (nextItemNeeded) {
                nextValue.setLength(0);
                nextValue.append(String.valueOf(inList.get(cursor4InListArray++)));
                nextItemNeeded = false;
            }
            if ((querySize = TxnUtils.querySizeExpected(buf.length(), nextValue.length(), suffix.length(), addParens)) > maxQueryLength * 1024 || currentCount >= maxParameters) {
                if (cursor4queryOfInClauses == 1 && cursor4InClauseElements == 0) {
                    throw new IllegalArgumentException("The current " + MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH.getVarname() + " is set too small to have one IN clause with single value!");
                }
                if (notIn) {
                    throw new IllegalArgumentException("The NOT IN list has too many elements for the current " + MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH.getVarname() + "!");
                }
                if (newInclausePrefixJustAppended) {
                    buf.delete(buf.length() - newInclausePrefix.length(), buf.length());
                }
                buf.setCharAt(buf.length() - 1, ')');
                if (addParens) {
                    buf.append(")");
                }
                buf.append((CharSequence)suffix);
                queries.add(buf.toString());
                ret.add(currentCount);
                buf.setLength(0);
                currentCount = 0;
                cursor4InClauseElements = 0;
                cursor4queryOfInClauses = 0;
                querySize = 0;
                newInclausePrefixJustAppended = false;
                continue;
            }
            if (cursor4InClauseElements >= batchSize - 1 && cursor4InClauseElements != 0) {
                buf.setCharAt(buf.length() - 1, ')');
                buf.append(newInclausePrefix.toString());
                newInclausePrefixJustAppended = true;
                ++cursor4queryOfInClauses;
                cursor4InClauseElements = 0;
                continue;
            }
            buf.append(nextValue.toString()).append(",");
            ++currentCount;
            nextItemNeeded = true;
            newInclausePrefixJustAppended = false;
            ++cursor4InClauseElements;
        }
        if (newInclausePrefixJustAppended) {
            buf.delete(buf.length() - newInclausePrefix.length(), buf.length());
        }
        buf.setCharAt(buf.length() - 1, ')');
        if (addParens) {
            buf.append(")");
        }
        buf.append((CharSequence)suffix);
        queries.add(buf.toString());
        ret.add(currentCount);
        return ret;
    }

    private static int querySizeExpected(int sizeSoFar, int sizeNextItem, int suffixSize, boolean addParens) {
        int size = sizeSoFar + sizeNextItem + suffixSize;
        if (addParens) {
            ++size;
        }
        return size;
    }

    public static String getEpochFn(DatabaseProduct dbProduct) throws MetaException {
        return dbProduct.getMillisAfterEpochFn();
    }

    public static void executeQueriesInBatchNoCount(DatabaseProduct dbProduct, Statement stmt, List<String> queries, int batchSize) throws SQLException {
        if (dbProduct.isORACLE()) {
            int queryCounter = 0;
            StringBuilder sb = new StringBuilder();
            sb.append("begin ");
            for (String query : queries) {
                LOG.debug("Adding query to batch: <" + query + ">");
                sb.append(query).append(";");
                if (++queryCounter % batchSize != 0) continue;
                sb.append("end;");
                String batch = sb.toString();
                LOG.debug("Going to execute queries in oracle anonymous statement. {}", (Object)batch);
                stmt.execute(batch);
                sb.setLength(0);
                sb.append("begin ");
            }
            if (queryCounter % batchSize != 0) {
                sb.append("end;");
                String batch = sb.toString();
                LOG.debug("Going to execute queries in oracle anonymous statement. {}", (Object)batch);
                stmt.execute(batch);
            }
        } else {
            TxnUtils.executeQueriesInBatch(stmt, queries, batchSize);
        }
    }

    public static List<Integer> executeQueriesInBatch(Statement stmt, List<String> queries, int batchSize) throws SQLException {
        ArrayList<Integer> affectedRowsByQuery = new ArrayList<Integer>();
        int queryCounter = 0;
        for (String query : queries) {
            LOG.debug("Adding query to batch: <{}>", (Object)query);
            stmt.addBatch(query);
            if (++queryCounter % batchSize != 0) continue;
            LOG.debug("Going to execute queries in batch. Batch size: {}", (Object)batchSize);
            int[] affectedRecordsByQuery = stmt.executeBatch();
            Arrays.stream(affectedRecordsByQuery).forEach(affectedRowsByQuery::add);
        }
        if (queryCounter % batchSize != 0) {
            LOG.debug("Going to execute queries in batch. Batch size: {}", (Object)(queryCounter % batchSize));
            int[] affectedRecordsByQuery = stmt.executeBatch();
            Arrays.stream(affectedRecordsByQuery).forEach(affectedRowsByQuery::add);
        }
        return affectedRowsByQuery;
    }

    public static void seedTxnSequence(Connection conn, Configuration conf, Statement stmt, long seedTxnId) throws SQLException {
        String dbProduct = conn.getMetaData().getDatabaseProductName();
        DatabaseProduct databaseProduct = DatabaseProduct.determineDatabaseProduct(dbProduct, conf);
        stmt.execute(databaseProduct.getTxnSeedFn(seedTxnId));
    }

    public static String findUserToRunAs(String location, Table t, Configuration conf) throws IOException, InterruptedException {
        LOG.debug("Determining who to run the job as.");
        String runUserAs = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_RUN_AS_USER);
        if (runUserAs != null && !"".equals(runUserAs)) {
            return runUserAs;
        }
        Path p = new Path(location);
        FileSystem fs = p.getFileSystem(conf);
        try {
            FileStatus stat = fs.getFileStatus(p);
            LOG.debug("Running job as {}", (Object)stat.getOwner());
            return stat.getOwner();
        }
        catch (AccessControlException e) {
            LOG.debug("Unable to stat file as current user, trying as table owner");
            ArrayList wrapper = new ArrayList(1);
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)t.getOwner(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            ugi.doAs(() -> {
                FileSystem proxyFs = p.getFileSystem(conf);
                FileStatus stat = proxyFs.getFileStatus(p);
                wrapper.add(stat.getOwner());
                return null;
            });
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
            catch (IOException exception) {
                LOG.error("Could not clean up file-system handles for UGI: " + String.valueOf(ugi), (Throwable)exception);
            }
            if (wrapper.size() == 1) {
                LOG.debug("Running job as {}", wrapper.get(0));
                return (String)wrapper.get(0);
            }
            LOG.error("Unable to stat file {} as either current user({}) or table owner({}), giving up", new Object[]{p, UserGroupInformation.getLoginUser(), t.getOwner()});
            throw new IOException("Unable to stat file: " + String.valueOf(p));
        }
    }

    public static CompactionType dbCompactionType2ThriftType(char dbValue) throws SQLException {
        switch (dbValue) {
            case 'a': {
                return CompactionType.MAJOR;
            }
            case 'i': {
                return CompactionType.MINOR;
            }
            case 'r': {
                return CompactionType.REBALANCE;
            }
            case 'c': {
                return CompactionType.ABORT_TXN_CLEANUP;
            }
            case '*': {
                return CompactionType.SMART_OPTIMIZE;
            }
        }
        throw new SQLException("Unexpected compaction type " + dbValue);
    }

    public static Character thriftCompactionType2DbType(CompactionType ct) throws MetaException {
        switch (ct) {
            case MAJOR: {
                return Character.valueOf('a');
            }
            case MINOR: {
                return Character.valueOf('i');
            }
            case REBALANCE: {
                return Character.valueOf('r');
            }
            case ABORT_TXN_CLEANUP: {
                return Character.valueOf('c');
            }
            case SMART_OPTIMIZE: {
                return Character.valueOf('*');
            }
        }
        throw new MetaException("Unexpected compaction type " + String.valueOf(ct));
    }

    public static String nvl(String input) {
        return input != null ? " = ? " : " IS NULL ";
    }

    public static String normalizePartitionCase(String s) {
        if (s == null) {
            return null;
        }
        Map map = Splitter.on((String)"/").withKeyValueSeparator('=').split((CharSequence)s);
        return FileUtils.makePartName(new ArrayList(map.keySet()), new ArrayList(map.values()));
    }

    public static long generateTemporaryId() {
        return -1L * ThreadLocalRandom.current().nextLong();
    }

    public static boolean isValidTxn(long txnId) {
        return txnId != 0L;
    }

    public static void raiseTxnUnexpectedState(TxnStatus actualStatus, long txnid) throws NoSuchTxnException, TxnAbortedException {
        switch (actualStatus) {
            case ABORTED: {
                throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString((long)txnid) + " already aborted");
            }
            case COMMITTED: {
                throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString((long)txnid) + " is already committed.");
            }
            case UNKNOWN: {
                throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString((long)txnid));
            }
            case OPEN: {
                throw new NoSuchTxnException(JavaUtils.txnIdToString((long)txnid) + " is " + String.valueOf((Object)TxnStatus.OPEN));
            }
        }
        throw new IllegalArgumentException("Unknown TxnStatus " + String.valueOf((Object)actualStatus));
    }

    public static SQLException getSqlException(Throwable ex) throws IllegalArgumentException {
        while (ex != null && !(ex instanceof SQLException)) {
            ex = ex.getCause();
        }
        if (ex == null) {
            throw new IllegalArgumentException("No SQLException found in the exception chain!");
        }
        return (SQLException)ex;
    }

    public static String createUpdatePreparedStmt(String tableName, List<String> columnNames, List<String> conditionKeys) {
        StringBuilder sb = new StringBuilder();
        sb.append("update " + tableName + " set ");
        sb.append(columnNames.stream().map(col -> col + "=?").collect(Collectors.joining(",")));
        sb.append(" where " + conditionKeys.stream().map(cond -> cond + "=?").collect(Collectors.joining(" and ")));
        return sb.toString();
    }

    public static String createInsertPreparedStmt(String tableName, List<String> columnNames) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into " + tableName + "(");
        sb.append(columnNames.stream().collect(Collectors.joining(",")));
        String placeholder = columnNames.stream().map(col -> "?").collect(Collectors.joining(","));
        sb.append(") values (" + placeholder + ")");
        return sb.toString();
    }
}

