/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreInit;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.PerfLogger;

public abstract class AbstractHMSHandlerProxy
implements InvocationHandler {
    protected final MetaStoreInit.MetaStoreInitData metaStoreInitData = new MetaStoreInit.MetaStoreInitData();
    protected final IHMSHandler baseHandler;
    protected final Configuration origConf;
    protected final Configuration activeConf;
    protected final boolean reloadConf;
    protected final long timeout;

    public AbstractHMSHandlerProxy(Configuration conf, IHMSHandler baseHandler, boolean local) throws MetaException {
        this.origConf = conf;
        this.baseHandler = baseHandler;
        if (local) {
            baseHandler.setConf(this.origConf);
        }
        this.activeConf = baseHandler.getConf();
        this.reloadConf = MetastoreConf.getBoolVar((Configuration)this.origConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_FORCE_RELOAD_CONF);
        this.timeout = MetastoreConf.getTimeVar((Configuration)this.origConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        MetaStoreInit.updateConnectionURL(this.origConf, this.getActiveConf(), null, this.metaStoreInitData);
        this.initBaseHandler();
    }

    protected void initBaseHandler() throws MetaException {
        this.baseHandler.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] objects) throws Throwable {
        String info;
        Object object;
        PerfLogger perfLogger = PerfLogger.getPerfLogger(false);
        perfLogger.perfLogBegin(this.getClass().getName(), method.getName());
        Result result = Result.ERROR_RESULT;
        Deadline.registerIfNot(this.timeout);
        try {
            result = this.invokeInternal(proxy, method, objects);
            object = result == null ? null : result.result;
            info = result == null ? "" : result.additionalInfo;
        }
        catch (Throwable throwable) {
            String info2 = result == null ? "" : result.additionalInfo;
            perfLogger.perfLogEnd(this.getClass().getName(), method.getName(), info2);
            throw throwable;
        }
        perfLogger.perfLogEnd(this.getClass().getName(), method.getName(), info);
        return object;
    }

    protected abstract Result invokeInternal(Object var1, Method var2, Object[] var3) throws Throwable;

    public Configuration getActiveConf() {
        return this.activeConf;
    }

    static final class Result {
        static final Result ERROR_RESULT = new Result(null, "error=true");
        private final Object result;
        private final String additionalInfo;

        public Result(Object result, String additionalInfo) {
            this.result = result;
            this.additionalInfo = additionalInfo;
        }
    }
}

