/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import java.util.Iterator;
import java.util.Map;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.LanguageFeatures;
import org.jsonschema2pojo.util.Models;

public class DynamicPropertiesRule
implements Rule<JDefinedClass, JDefinedClass> {
    public static final String NOT_FOUND_VALUE_FIELD = "NOT_FOUND_VALUE";
    public static final String SETTER_NAME = "set";
    public static final String GETTER_NAME = "get";
    public static final String BUILDER_NAME = "with";
    public static final String DEFINED_SETTER_NAME = "declaredProperty";
    public static final String DEFINED_GETTER_NAME = "declaredPropertyOrNotFound";
    private RuleFactory ruleFactory;

    public DynamicPropertiesRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JsonNode parent, JDefinedClass jclass, Schema currentSchema) {
        if (!this.ruleFactory.getGenerationConfig().isIncludeDynamicAccessors() || !this.ruleFactory.getGenerationConfig().isIncludeDynamicSetters() && !this.ruleFactory.getGenerationConfig().isIncludeDynamicGetters() && !this.ruleFactory.getGenerationConfig().isIncludeDynamicBuilders()) {
            return jclass;
        }
        boolean isIncludeGetters = this.ruleFactory.getGenerationConfig().isIncludeGetters();
        boolean isIncludeSetters = this.ruleFactory.getGenerationConfig().isIncludeSetters();
        boolean isGenerateBuilders = this.ruleFactory.getGenerationConfig().isGenerateBuilders();
        if (isIncludeGetters || isIncludeSetters || isGenerateBuilders) {
            if (LanguageFeatures.canUseJava7(this.ruleFactory.getGenerationConfig())) {
                if (isIncludeSetters) {
                    this.addInternalSetMethodJava7(jclass, node);
                }
                if (isIncludeGetters) {
                    this.addInternalGetMethodJava7(jclass, node);
                }
            } else {
                if (isIncludeSetters) {
                    this.addInternalSetMethodJava6(jclass, node);
                }
                if (isIncludeGetters) {
                    this.addInternalGetMethodJava6(jclass, node);
                }
            }
        }
        if (isIncludeGetters) {
            this.addGetMethods(jclass);
        }
        if (isIncludeSetters) {
            this.addSetMethods(jclass);
        }
        if (isGenerateBuilders) {
            this.addWithMethods(jclass);
        }
        return jclass;
    }

    void addGetMethods(JDefinedClass jclass) {
        JFieldRef notFoundVar = this.getOrAddNotFoundVar(jclass);
        JMethod internalGetMethod = this.getInternalGetMethod(jclass);
        this.addPublicGetMethod(jclass, internalGetMethod, notFoundVar);
    }

    JFieldRef getOrAddNotFoundVar(JDefinedClass jclass) {
        jclass.field(26, Object.class, NOT_FOUND_VALUE_FIELD, (JExpression)JExpr._new(jclass.owner()._ref(Object.class)));
        return jclass.staticRef(NOT_FOUND_VALUE_FIELD);
    }

    private JMethod addPublicGetMethod(JDefinedClass jclass, JMethod internalGetMethod, JFieldRef notFoundValue) {
        JMethod method = jclass.method(1, jclass.owner()._ref(Object.class), GETTER_NAME);
        JTypeVar returnType = method.generify("T");
        method.type(returnType);
        Models.suppressWarnings(method, "unchecked");
        JVar nameParam = method.param(String.class, "name");
        JBlock body = method.body();
        JVar valueVar = body.decl(jclass.owner()._ref(Object.class), "value", JExpr.invoke(internalGetMethod).arg(nameParam).arg(notFoundValue));
        JConditional found = method.body()._if(notFoundValue.ne(valueVar));
        found._then()._return(JExpr.cast(returnType, valueVar));
        JBlock notFound = found._else();
        JMethod getAdditionalProperties = jclass.getMethod("getAdditionalProperties", new JType[0]);
        if (getAdditionalProperties != null) {
            notFound._return(JExpr.cast(returnType, JExpr.invoke(getAdditionalProperties).invoke(GETTER_NAME).arg(nameParam)));
        } else {
            notFound._throw(this.illegalArgumentInvocation(jclass, nameParam));
        }
        return method;
    }

    private JMethod addInternalGetMethodJava7(JDefinedClass jclass, JsonNode propertiesNode) {
        JClass extendsType;
        JMethod method = jclass.method(2, jclass.owner()._ref(Object.class), DEFINED_GETTER_NAME);
        JVar nameParam = method.param(String.class, "name");
        JVar notFoundParam = method.param(jclass.owner()._ref(Object.class), "notFoundValue");
        JBlock body = method.body();
        JSwitch propertySwitch = body._switch(nameParam);
        if (propertiesNode != null) {
            Iterator properties = propertiesNode.fields();
            while (properties.hasNext()) {
                Map.Entry property = (Map.Entry)properties.next();
                String propertyName = (String)property.getKey();
                JsonNode node = (JsonNode)property.getValue();
                String fieldName = this.ruleFactory.getNameHelper().getPropertyName(propertyName, node);
                JType propertyType = jclass.fields().get(fieldName).type();
                this.addGetPropertyCase(jclass, propertySwitch, propertyName, propertyType, node);
            }
        }
        if ((extendsType = jclass._extends()) != null && extendsType instanceof JDefinedClass) {
            JDefinedClass parentClass = (JDefinedClass)extendsType;
            JMethod parentMethod = parentClass.getMethod(DEFINED_GETTER_NAME, new JType[]{parentClass.owner()._ref(String.class), parentClass.owner()._ref(Object.class)});
            propertySwitch._default().body()._return(JExpr._super().invoke(parentMethod).arg(nameParam).arg(notFoundParam));
        } else {
            propertySwitch._default().body()._return(notFoundParam);
        }
        return method;
    }

    private JMethod addInternalGetMethodJava6(JDefinedClass jclass, JsonNode propertiesNode) {
        JBlock lastBlock;
        JMethod method = jclass.method(2, jclass.owner()._ref(Object.class), DEFINED_GETTER_NAME);
        JVar nameParam = method.param(String.class, "name");
        JVar notFoundParam = method.param(jclass.owner()._ref(Object.class), "notFoundValue");
        JBlock body = method.body();
        JConditional propertyConditional = null;
        if (propertiesNode != null) {
            Iterator properties = propertiesNode.fields();
            while (properties.hasNext()) {
                Map.Entry property = (Map.Entry)properties.next();
                String propertyName = (String)property.getKey();
                JsonNode node = (JsonNode)property.getValue();
                String fieldName = this.ruleFactory.getNameHelper().getPropertyName(propertyName, node);
                JType propertyType = jclass.fields().get(fieldName).type();
                JInvocation condition = JExpr.lit(propertyName).invoke("equals").arg(nameParam);
                propertyConditional = propertyConditional == null ? body._if(condition) : propertyConditional._elseif(condition);
                JMethod propertyGetter = jclass.getMethod(this.getGetterName(propertyName, propertyType, node), new JType[0]);
                propertyConditional._then()._return(JExpr.invoke(propertyGetter));
            }
        }
        JClass extendsType = jclass._extends();
        JBlock jBlock = lastBlock = propertyConditional == null ? body : propertyConditional._else();
        if (extendsType != null && extendsType instanceof JDefinedClass) {
            JDefinedClass parentClass = (JDefinedClass)extendsType;
            JMethod parentMethod = parentClass.getMethod(DEFINED_GETTER_NAME, new JType[]{parentClass.owner()._ref(String.class), parentClass.owner()._ref(Object.class)});
            lastBlock._return(JExpr._super().invoke(parentMethod).arg(nameParam).arg(notFoundParam));
        } else {
            lastBlock._return(notFoundParam);
        }
        return method;
    }

    private void addGetPropertyCase(JDefinedClass jclass, JSwitch propertySwitch, String propertyName, JType propertyType, JsonNode node) {
        JMethod propertyGetter = jclass.getMethod(this.getGetterName(propertyName, propertyType, node), new JType[0]);
        propertySwitch._case(JExpr.lit(propertyName)).body()._return(JExpr.invoke(propertyGetter));
    }

    private void addSetMethods(JDefinedClass jclass) {
        JMethod internalSetMethod = this.getInternalSetMethod(jclass);
        this.addPublicSetMethod(jclass, internalSetMethod);
    }

    private JMethod addPublicSetMethod(JDefinedClass jclass, JMethod internalSetMethod) {
        JMethod method = jclass.method(1, jclass.owner().VOID, SETTER_NAME);
        JVar nameParam = method.param(String.class, "name");
        JVar valueParam = method.param(Object.class, "value");
        JBlock body = method.body();
        JBlock notFound = body._if(JOp.not(JExpr.invoke(internalSetMethod).arg(nameParam).arg(valueParam)))._then();
        JMethod getAdditionalProperties = jclass.getMethod("getAdditionalProperties", new JType[0]);
        if (getAdditionalProperties != null) {
            JType additionalPropertiesType = ((JClass)getAdditionalProperties.type()).getTypeParameters().get(1);
            notFound.add(JExpr.invoke(getAdditionalProperties).invoke("put").arg(nameParam).arg(JExpr.cast(additionalPropertiesType, valueParam)));
        } else {
            notFound._throw(this.illegalArgumentInvocation(jclass, nameParam));
        }
        return method;
    }

    private void addWithMethods(JDefinedClass jclass) {
        JMethod internalSetMethod = this.getInternalSetMethod(jclass);
        this.addPublicWithMethod(jclass, internalSetMethod);
    }

    private JMethod addPublicWithMethod(JDefinedClass jclass, JMethod internalSetMethod) {
        JMethod method = jclass.method(1, jclass, BUILDER_NAME);
        JVar nameParam = method.param(String.class, "name");
        JVar valueParam = method.param(Object.class, "value");
        JBlock body = method.body();
        JBlock notFound = body._if(JOp.not(JExpr.invoke(internalSetMethod).arg(nameParam).arg(valueParam)))._then();
        JMethod getAdditionalProperties = jclass.getMethod("getAdditionalProperties", new JType[0]);
        if (getAdditionalProperties != null) {
            JType additionalPropertiesType = ((JClass)getAdditionalProperties.type()).getTypeParameters().get(1);
            notFound.add(JExpr.invoke(getAdditionalProperties).invoke("put").arg(nameParam).arg(JExpr.cast(additionalPropertiesType, valueParam)));
        } else {
            notFound._throw(this.illegalArgumentInvocation(jclass, nameParam));
        }
        body._return(JExpr._this());
        return method;
    }

    private JMethod addInternalSetMethodJava7(JDefinedClass jclass, JsonNode propertiesNode) {
        JMethod method = jclass.method(2, jclass.owner().BOOLEAN, DEFINED_SETTER_NAME);
        JVar nameParam = method.param(String.class, "name");
        JVar valueParam = method.param(Object.class, "value");
        JBlock body = method.body();
        JSwitch propertySwitch = body._switch(nameParam);
        if (propertiesNode != null) {
            Iterator properties = propertiesNode.fields();
            while (properties.hasNext()) {
                Map.Entry property = (Map.Entry)properties.next();
                String propertyName = (String)property.getKey();
                JsonNode node = (JsonNode)property.getValue();
                String fieldName = this.ruleFactory.getNameHelper().getPropertyName(propertyName, node);
                JType propertyType = jclass.fields().get(fieldName).type();
                this.addSetPropertyCase(jclass, propertySwitch, propertyName, propertyType, valueParam, node);
            }
        }
        JBlock defaultBlock = propertySwitch._default().body();
        JClass extendsType = jclass._extends();
        if (extendsType != null && extendsType instanceof JDefinedClass) {
            JDefinedClass parentClass = (JDefinedClass)extendsType;
            JMethod parentMethod = parentClass.getMethod(DEFINED_SETTER_NAME, new JType[]{parentClass.owner()._ref(String.class), parentClass.owner()._ref(Object.class)});
            defaultBlock._return(JExpr._super().invoke(parentMethod).arg(nameParam).arg(valueParam));
        } else {
            defaultBlock._return(JExpr.FALSE);
        }
        return method;
    }

    private JMethod addInternalSetMethodJava6(JDefinedClass jclass, JsonNode propertiesNode) {
        JBlock lastBlock;
        JMethod method = jclass.method(2, jclass.owner().BOOLEAN, DEFINED_SETTER_NAME);
        JVar nameParam = method.param(String.class, "name");
        JVar valueParam = method.param(Object.class, "value");
        JBlock body = method.body();
        JConditional propertyConditional = null;
        if (propertiesNode != null) {
            Iterator properties = propertiesNode.fields();
            while (properties.hasNext()) {
                Map.Entry property = (Map.Entry)properties.next();
                String propertyName = (String)property.getKey();
                JsonNode node = (JsonNode)property.getValue();
                String fieldName = this.ruleFactory.getNameHelper().getPropertyName(propertyName, node);
                JType propertyType = jclass.fields().get(fieldName).type();
                JInvocation condition = JExpr.lit(propertyName).invoke("equals").arg(nameParam);
                propertyConditional = propertyConditional == null ? (propertyConditional = body._if(condition)) : propertyConditional._elseif(condition);
                JBlock callSite = propertyConditional._then();
                this.addSetProperty(jclass, callSite, propertyName, propertyType, valueParam, node);
                callSite._return(JExpr.TRUE);
            }
        }
        JClass extendsType = jclass._extends();
        JBlock jBlock = lastBlock = propertyConditional == null ? body : propertyConditional._else();
        if (extendsType != null && extendsType instanceof JDefinedClass) {
            JDefinedClass parentClass = (JDefinedClass)extendsType;
            JMethod parentMethod = parentClass.getMethod(DEFINED_SETTER_NAME, new JType[]{parentClass.owner()._ref(String.class), parentClass.owner()._ref(Object.class)});
            lastBlock._return(JExpr._super().invoke(parentMethod).arg(nameParam).arg(valueParam));
        } else {
            lastBlock._return(JExpr.FALSE);
        }
        return method;
    }

    private JMethod getInternalSetMethod(JDefinedClass jclass) {
        return jclass.getMethod(DEFINED_SETTER_NAME, new JType[]{jclass.owner().ref(String.class), jclass.owner().ref(Object.class)});
    }

    private JMethod getInternalGetMethod(JDefinedClass jclass) {
        return jclass.getMethod(DEFINED_GETTER_NAME, new JType[]{jclass.owner().ref(String.class), jclass.owner().ref(Object.class)});
    }

    private void addSetPropertyCase(JDefinedClass jclass, JSwitch setterSwitch, String propertyName, JType propertyType, JVar valueVar, JsonNode node) {
        JBlock setterBody = setterSwitch._case(JExpr.lit(propertyName)).body();
        this.addSetProperty(jclass, setterBody, propertyName, propertyType, valueVar, node);
        setterBody._return(JExpr.TRUE);
    }

    private void addSetProperty(JDefinedClass jclass, JBlock callSite, String propertyName, JType propertyType, JVar valueVar, JsonNode node) {
        JMethod propertySetter = jclass.getMethod(this.getSetterName(propertyName, node), new JType[]{propertyType});
        JConditional isInstance = callSite._if(valueVar._instanceof(propertyType.boxify().erasure()));
        isInstance._then().invoke(propertySetter).arg(JExpr.cast(propertyType.boxify(), valueVar));
        isInstance._else()._throw(this.illegalArgumentInvocation(jclass, propertyName, propertyType, valueVar));
    }

    private JInvocation illegalArgumentInvocation(JDefinedClass jclass, JVar propertyName) {
        return JExpr._new(jclass.owner()._ref(IllegalArgumentException.class)).arg(JExpr.lit("property \"").plus(propertyName).plus(JExpr.lit("\" is not defined")));
    }

    private JInvocation illegalArgumentInvocation(JDefinedClass jclass, String propertyName, JType propertyType, JVar valueVar) {
        return JExpr._new(jclass.owner()._ref(IllegalArgumentException.class)).arg(JExpr.lit("property \"" + propertyName + "\" is of type \"" + propertyType.fullName() + "\", but got ").plus(valueVar.invoke("getClass").invoke("toString")));
    }

    private String getSetterName(String propertyName, JsonNode node) {
        return this.ruleFactory.getNameHelper().getSetterName(propertyName, node);
    }

    private String getGetterName(String propertyName, JType type, JsonNode node) {
        return this.ruleFactory.getNameHelper().getGetterName(propertyName, type, node);
    }
}

