/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;

public class HiveSQLException
extends SQLException {
    public static final String QUERY_ID = "Query ID";
    private static final long serialVersionUID = -6095254671958748095L;
    private String queryId;
    @VisibleForTesting
    public static final List<String> DEFAULT_INFO = Collections.singletonList("Server-side error; please check HS2 logs.");

    @Deprecated
    public HiveSQLException() {
    }

    @Deprecated
    public HiveSQLException(String reason) {
        super(reason);
    }

    @Deprecated
    public HiveSQLException(Throwable cause) {
        super(cause);
    }

    public HiveSQLException(Throwable cause, String queryId) {
        super(cause);
        this.queryId = queryId;
    }

    @Deprecated
    public HiveSQLException(String reason, String sqlState) {
        super(reason, sqlState);
    }

    public HiveSQLException(String reason, String sqlState, String queryId) {
        super(reason, sqlState);
        this.queryId = queryId;
    }

    @Deprecated
    public HiveSQLException(String reason, Throwable cause) {
        super(reason, cause);
    }

    public HiveSQLException(String reason, Throwable cause, String queryId) {
        super(reason, cause);
        this.queryId = queryId;
    }

    @Deprecated
    public HiveSQLException(String reason, String sqlState, int vendorCode) {
        super(reason, sqlState, vendorCode);
    }

    public HiveSQLException(String reason, String sqlState, int vendorCode, String queryId) {
        super(reason, sqlState, vendorCode);
        this.queryId = queryId;
    }

    @Deprecated
    public HiveSQLException(String reason, String sqlState, Throwable cause) {
        super(reason, sqlState, cause);
    }

    public HiveSQLException(String reason, String sqlState, Throwable cause, String queryId) {
        super(reason, sqlState, cause);
        this.queryId = queryId;
    }

    @Deprecated
    public HiveSQLException(String reason, String sqlState, int vendorCode, Throwable cause) {
        super(reason, sqlState, vendorCode, cause);
    }

    @Deprecated
    public HiveSQLException(TStatus status) {
        super(status.getErrorMessage(), status.getSqlState(), status.getErrorCode());
    }

    public TStatus toTStatus() {
        TStatus tStatus = new TStatus(TStatusCode.ERROR_STATUS);
        tStatus.setSqlState(this.getSQLState());
        tStatus.setErrorCode(this.getErrorCode());
        tStatus.setErrorMessage(this.getMessage());
        tStatus.setInfoMessages(DEFAULT_INFO);
        return tStatus;
    }

    public static TStatus toTStatus(Exception e) {
        if (e instanceof HiveSQLException) {
            return ((HiveSQLException)e).toTStatus();
        }
        TStatus tStatus = new TStatus(TStatusCode.ERROR_STATUS);
        tStatus.setErrorMessage(e.getMessage());
        tStatus.setInfoMessages(DEFAULT_INFO);
        return tStatus;
    }

    @Override
    public String getMessage() {
        String errorMsg;
        String string = errorMsg = super.getMessage() == null ? "Error" : super.getMessage();
        if (!errorMsg.contains(QUERY_ID) && this.queryId != null) {
            return String.format("%s; Query ID: %s", errorMsg, this.queryId);
        }
        return errorMsg;
    }
}

