/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import com.google.protobuf.CodedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.ql.io.orc.encoded.LlapDataReader;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.DataReaderProperties;
import org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.HadoopShimsFactory;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.OrcCodecPool;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.RecordReaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapRecordReaderUtils {
    private static final HadoopShims SHIMS = HadoopShimsFactory.get();
    private static final Logger LOG = LoggerFactory.getLogger(LlapRecordReaderUtils.class);

    static HadoopShims.ZeroCopyReaderShim createZeroCopyShim(FSDataInputStream file, CompressionCodec codec, RecordReaderUtils.ByteBufferAllocatorPool pool) throws IOException {
        return codec == null || codec instanceof DirectDecompressionCodec && ((DirectDecompressionCodec)codec).isAvailable() ? SHIMS.getZeroCopyReader(file, (HadoopShims.ByteBufferPoolShim)pool) : null;
    }

    public static LlapDataReader createDefaultLlapDataReader(DataReaderProperties properties) {
        return new DefaultLLapDataReader(properties);
    }

    static DiskRangeList readDiskRanges(FSDataInputStream file, HadoopShims.ZeroCopyReaderShim zcr, long base, DiskRangeList range, boolean doForceDirect, int maxChunkLimit) throws IOException {
        if (range == null) {
            return null;
        }
        DiskRangeList prev = range.prev;
        if (prev == null) {
            prev = new DiskRangeList.MutateHelper(range);
        }
        while (range != null) {
            if (range.hasData()) {
                range = range.next;
                continue;
            }
            boolean firstRead = true;
            long len = range.getEnd() - range.getOffset();
            long off = range.getOffset();
            while (len > 0L) {
                ByteBuffer partial;
                int readSize;
                int n = readSize = len >= (long)maxChunkLimit ? maxChunkLimit : (int)len;
                if (zcr != null) {
                    if (firstRead) {
                        file.seek(base + off);
                    }
                    partial = zcr.readBuffer(readSize, false);
                    readSize = partial.remaining();
                } else {
                    byte[] buffer = new byte[readSize];
                    file.readFully(base + off, buffer, 0, buffer.length);
                    if (doForceDirect) {
                        partial = ByteBuffer.allocateDirect(readSize);
                        partial.put(buffer);
                        partial.position(0);
                        partial.limit(readSize);
                    } else {
                        partial = ByteBuffer.wrap(buffer);
                    }
                }
                BufferChunk bc = new BufferChunk(partial, off);
                if (firstRead) {
                    range.replaceSelfWith((DiskRangeList)bc);
                } else {
                    range.insertAfter((DiskRangeList)bc);
                }
                firstRead = false;
                range = bc;
                len -= (long)readSize;
                off += (long)readSize;
            }
            range = range.next;
        }
        return prev.next;
    }

    public static DiskRangeList planIndexReading(TypeDescription fileSchema, OrcProto.StripeFooter footer, boolean ignoreNonUtf8BloomFilter, boolean[] fileIncluded, boolean[] sargColumns, OrcFile.WriterVersion version, OrcProto.Stream.Kind[] bloomFilterKinds) {
        DiskRangeList.CreateHelper result = new DiskRangeList.CreateHelper();
        List streams = footer.getStreamsList();
        if (sargColumns != null) {
            for (OrcProto.Stream stream : streams) {
                int column;
                if (!stream.hasKind() || !stream.hasColumn() || !sargColumns[column = stream.getColumn()]) continue;
                switch (stream.getKind()) {
                    case BLOOM_FILTER: {
                        if (bloomFilterKinds[column] != null || ignoreNonUtf8BloomFilter && LlapRecordReaderUtils.hadBadBloomFilters(fileSchema.findSubtype(column).getCategory(), version)) break;
                        bloomFilterKinds[column] = OrcProto.Stream.Kind.BLOOM_FILTER;
                        break;
                    }
                    case BLOOM_FILTER_UTF8: {
                        bloomFilterKinds[column] = OrcProto.Stream.Kind.BLOOM_FILTER_UTF8;
                        break;
                    }
                }
            }
        }
        long offset = 0L;
        for (OrcProto.Stream stream : footer.getStreamsList()) {
            if (stream.hasKind() && stream.hasColumn()) {
                int column = stream.getColumn();
                if (fileIncluded == null || fileIncluded[column]) {
                    boolean needStream = false;
                    switch (stream.getKind()) {
                        case ROW_INDEX: {
                            needStream = true;
                            break;
                        }
                        case BLOOM_FILTER: {
                            needStream = bloomFilterKinds[column] == OrcProto.Stream.Kind.BLOOM_FILTER;
                            break;
                        }
                        case BLOOM_FILTER_UTF8: {
                            needStream = bloomFilterKinds[column] == OrcProto.Stream.Kind.BLOOM_FILTER_UTF8;
                            break;
                        }
                    }
                    if (needStream) {
                        result.addOrMerge(offset, offset + stream.getLength(), true, false);
                    }
                }
            }
            offset += stream.getLength();
        }
        return result.get();
    }

    static boolean hadBadBloomFilters(TypeDescription.Category category, OrcFile.WriterVersion version) {
        switch (category) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return !version.includes(OrcFile.WriterVersion.HIVE_12055);
            }
            case DECIMAL: {
                return true;
            }
            case TIMESTAMP: {
                return !version.includes(OrcFile.WriterVersion.ORC_135);
            }
        }
        return false;
    }

    private static class DefaultLLapDataReader
    implements LlapDataReader {
        private FSDataInputStream file;
        private RecordReaderUtils.ByteBufferAllocatorPool pool;
        private HadoopShims.ZeroCopyReaderShim zcr = null;
        private final Supplier<FileSystem> fileSystemSupplier;
        private final Path path;
        private final boolean useZeroCopy;
        private CompressionCodec codec;
        private final int bufferSize;
        private CompressionKind compressionKind;
        private final int maxDiskRangeChunkLimit;
        private boolean isOpen = false;

        private DefaultLLapDataReader(DataReaderProperties properties) {
            this.fileSystemSupplier = properties.getFileSystemSupplier();
            this.path = properties.getPath();
            this.file = properties.getFile();
            this.useZeroCopy = properties.getZeroCopy();
            this.codec = properties.getCompression() == null ? null : properties.getCompression().getCodec();
            this.compressionKind = this.codec == null ? CompressionKind.NONE : this.codec.getKind();
            this.bufferSize = this.codec == null ? 0 : properties.getCompression().getBufferSize();
            this.maxDiskRangeChunkLimit = properties.getMaxDiskRangeChunkLimit();
        }

        public void open() throws IOException {
            if (this.file == null) {
                this.file = this.fileSystemSupplier.get().open(this.path);
            }
            if (this.useZeroCopy) {
                this.pool = new RecordReaderUtils.ByteBufferAllocatorPool();
                this.zcr = LlapRecordReaderUtils.createZeroCopyShim(this.file, this.codec, this.pool);
            } else {
                this.zcr = null;
            }
            this.isOpen = true;
        }

        public OrcIndex readRowIndex(StripeInformation stripe, TypeDescription fileSchema, OrcProto.StripeFooter footer, boolean ignoreNonUtf8BloomFilter, boolean[] included, OrcProto.RowIndex[] indexes, boolean[] sargColumns, OrcFile.WriterVersion version, OrcProto.Stream.Kind[] bloomFilterKinds, OrcProto.BloomFilterIndex[] bloomFilterIndices) throws IOException {
            if (!this.isOpen) {
                this.open();
            }
            if (footer == null) {
                footer = this.readStripeFooter(stripe);
            }
            if (indexes == null) {
                indexes = new OrcProto.RowIndex[fileSchema.getMaximumId() + 1];
            }
            if (bloomFilterKinds == null) {
                bloomFilterKinds = new OrcProto.Stream.Kind[fileSchema.getMaximumId() + 1];
            }
            if (bloomFilterIndices == null) {
                bloomFilterIndices = new OrcProto.BloomFilterIndex[fileSchema.getMaximumId() + 1];
            }
            DiskRangeList ranges = LlapRecordReaderUtils.planIndexReading(fileSchema, footer, ignoreNonUtf8BloomFilter, included, sargColumns, version, bloomFilterKinds);
            ranges = LlapRecordReaderUtils.readDiskRanges(this.file, this.zcr, stripe.getOffset(), ranges, false, this.maxDiskRangeChunkLimit);
            long offset = 0L;
            DiskRangeList range = ranges;
            for (OrcProto.Stream stream : footer.getStreamsList()) {
                while (range != null && range.getEnd() <= offset) {
                    range = range.next;
                }
                if (range == null) break;
                InStream.StreamOptions compression = null;
                try (CompressionCodec codec = OrcCodecPool.getCodec((CompressionKind)this.compressionKind);){
                    if (codec != null) {
                        compression = InStream.options().withCodec(codec).withBufferSize(this.bufferSize);
                    }
                }
                int column = stream.getColumn();
                if (stream.hasKind() && range.getOffset() <= offset) {
                    switch (stream.getKind()) {
                        case ROW_INDEX: {
                            if (included != null && !included[column]) break;
                            ByteBuffer bb = range.getData().duplicate();
                            bb.position((int)(offset - range.getOffset()));
                            bb.limit((int)((long)bb.position() + stream.getLength()));
                            indexes[column] = OrcProto.RowIndex.parseFrom((CodedInputStream)InStream.createCodedInputStream((InStream)InStream.create((Object)"index", (DiskRangeList)new BufferChunk(bb, 0L), (long)0L, (long)stream.getLength(), (InStream.StreamOptions)compression)));
                            break;
                        }
                        case BLOOM_FILTER: 
                        case BLOOM_FILTER_UTF8: {
                            if (sargColumns == null || !sargColumns[column]) break;
                            ByteBuffer bb = range.getData().duplicate();
                            bb.position((int)(offset - range.getOffset()));
                            bb.limit((int)((long)bb.position() + stream.getLength()));
                            bloomFilterIndices[column] = OrcProto.BloomFilterIndex.parseFrom((CodedInputStream)InStream.createCodedInputStream((InStream)InStream.create((Object)"bloom_filter", (DiskRangeList)new BufferChunk(bb, 0L), (long)0L, (long)stream.getLength(), (InStream.StreamOptions)compression)));
                            break;
                        }
                    }
                }
                offset += stream.getLength();
            }
            return new OrcIndex(indexes, bloomFilterKinds, bloomFilterIndices);
        }

        public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
            if (!this.isOpen) {
                this.open();
            }
            long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
            int tailLength = (int)stripe.getFooterLength();
            InStream.StreamOptions compression = null;
            try (CompressionCodec codec = OrcCodecPool.getCodec((CompressionKind)this.compressionKind);){
                if (codec != null) {
                    compression = InStream.options().withCodec(codec).withBufferSize(this.bufferSize);
                }
            }
            ByteBuffer tailBuf = ByteBuffer.allocate(tailLength);
            this.file.readFully(offset, tailBuf.array(), tailBuf.arrayOffset(), tailLength);
            return OrcProto.StripeFooter.parseFrom((CodedInputStream)InStream.createCodedInputStream((InStream)InStream.create((Object)"footer", (DiskRangeList)new BufferChunk(tailBuf, 0L), (long)0L, (long)tailLength, (InStream.StreamOptions)compression)));
        }

        public DiskRangeList readFileData(DiskRangeList range, long baseOffset, boolean doForceDirect) throws IOException {
            return LlapRecordReaderUtils.readDiskRanges(this.file, this.zcr, baseOffset, range, doForceDirect, this.maxDiskRangeChunkLimit);
        }

        public void close() throws IOException {
            if (this.codec != null) {
                OrcCodecPool.returnCodec((CompressionKind)this.compressionKind, (CompressionCodec)this.codec);
                this.codec = null;
            }
            if (this.pool != null) {
                this.pool.clear();
            }
            IOUtils.close((Closeable[])new Closeable[]{this.zcr, this.file});
            this.zcr = null;
            this.file = null;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public boolean isTrackingDiskRanges() {
            return this.zcr != null;
        }

        public void releaseBuffer(ByteBuffer buffer) {
            this.zcr.releaseBuffer(buffer);
        }

        public LlapDataReader clone() {
            if (this.file != null) {
                LOG.warn("Cloning an opened DataReader; the stream will be reused and closed twice");
            }
            try {
                DefaultLLapDataReader clone = (DefaultLLapDataReader)super.clone();
                if (this.codec != null) {
                    clone.codec = OrcCodecPool.getCodec((CompressionKind)clone.compressionKind);
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException("uncloneable", e);
            }
        }

        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }
    }
}

