/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.util;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BitHashSet
implements Iterable<Integer> {
    private final BitSet elementBits = new BitSet();
    private final Set<Integer> cache = new HashSet<Integer>();
    private final int cacheSize;
    private int elementCount = 0;

    public BitHashSet() {
        this(Integer.getInteger("zookeeper.bitHashCacheSize", 10));
    }

    public BitHashSet(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public synchronized boolean add(Integer elementBit) {
        if (elementBit == null || this.elementBits.get(elementBit)) {
            return false;
        }
        if (this.cache.size() < this.cacheSize) {
            this.cache.add(elementBit);
        }
        this.elementBits.set(elementBit);
        ++this.elementCount;
        return true;
    }

    public synchronized int remove(Set<Integer> bitSet, BitSet bits) {
        this.cache.removeAll(bitSet);
        this.elementBits.andNot(bits);
        int elementCountBefore = this.elementCount;
        this.elementCount = this.elementBits.cardinality();
        return elementCountBefore - this.elementCount;
    }

    public synchronized boolean remove(Integer elementBit) {
        if (elementBit == null || !this.elementBits.get(elementBit)) {
            return false;
        }
        this.cache.remove(elementBit);
        this.elementBits.clear(elementBit);
        --this.elementCount;
        return true;
    }

    public synchronized boolean contains(Integer elementBit) {
        if (elementBit == null) {
            return false;
        }
        return this.elementBits.get(elementBit);
    }

    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public Iterator<Integer> iterator() {
        final int currentSize = this.size();
        if (this.cache.size() == currentSize) {
            return this.cache.iterator();
        }
        return new Iterator<Integer>(){
            int returnedCount = 0;
            int bitIndex = 0;

            @Override
            public boolean hasNext() {
                return this.returnedCount < currentSize;
            }

            @Override
            public Integer next() {
                int bit = BitHashSet.this.elementBits.nextSetBit(this.bitIndex);
                this.bitIndex = bit + 1;
                ++this.returnedCount;
                return bit;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public synchronized int cachedSize() {
        return this.cache.size();
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }
}

