/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Test;

public class TestViewFileSystemClose
extends AbstractHadoopTestBase {
    @Test
    public void testFileSystemLeak() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.viewfs.impl", ViewFileSystem.class.getName());
        conf.setBoolean("fs.viewfs.enable.inner.cache", false);
        conf.setBoolean("fs.viewfs.impl.disable.cache", true);
        conf.setBoolean("fs.hdfs.impl.disable.cache", true);
        String rootPath = "hdfs://localhost/tmp";
        ConfigUtil.addLink((Configuration)conf, (String)"/data", (URI)new Path(rootPath, "data").toUri());
        ViewFileSystem viewFs = (ViewFileSystem)FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        FileSystem[] children = viewFs.getChildFileSystems();
        viewFs.close();
        FileSystem.closeAll();
        for (FileSystem fs : children) {
            LambdaTestUtils.intercept(IOException.class, (String)"Filesystem closed", (String)"Expect Filesystem closed IOException", () -> fs.create(new Path(rootPath, "neverSuccess")));
        }
    }
}

