/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.AbstractFpgaVendorPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery.AoclOutputBasedDiscoveryStrategy;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery.FPGADiscoveryStrategy;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery.ScriptBasedFPGADiscoveryStrategy;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery.SettingsBasedFPGADiscoveryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FpgaDiscoverer
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(FpgaDiscoverer.class);
    private AbstractFpgaVendorPlugin plugin = null;
    private List<FpgaDevice> currentFpgaInfo = null;
    private Function<String, Optional<String>> scriptRunner = this::runScript;
    public static final int MAX_EXEC_TIMEOUT_MS = 10000;

    @VisibleForTesting
    void setScriptRunner(Function<String, Optional<String>> scriptRunner) {
        this.scriptRunner = scriptRunner;
    }

    public List<FpgaDevice> getCurrentFpgaInfo() {
        return this.currentFpgaInfo;
    }

    public void setResourceHanderPlugin(AbstractFpgaVendorPlugin vendorPlugin) {
        this.plugin = vendorPlugin;
    }

    public boolean diagnose() {
        return this.plugin.diagnose(10000);
    }

    public void initialize(Configuration config) throws YarnException {
        this.setConf(config);
        this.plugin.initPlugin(config);
        LOG.info("Trying to diagnose FPGA information ...");
        if (!this.diagnose()) {
            LOG.warn("Failed to pass FPGA devices diagnose");
        }
    }

    public List<FpgaDevice> discover() throws ResourceHandlerException {
        String allowed = this.getConf().get("yarn.nodemanager.resource-plugins.fpga.allowed-fpga-devices");
        String availableDevices = this.getConf().get("yarn.nodemanager.resource-plugins.fpga.available-devices");
        String discoveryScript = this.getConf().get("yarn.nodemanager.resource-plugins.fpga.device-discovery-script");
        FPGADiscoveryStrategy discoveryStrategy = availableDevices != null ? new SettingsBasedFPGADiscoveryStrategy(this.plugin.getFpgaType(), availableDevices) : (discoveryScript != null ? new ScriptBasedFPGADiscoveryStrategy(this.plugin.getFpgaType(), this.scriptRunner, discoveryScript) : new AoclOutputBasedDiscoveryStrategy(this.plugin));
        List<FpgaDevice> list = discoveryStrategy.discover();
        if (allowed == null || allowed.equalsIgnoreCase("auto")) {
            this.currentFpgaInfo = ImmutableList.copyOf(list);
            return list;
        }
        if (allowed.matches("(\\d,)*\\d")) {
            HashSet minors = Sets.newHashSet((Object[])allowed.split(","));
            list = list.stream().filter(dev -> minors.contains(String.valueOf(dev.getMinor()))).collect(Collectors.toList());
            this.currentFpgaInfo = ImmutableList.copyOf(list);
            if (list.size() != minors.size()) {
                LOG.warn("We continue although there're mistakes in user's configuration yarn.nodemanager.resource-plugins.fpga.allowed-fpga-devicesuser configured:" + allowed + ", while the real:" + list.toString());
            }
        } else {
            throw new ResourceHandlerException("Invalid value configured for yarn.nodemanager.resource-plugins.fpga.allowed-fpga-devices:\"" + allowed + "\"");
        }
        return list;
    }

    private Optional<String> runScript(String path) {
        if (path == null || path.trim().isEmpty()) {
            LOG.error("Undefined script");
            return Optional.empty();
        }
        File f = new File(path);
        if (!f.exists()) {
            LOG.error("Script does not exist");
            return Optional.empty();
        }
        if (!FileUtil.canExecute((File)f)) {
            LOG.error("Script is not executable");
            return Optional.empty();
        }
        Shell.ShellCommandExecutor shell = new Shell.ShellCommandExecutor(new String[]{path}, null, null, 10000L);
        try {
            shell.execute();
            String output = shell.getOutput();
            return Optional.of(output);
        }
        catch (IOException e) {
            LOG.error("Cannot execute script", (Throwable)e);
            return Optional.empty();
        }
    }
}

