/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotWhileRSCrashes {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotWhileRSCrashes.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"Cleanup");
    private static byte[] CF = Bytes.toBytes((String)"cf");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(3);
        UTIL.createMultiRegionTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws InterruptedException, IOException {
        String snName = "sn";
        LockManager.MasterLock lock = UTIL.getMiniHBaseCluster().getMaster().getLockManager().createMasterLock(NAME, LockType.EXCLUSIVE, "for testing");
        lock.tryAcquire(0L);
        Thread t = new Thread(() -> {
            try {
                UTIL.getAdmin().snapshot(snName, NAME);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        t.setDaemon(true);
        t.start();
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        UTIL.waitFor(10000L, () -> procExec.getProcedures().stream().filter(p -> !p.isFinished()).filter(p -> p instanceof LockProcedure).map(p -> (LockProcedure)p).filter(p -> NAME.equals((Object)p.getTableName())).anyMatch(p -> !p.isLocked()));
        UTIL.getMiniHBaseCluster().stopRegionServer(0);
        lock.release();
        try (Table table = UTIL.getConnection().getTable(NAME);
             ResultScanner scanner = table.getScanner(CF);){
            Assert.assertNull((Object)scanner.next());
        }
    }
}

