/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.crypto.SecretKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.security.SecureShuffleUtils;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;

public class CommonStub {
    protected Socket socket = null;
    protected DataInputStream dataInput;
    protected DataOutputStream dataOut;

    protected String createDigest(byte[] password, String data) throws IOException {
        SecretKey key = JobTokenSecretManager.createSecretKey((byte[])password);
        return SecureShuffleUtils.hashFromString((String)data, (SecretKey)key);
    }

    protected void readObject(Writable obj, DataInputStream inStream) throws IOException {
        int numBytes = WritableUtils.readVInt((DataInput)inStream);
        if (obj instanceof BytesWritable) {
            byte[] buffer = new byte[numBytes];
            inStream.readFully(buffer);
            ((BytesWritable)obj).set(buffer, 0, numBytes);
        } else if (obj instanceof Text) {
            byte[] buffer = new byte[numBytes];
            inStream.readFully(buffer);
            ((Text)obj).set(buffer);
        } else {
            obj.readFields((DataInput)inStream);
        }
    }

    protected void writeObject(Writable obj, DataOutputStream stream) throws IOException {
        DataOutputBuffer buffer = new DataOutputBuffer();
        if (obj instanceof Text) {
            Text t = (Text)obj;
            int len = t.getLength();
            WritableUtils.writeVLong((DataOutput)stream, (long)len);
            stream.flush();
            stream.write(t.getBytes(), 0, len);
            stream.flush();
        } else if (obj instanceof BytesWritable) {
            BytesWritable b = (BytesWritable)obj;
            int len = b.getLength();
            WritableUtils.writeVLong((DataOutput)stream, (long)len);
            stream.write(b.getBytes(), 0, len);
        } else {
            buffer.reset();
            obj.write((DataOutput)buffer);
            int length = buffer.getLength();
            WritableUtils.writeVInt((DataOutput)stream, (int)length);
            stream.write(buffer.getData(), 0, length);
        }
        stream.flush();
    }

    protected void initSoket() throws Exception {
        int port = Integer.parseInt(System.getenv("mapreduce.pipes.command.port"));
        InetAddress address = InetAddress.getLocalHost();
        this.socket = new Socket(address.getHostName(), port);
        InputStream input = this.socket.getInputStream();
        OutputStream output = this.socket.getOutputStream();
        this.dataInput = new DataInputStream(input);
        WritableUtils.readVInt((DataInput)this.dataInput);
        String str = Text.readString((DataInput)this.dataInput);
        Text.readString((DataInput)this.dataInput);
        this.dataOut = new DataOutputStream(output);
        WritableUtils.writeVInt((DataOutput)this.dataOut, (int)57);
        String s = this.createDigest("password".getBytes(), str);
        Text.writeString((DataOutput)this.dataOut, (String)s);
        WritableUtils.readVInt((DataInput)this.dataInput);
        int cuttentAnswer = WritableUtils.readVInt((DataInput)this.dataInput);
        System.out.println("CURRENT_PROTOCOL_VERSION:" + cuttentAnswer);
        WritableUtils.readVInt((DataInput)this.dataInput);
        int j = WritableUtils.readVInt((DataInput)this.dataInput);
        for (int i = 0; i < j; ++i) {
            Text.readString((DataInput)this.dataInput);
            ++i;
            Text.readString((DataInput)this.dataInput);
        }
    }

    protected void closeSoket() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

