/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, LargeTests.class})
public class TestHRegionServerBulkLoadWithOldClient
extends TestHRegionServerBulkLoad {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegionServerBulkLoadWithOldClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegionServerBulkLoadWithOldClient.class);

    public TestHRegionServerBulkLoadWithOldClient(int duration) {
        super(duration);
    }

    @Override
    void runAtomicBulkloadTest(TableName tableName, int millisToRun, int numScanners) throws Exception {
        this.setupTable(tableName, 10);
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(UTIL.getConfiguration());
        AtomicHFileLoader loader = new AtomicHFileLoader(tableName, ctx, (byte[][])null);
        ctx.addThread(loader);
        ArrayList scanners = Lists.newArrayList();
        for (int i = 0; i < numScanners; ++i) {
            TestHRegionServerBulkLoad.AtomicScanReader scanner = new TestHRegionServerBulkLoad.AtomicScanReader(tableName, ctx, families);
            scanners.add(scanner);
            ctx.addThread(scanner);
        }
        ctx.startThreads();
        ctx.waitFor(millisToRun);
        ctx.stop();
        LOG.info("Loaders:");
        LOG.info("  loaded " + loader.numBulkLoads.get());
        LOG.info("  compations " + loader.numCompactions.get());
        LOG.info("Scanners:");
        for (TestHRegionServerBulkLoad.AtomicScanReader scanner : scanners) {
            LOG.info("  scanned " + scanner.numScans.get());
            LOG.info("  verified " + scanner.numRowsScanned.get() + " rows");
        }
    }

    public static class AtomicHFileLoader
    extends MultithreadedTestUtil.RepeatingTestThread {
        final AtomicLong numBulkLoads = new AtomicLong();
        final AtomicLong numCompactions = new AtomicLong();
        private TableName tableName;

        public AtomicHFileLoader(TableName tableName, MultithreadedTestUtil.TestContext ctx, byte[][] targetFamilies) throws IOException {
            super(ctx);
            this.tableName = tableName;
        }

        @Override
        public void doAnAction() throws Exception {
            long iteration = this.numBulkLoads.getAndIncrement();
            Path dir = TestHRegionServerBulkLoad.UTIL.getDataTestDirOnTestFS(String.format("bulkLoad_%08d", iteration));
            FileSystem fs = TestHRegionServerBulkLoad.UTIL.getTestFileSystem();
            byte[] val = Bytes.toBytes((String)String.format("%010d", iteration));
            final ArrayList<Pair> famPaths = new ArrayList<Pair>(10);
            for (int i = 0; i < 10; ++i) {
                Path hfile = new Path(dir, TestHRegionServerBulkLoad.family(i));
                byte[] fam = Bytes.toBytes((String)TestHRegionServerBulkLoad.family(i));
                TestHRegionServerBulkLoad.createHFile(fs, hfile, fam, TestHRegionServerBulkLoad.QUAL, val, 1000);
                famPaths.add(new Pair((Object)fam, (Object)hfile.toString()));
            }
            final ClusterConnection conn = (ClusterConnection)TestHRegionServerBulkLoad.UTIL.getAdmin().getConnection();
            RpcControllerFactory rpcControllerFactory = new RpcControllerFactory(TestHRegionServerBulkLoad.UTIL.getConfiguration());
            ClientServiceCallable callable = new ClientServiceCallable<Void>((Connection)conn, this.tableName, Bytes.toBytes((String)"aaa"), (RpcController)rpcControllerFactory.newController(), -1, Collections.emptyMap()){

                protected Void rpcCall() throws Exception {
                    LOG.info("Non-secure old client");
                    byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                    ClientProtos.BulkLoadHFileRequest request = RequestConverter.buildBulkLoadHFileRequest((List)famPaths, (byte[])regionName, (boolean)true, null, null);
                    ((ClientProtos.ClientService.BlockingInterface)this.getStub()).bulkLoadHFile(null, request);
                    return null;
                }
            };
            RpcRetryingCallerFactory factory = new RpcRetryingCallerFactory(TestHRegionServerBulkLoad.conf, conn.getConnectionConfiguration());
            RpcRetryingCaller caller = factory.newCaller();
            caller.callWithRetries((RetryingCallable)callable, Integer.MAX_VALUE);
            if (this.numBulkLoads.get() % 5L == 0L) {
                callable = new ClientServiceCallable<Void>((Connection)conn, this.tableName, Bytes.toBytes((String)"aaa"), (RpcController)rpcControllerFactory.newController(), -1, Collections.emptyMap()){

                    protected Void rpcCall() throws Exception {
                        LOG.debug("compacting " + this.getLocation() + " for row " + Bytes.toStringBinary((byte[])this.getRow()));
                        AdminProtos.AdminService.BlockingInterface server = conn.getAdmin(this.getLocation().getServerName());
                        AdminProtos.CompactRegionRequest request = RequestConverter.buildCompactRegionRequest((byte[])this.getLocation().getRegionInfo().getRegionName(), (boolean)true, null);
                        server.compactRegion(null, request);
                        numCompactions.incrementAndGet();
                        return null;
                    }
                };
                caller.callWithRetries((RetryingCallable)callable, Integer.MAX_VALUE);
            }
        }
    }
}

