/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CompoundBloomFilter;
import org.apache.hadoop.hbase.io.hfile.CompoundBloomFilterWriter;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.HFilePreadReader;
import org.apache.hadoop.hbase.io.hfile.NoOpIndexBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.monitoring.ThreadLocalServerSideScanMetrics;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestBytesReadFromFs {
    private static final int NUM_KEYS = 100000;
    private static final int BLOOM_BLOCK_SIZE = 512;
    private static final int INDEX_CHUNK_SIZE = 512;
    private static final int DATA_BLOCK_SIZE = 4096;
    private static final int ROW_PREFIX_LENGTH_IN_BLOOM_FILTER = 42;
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBytesReadFromFs.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestBytesReadFromFs.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Random RNG = new Random(9713312L);
    private Configuration conf;
    private FileSystem fs;
    private List<KeyValue> keyValues = new ArrayList<KeyValue>();
    private List<byte[]> keyList = new ArrayList<byte[]>();
    private Path path;

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setInt("RowPrefixBloomFilter.prefix_length", 42);
        this.fs = FileSystem.get((Configuration)this.conf);
        String hfileName = UUID.randomUUID().toString().replaceAll("-", "");
        this.path = new Path(TEST_UTIL.getDataTestDir(), hfileName);
        this.conf.setInt("hfile.index.block.max.size", 512);
    }

    @Test
    public void testBytesReadFromFsWithScanMetricsDisabled() throws IOException {
        ThreadLocalServerSideScanMetrics.setScanMetricsEnabled((boolean)false);
        this.writeData(this.path);
        KeyValue keyValue = this.keyValues.get(0);
        this.readDataAndIndexBlocks(this.path, keyValue, false);
    }

    @Test
    public void testBytesReadFromFsToReadDataUsingIndexBlocks() throws IOException {
        ThreadLocalServerSideScanMetrics.setScanMetricsEnabled((boolean)true);
        this.writeData(this.path);
        KeyValue keyValue = this.keyValues.get(0);
        this.readDataAndIndexBlocks(this.path, keyValue, true);
    }

    @Test
    public void testBytesReadFromFsToReadLoadOnOpenDataSection() throws IOException {
        ThreadLocalServerSideScanMetrics.setScanMetricsEnabled((boolean)true);
        this.writeData(this.path);
        this.readLoadOnOpenDataSection(this.path, false);
    }

    @Test
    public void testBytesReadFromFsToReadBloomFilterIndexesAndBloomBlocks() throws IOException {
        BloomType[] bloomTypes;
        ThreadLocalServerSideScanMetrics.setScanMetricsEnabled((boolean)true);
        for (BloomType bloomType : bloomTypes = new BloomType[]{BloomType.ROW, BloomType.ROWCOL, BloomType.ROWPREFIX_FIXED_LENGTH}) {
            LOG.info("Testing bloom type: {}", (Object)bloomType);
            ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset();
            ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset();
            this.keyList.clear();
            this.keyValues.clear();
            this.writeBloomFilters(this.path, bloomType, 512);
            if (bloomType == BloomType.ROWCOL) {
                KeyValue keyValue = this.keyValues.get(0);
                this.readBloomFilters(this.path, bloomType, null, keyValue);
                continue;
            }
            Assert.assertEquals((long)42L, (long)this.keyList.get(0).length);
            byte[] key = this.keyList.get(0);
            this.readBloomFilters(this.path, bloomType, key, null);
        }
    }

    private void writeData(Path path) throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(4096).withIncludesTags(false).withDataBlockEncoding(DataBlockEncoding.NONE).withCompression(Compression.Algorithm.NONE).build();
        CacheConfig cacheConfig = new CacheConfig(this.conf);
        HFile.Writer writer = new HFile.WriterFactory(this.conf, cacheConfig).withPath(this.fs, path).withFileContext(context).create();
        byte[] cf = Bytes.toBytes((String)"cf");
        byte[] cq = Bytes.toBytes((String)"cq");
        for (int i = 0; i < 100000; ++i) {
            byte[] keyBytes = RandomKeyValueUtil.randomOrderedFixedLengthKey(RNG, i, 10);
            byte[] valueBytes = RandomKeyValueUtil.randomFixedLengthValue(RNG, 10);
            KeyValue keyValue = new KeyValue(keyBytes, cf, cq, EnvironmentEdgeManager.currentTime(), valueBytes);
            writer.append((Cell)keyValue);
            this.keyValues.add(keyValue);
        }
        writer.close();
    }

    private void readDataAndIndexBlocks(Path path, KeyValue keyValue, boolean isScanMetricsEnabled) throws IOException {
        long fileSize = this.fs.getFileStatus(path).getLen();
        ReaderContext readerContext = new ReaderContextBuilder().withInputStreamWrapper(new FSDataInputStreamWrapper(this.fs, path)).withFilePath(path).withFileSystem(this.fs).withFileSize(fileSize).build();
        HFileInfo hfile = new HFileInfo(readerContext, this.conf);
        FixedFileTrailer trailer = hfile.getTrailer();
        CacheConfig cacheConfig = new CacheConfig(this.conf);
        HFilePreadReader reader = new HFilePreadReader(readerContext, hfile, cacheConfig, this.conf);
        hfile.initMetaAndIndex((HFile.Reader)reader);
        HFileContext meta = hfile.getHFileContext();
        HFileBlock.FSReader blockReader = reader.getUncachedBlockReader();
        HFileBlock.BlockIterator blockIter = blockReader.blockRange(trailer.getLoadOnOpenDataOffset(), fileSize - (long)trailer.getTrailerSize());
        MyNoOpEncodedSeeker seeker = new MyNoOpEncodedSeeker();
        ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset();
        ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset();
        int bytesRead = 0;
        int blockLevelsRead = 0;
        HFileBlock block = blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX);
        bytesRead += block.getOnDiskSizeWithHeader();
        if (block.getNextBlockOnDiskSize() > 0) {
            bytesRead += HFileBlock.headerSize((boolean)meta.isUseHBaseChecksum());
        }
        ++blockLevelsRead;
        CellComparator comparator = trailer.createComparator();
        seeker.initRootIndex(block, trailer.getDataIndexCount(), comparator, trailer.getNumDataIndexLevels());
        int rootLevIndex = seeker.rootBlockContainingKey((Cell)keyValue);
        long currentOffset = seeker.getBlockOffset(rootLevIndex);
        int currentDataSize = seeker.getBlockDataSize(rootLevIndex);
        HFileBlock prevBlock = null;
        do {
            prevBlock = block;
            block = blockReader.readBlockData(currentOffset, (long)currentDataSize, true, true, true);
            HFileBlock unpacked = block.unpack(meta, blockReader);
            if (unpacked != block) {
                block.release();
                block = unpacked;
            }
            bytesRead += block.getOnDiskSizeWithHeader();
            if (block.getNextBlockOnDiskSize() > 0) {
                bytesRead += HFileBlock.headerSize((boolean)meta.isUseHBaseChecksum());
            }
            if (!block.getBlockType().isData()) {
                ByteBuff buffer = block.getBufferWithoutHeader();
                HFileBlockIndex.BlockIndexReader.locateNonRootIndexEntry((ByteBuff)buffer, (Cell)keyValue, (CellComparator)comparator);
                currentOffset = buffer.getLong();
                currentDataSize = buffer.getInt();
            }
            prevBlock.release();
            ++blockLevelsRead;
        } while (!block.getBlockType().isData());
        block.release();
        reader.close();
        Assert.assertEquals((Object)isScanMetricsEnabled, (Object)ThreadLocalServerSideScanMetrics.isScanMetricsEnabled());
        bytesRead = isScanMetricsEnabled ? bytesRead : 0;
        Assert.assertEquals((long)bytesRead, (long)ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset());
        Assert.assertEquals((long)blockLevelsRead, (long)(trailer.getNumDataIndexLevels() + 1));
        Assert.assertEquals((long)0L, (long)ThreadLocalServerSideScanMetrics.getBytesReadFromBlockCacheAndReset());
        long blockReadOpsCount = isScanMetricsEnabled ? (long)blockLevelsRead : 0L;
        Assert.assertEquals((long)blockReadOpsCount, (long)ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset());
    }

    private void readLoadOnOpenDataSection(Path path, boolean hasBloomFilters) throws IOException {
        HFileBlock block;
        long fileSize = this.fs.getFileStatus(path).getLen();
        ReaderContext readerContext = new ReaderContextBuilder().withInputStreamWrapper(new FSDataInputStreamWrapper(this.fs, path)).withFilePath(path).withFileSystem(this.fs).withFileSize(fileSize).build();
        ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset();
        ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset();
        HFileInfo hfile = new HFileInfo(readerContext, this.conf);
        FixedFileTrailer trailer = hfile.getTrailer();
        Assert.assertEquals((long)trailer.getTrailerSize(), (long)ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset());
        Assert.assertEquals((long)1L, (long)ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset());
        CacheConfig cacheConfig = new CacheConfig(this.conf);
        HFilePreadReader reader = new HFilePreadReader(readerContext, hfile, cacheConfig, this.conf);
        ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset();
        ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset();
        HFileBlock.FSReader blockReader = reader.getUncachedBlockReader();
        HFileBlock.BlockIterator blockIter = blockReader.blockRange(trailer.getLoadOnOpenDataOffset(), fileSize - (long)trailer.getTrailerSize());
        boolean readNextHeader = false;
        readNextHeader = this.readEachBlockInLoadOnOpenDataSection(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX), readNextHeader);
        readNextHeader = this.readEachBlockInLoadOnOpenDataSection(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX), readNextHeader);
        readNextHeader = this.readEachBlockInLoadOnOpenDataSection(blockIter.nextBlockWithBlockType(BlockType.FILE_INFO), readNextHeader);
        boolean bloomFilterIndexesRead = false;
        while ((block = blockIter.nextBlock()) != null) {
            bloomFilterIndexesRead = true;
            readNextHeader = this.readEachBlockInLoadOnOpenDataSection(block, readNextHeader);
        }
        reader.close();
        Assert.assertEquals((Object)hasBloomFilters, (Object)bloomFilterIndexesRead);
        Assert.assertEquals((long)0L, (long)ThreadLocalServerSideScanMetrics.getBytesReadFromBlockCacheAndReset());
    }

    private boolean readEachBlockInLoadOnOpenDataSection(HFileBlock block, boolean readNextHeader) throws IOException {
        long bytesRead = block.getOnDiskSizeWithHeader();
        if (readNextHeader) {
            bytesRead -= (long)HFileBlock.headerSize((boolean)true);
            readNextHeader = false;
        }
        if (block.getNextBlockOnDiskSize() > 0) {
            bytesRead += (long)HFileBlock.headerSize((boolean)true);
            readNextHeader = true;
        }
        block.release();
        Assert.assertEquals((long)bytesRead, (long)ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset());
        Assert.assertEquals((long)1L, (long)ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset());
        return readNextHeader;
    }

    private void readBloomFilters(Path path, BloomType bt, byte[] key, KeyValue keyValue) throws IOException {
        int block;
        Assert.assertTrue((keyValue == null || key == null ? 1 : 0) != 0);
        this.readLoadOnOpenDataSection(path, true);
        CacheConfig cacheConf = new CacheConfig(this.conf);
        StoreFileInfo storeFileInfo = StoreFileInfo.createStoreFileInfoForHFile((Configuration)this.conf, (FileSystem)this.fs, (Path)path, (boolean)true);
        HStoreFile sf = new HStoreFile(storeFileInfo, bt, cacheConf);
        sf.initReader();
        ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset();
        ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset();
        StoreFileReader reader = sf.getReader();
        BloomFilter bloomFilter = reader.getGeneralBloomFilter();
        Assert.assertTrue((boolean)(bloomFilter instanceof CompoundBloomFilter));
        CompoundBloomFilter cbf = (CompoundBloomFilter)bloomFilter;
        HFileBlockIndex.BlockIndexReader index = cbf.getBloomIndex();
        if (keyValue != null) {
            block = index.rootBlockContainingKey((Cell)keyValue);
        } else {
            byte[] row = key;
            block = index.rootBlockContainingKey(row, 0, row.length);
        }
        HFileBlock bloomBlock = cbf.getBloomBlock(block);
        long bytesRead = bloomBlock.getOnDiskSizeWithHeader();
        if (bloomBlock.getNextBlockOnDiskSize() > 0) {
            bytesRead += (long)HFileBlock.headerSize((boolean)true);
        }
        Assert.assertEquals((Object)bloomBlock.getBlockType(), (Object)BlockType.BLOOM_CHUNK);
        bloomBlock.release();
        reader.close(true);
        Assert.assertEquals((long)bytesRead, (long)ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset());
        Assert.assertEquals((long)1L, (long)ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset());
    }

    private void writeBloomFilters(Path path, BloomType bt, int bloomBlockByteSize) throws IOException {
        this.conf.setInt("io.storefile.bloom.block.size", bloomBlockByteSize);
        CacheConfig cacheConf = new CacheConfig(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(4096).withIncludesTags(false).withDataBlockEncoding(DataBlockEncoding.NONE).withCompression(Compression.Algorithm.NONE).build();
        StoreFileWriter w = new StoreFileWriter.Builder(this.conf, cacheConf, this.fs).withFileContext(meta).withBloomType(bt).withFilePath(path).build();
        Assert.assertTrue((boolean)w.hasGeneralBloom());
        Assert.assertTrue((boolean)(w.getGeneralBloomWriter() instanceof CompoundBloomFilterWriter));
        CompoundBloomFilterWriter cbbf = (CompoundBloomFilterWriter)w.getGeneralBloomWriter();
        byte[] cf = Bytes.toBytes((String)"cf");
        byte[] cq = Bytes.toBytes((String)"cq");
        for (int i = 0; i < 100000; ++i) {
            byte[] keyBytes = RandomKeyValueUtil.randomOrderedFixedLengthKey(RNG, i, 10);
            byte[] valueBytes = RandomKeyValueUtil.randomFixedLengthValue(RNG, 10);
            KeyValue keyValue = new KeyValue(keyBytes, cf, cq, EnvironmentEdgeManager.currentTime(), valueBytes);
            w.append((Cell)keyValue);
            this.keyList.add(keyBytes);
            this.keyValues.add(keyValue);
        }
        Assert.assertEquals((long)this.keyList.size(), (long)cbbf.getKeyCount());
        w.close();
    }

    private static class MyNoOpEncodedSeeker
    extends NoOpIndexBlockEncoder.NoOpEncodedSeeker {
        private MyNoOpEncodedSeeker() {
        }

        public long getBlockOffset(int i) {
            return this.blockOffsets[i];
        }

        public int getBlockDataSize(int i) {
            return this.blockDataSizes[i];
        }
    }
}

