/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RestoreSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.junit.Test;

public class RestoreSnapshotFromClientAfterTruncateTestBase
extends RestoreSnapshotFromClientTestBase {
    @Test
    public void testRestoreSnapshotAfterTruncate() throws Exception {
        TableName tableName = TableName.valueOf((String)this.getValidMethodName());
        SnapshotTestingUtils.createTable(TEST_UTIL, tableName, this.getNumReplicas(), (byte[][])new byte[][]{this.FAMILY});
        SnapshotTestingUtils.loadData(TEST_UTIL, tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        int numOfRows = 0;
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            numOfRows = this.countRows(table, new byte[0][]);
        }
        this.admin.snapshot("snap", tableName);
        this.admin.disableTable(tableName);
        this.admin.truncateTable(tableName, false);
        this.admin.disableTable(tableName);
        this.admin.restoreSnapshot("snap");
        this.admin.enableTable(tableName);
        this.verifyRowCount(TEST_UTIL, tableName, numOfRows);
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, this.admin, this.getNumReplicas());
    }
}

