/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.AggregationHelper;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class AggregationClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AggregationClient.class);
    private final Connection connection;
    private final boolean manageConnection;

    public AggregationClient() {
        this(null, false);
    }

    public AggregationClient(Connection connection) {
        this(connection, false);
    }

    public AggregationClient(Configuration cfg) {
        this(AggregationClient.createConnection(cfg), true);
    }

    private static Connection createConnection(Configuration cfg) {
        try {
            return ConnectionFactory.createConnection((Configuration)cfg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AggregationClient(Connection connection, boolean manageConnection) {
        this.connection = connection;
        this.manageConnection = manageConnection;
    }

    @Override
    public void close() throws IOException {
        if (this.manageConnection && this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    boolean isClosed() {
        return this.manageConnection && this.connection != null && this.connection.isClosed();
    }

    private Connection getConnection() throws IOException {
        if (this.connection == null) {
            throw new IOException("Connection not initialized. Use the correct constructor, or use the methods taking a Table");
        }
        return this.connection;
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R max(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.getConnection().getTable(tableName);){
            R r = this.max(table, ci, scan);
            return r;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R max(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false, false);
        class MaxCallBack
        implements Batch.Callback<R> {
            R max = null;

            MaxCallBack() {
            }

            R getMax() {
                return this.max;
            }

            public synchronized void update(byte[] region, byte[] row, R result) {
                this.max = this.max == null || result != null && ci.compare(this.max, result) < 0 ? result : this.max;
            }
        }
        MaxCallBack aMaxCallBack = new MaxCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, R>(){

            public R call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                instance.getMax(controller, requestArg, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback);
                AggregateProtos.AggregateResponse response = (AggregateProtos.AggregateResponse)rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                if (response.getFirstPartCount() > 0) {
                    ByteString b = response.getFirstPart(0);
                    Object q = AggregationHelper.getParsedGenericInstance(ci.getClass(), 3, b);
                    return ci.getCellValueFromProto(q);
                }
                return null;
            }
        }, (Batch.Callback)aMaxCallBack);
        return aMaxCallBack.getMax();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R min(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.getConnection().getTable(tableName);){
            R r = this.min(table, ci, scan);
            return r;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R min(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false, false);
        class MinCallBack
        implements Batch.Callback<R> {
            private R min = null;

            MinCallBack() {
            }

            public R getMinimum() {
                return this.min;
            }

            public synchronized void update(byte[] region, byte[] row, R result) {
                this.min = this.min == null || result != null && ci.compare(result, this.min) < 0 ? result : this.min;
            }
        }
        MinCallBack minCallBack = new MinCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, R>(){

            public R call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                instance.getMin(controller, requestArg, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback);
                AggregateProtos.AggregateResponse response = (AggregateProtos.AggregateResponse)rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                if (response.getFirstPartCount() > 0) {
                    ByteString b = response.getFirstPart(0);
                    Object q = AggregationHelper.getParsedGenericInstance(ci.getClass(), 3, b);
                    return ci.getCellValueFromProto(q);
                }
                return null;
            }
        }, (Batch.Callback)minCallBack);
        log.debug("Min fom all regions is: " + minCallBack.getMinimum());
        return minCallBack.getMinimum();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> long rowCount(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.getConnection().getTable(tableName);){
            long l = this.rowCount(table, ci, scan);
            return l;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> long rowCount(Table table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, true, false);
        class RowNumCallback
        implements Batch.Callback<Long> {
            private final AtomicLong rowCountL = new AtomicLong(0L);

            RowNumCallback() {
            }

            public long getRowNumCount() {
                return this.rowCountL.get();
            }

            public void update(byte[] region, byte[] row, Long result) {
                this.rowCountL.addAndGet(result);
            }
        }
        RowNumCallback rowNum = new RowNumCallback();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), (Batch.Call)new Batch.Call<AggregateProtos.AggregateService, Long>(){

            public Long call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                instance.getRowNum(controller, requestArg, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback);
                AggregateProtos.AggregateResponse response = (AggregateProtos.AggregateResponse)rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                byte[] bytes = AggregationClient.this.getBytesFromResponse(response.getFirstPart(0));
                ByteBuffer bb = ByteBuffer.allocate(8).put(bytes);
                bb.rewind();
                return bb.getLong();
            }
        }, (Batch.Callback)rowNum);
        return rowNum.getRowNumCount();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> S sum(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.getConnection().getTable(tableName);){
            S s = this.sum(table, ci, scan);
            return s;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> S sum(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false, false);
        class SumCallBack
        implements Batch.Callback<S> {
            S sumVal = null;

            SumCallBack() {
            }

            public S getSumResult() {
                return this.sumVal;
            }

            public synchronized void update(byte[] region, byte[] row, S result) {
                this.sumVal = ci.add(this.sumVal, result);
            }
        }
        SumCallBack sumCallBack = new SumCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, S>(){

            public S call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                instance.getSum(controller, requestArg, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback);
                AggregateProtos.AggregateResponse response = (AggregateProtos.AggregateResponse)rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                if (response.getFirstPartCount() == 0) {
                    return null;
                }
                ByteString b = response.getFirstPart(0);
                Object t = AggregationHelper.getParsedGenericInstance(ci.getClass(), 4, b);
                Object s = ci.getPromotedValueFromProto(t);
                return s;
            }
        }, (Batch.Callback)sumCallBack);
        return sumCallBack.getSumResult();
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<S, Long> getAvgArgs(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.getConnection().getTable(tableName);){
            Pair<S, Long> pair = this.getAvgArgs(table, ci, scan);
            return pair;
        }
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<S, Long> getAvgArgs(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false, false);
        class AvgCallBack
        implements Batch.Callback<Pair<S, Long>> {
            S sum = null;
            Long rowCount = 0L;

            AvgCallBack() {
            }

            public synchronized Pair<S, Long> getAvgArgs() {
                return new Pair(this.sum, (Object)this.rowCount);
            }

            public synchronized void update(byte[] region, byte[] row, Pair<S, Long> result) {
                this.sum = ci.add(this.sum, result.getFirst());
                this.rowCount = this.rowCount + (Long)result.getSecond();
            }
        }
        AvgCallBack avgCallBack = new AvgCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, Pair<S, Long>>(){

            public Pair<S, Long> call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                instance.getAvg(controller, requestArg, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback);
                AggregateProtos.AggregateResponse response = (AggregateProtos.AggregateResponse)rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                Pair pair = new Pair(null, (Object)0L);
                if (response.getFirstPartCount() == 0) {
                    return pair;
                }
                ByteString b = response.getFirstPart(0);
                Object t = AggregationHelper.getParsedGenericInstance(ci.getClass(), 4, b);
                Object s = ci.getPromotedValueFromProto(t);
                pair.setFirst(s);
                ByteBuffer bb = ByteBuffer.allocate(8).put(AggregationClient.this.getBytesFromResponse(response.getSecondPart()));
                bb.rewind();
                pair.setSecond((Object)bb.getLong());
                return pair;
            }
        }, (Batch.Callback)avgCallBack);
        return avgCallBack.getAvgArgs();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double avg(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        Pair<S, Long> p = this.getAvgArgs(tableName, ci, scan);
        return ci.divideForAvg(p.getFirst(), (Long)p.getSecond());
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double avg(Table table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        Pair<S, Long> p = this.getAvgArgs(table, ci, scan);
        return ci.divideForAvg(p.getFirst(), (Long)p.getSecond());
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<List<S>, Long> getStdArgs(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false, false);
        class StdCallback
        implements Batch.Callback<Pair<List<S>, Long>> {
            long rowCountVal = 0L;
            S sumVal = null;
            S sumSqVal = null;

            StdCallback() {
            }

            public synchronized Pair<List<S>, Long> getStdParams() {
                ArrayList l = new ArrayList(2);
                l.add(this.sumVal);
                l.add(this.sumSqVal);
                Pair p = new Pair(l, (Object)this.rowCountVal);
                return p;
            }

            public synchronized void update(byte[] region, byte[] row, Pair<List<S>, Long> result) {
                if (((List)result.getFirst()).size() > 0) {
                    this.sumVal = ci.add(this.sumVal, ((List)result.getFirst()).get(0));
                    this.sumSqVal = ci.add(this.sumSqVal, ((List)result.getFirst()).get(1));
                    this.rowCountVal += ((Long)result.getSecond()).longValue();
                }
            }
        }
        StdCallback stdCallback = new StdCallback();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, Pair<List<S>, Long>>(){

            public Pair<List<S>, Long> call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                instance.getStd(controller, requestArg, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback);
                AggregateProtos.AggregateResponse response = (AggregateProtos.AggregateResponse)rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                Pair pair = new Pair(new ArrayList(), (Object)0L);
                if (response.getFirstPartCount() == 0) {
                    return pair;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < response.getFirstPartCount(); ++i) {
                    ByteString b = response.getFirstPart(i);
                    Object t = AggregationHelper.getParsedGenericInstance(ci.getClass(), 4, b);
                    Object s = ci.getPromotedValueFromProto(t);
                    list.add(s);
                }
                pair.setFirst(list);
                ByteBuffer bb = ByteBuffer.allocate(8).put(AggregationClient.this.getBytesFromResponse(response.getSecondPart()));
                bb.rewind();
                pair.setSecond((Object)bb.getLong());
                return pair;
            }
        }, (Batch.Callback)stdCallback);
        return stdCallback.getStdParams();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double std(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.getConnection().getTable(tableName);){
            double d = this.std(table, ci, scan);
            return d;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double std(Table table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        Pair<List<S>, Long> p = this.getStdArgs(table, ci, scan);
        double avg = ci.divideForAvg(((List)p.getFirst()).get(0), (Long)p.getSecond());
        double avgOfSumSq = ci.divideForAvg(((List)p.getFirst()).get(1), (Long)p.getSecond());
        double res = avgOfSumSq - avg * avg;
        res = Math.pow(res, 0.5);
        return res;
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<NavigableMap<byte[], List<S>>, List<S>> getMedianArgs(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false, false);
        final TreeMap map = new TreeMap(Bytes.BYTES_COMPARATOR);
        class StdCallback
        implements Batch.Callback<List<S>> {
            S sumVal = null;
            S sumWeights = null;

            StdCallback() {
            }

            public synchronized Pair<NavigableMap<byte[], List<S>>, List<S>> getMedianParams() {
                ArrayList l = new ArrayList(2);
                l.add(this.sumVal);
                l.add(this.sumWeights);
                Pair p = new Pair((Object)map, l);
                return p;
            }

            public synchronized void update(byte[] region, byte[] row, List<S> result) {
                map.put(row, result);
                this.sumVal = ci.add(this.sumVal, result.get(0));
                this.sumWeights = ci.add(this.sumWeights, result.get(1));
            }
        }
        StdCallback stdCallback = new StdCallback();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, List<S>>(){

            public List<S> call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                instance.getMedian(controller, requestArg, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback);
                AggregateProtos.AggregateResponse response = (AggregateProtos.AggregateResponse)rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < response.getFirstPartCount(); ++i) {
                    ByteString b = response.getFirstPart(i);
                    Object t = AggregationHelper.getParsedGenericInstance(ci.getClass(), 4, b);
                    Object s = ci.getPromotedValueFromProto(t);
                    list.add(s);
                }
                return list;
            }
        }, (Batch.Callback)stdCallback);
        return stdCallback.getMedianParams();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R median(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.getConnection().getTable(tableName);){
            R r = this.median(table, ci, scan);
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S, P extends Message, Q extends Message, T extends Message> R median(Table table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        Pair<NavigableMap<byte[], List<S>>, List<S>> p = this.getMedianArgs(table, ci, scan);
        byte[] startRow = null;
        byte[] colFamily = scan.getFamilies()[0];
        NavigableSet quals = (NavigableSet)scan.getFamilyMap().get(colFamily);
        NavigableMap map = (NavigableMap)p.getFirst();
        Object sumVal = ((List)p.getSecond()).get(0);
        Object sumWeights = ((List)p.getSecond()).get(1);
        double halfSumVal = ci.divideForAvg(sumVal, Long.valueOf(2L));
        double movingSumVal = 0.0;
        boolean weighted = false;
        if (quals.size() > 1) {
            weighted = true;
            halfSumVal = ci.divideForAvg(sumWeights, Long.valueOf(2L));
        }
        for (Map.Entry entry : map.entrySet()) {
            Object s = weighted ? ((List)entry.getValue()).get(1) : ((List)entry.getValue()).get(0);
            double newSumVal = movingSumVal + ci.divideForAvg(s, Long.valueOf(1L));
            if (newSumVal > halfSumVal) break;
            movingSumVal = newSumVal;
            startRow = (byte[])entry.getKey();
        }
        Scan scan2 = new Scan(scan);
        if (startRow != null) {
            scan2.setStartRow(startRow);
        }
        try (ResultScanner scanner = null;){
            int cacheSize = scan2.getCaching();
            if (!scan2.getCacheBlocks() || scan2.getCaching() < 2) {
                scan2.setCacheBlocks(true);
                cacheSize = 5;
                scan2.setCaching(cacheSize);
            }
            scanner = table.getScanner(scan2);
            Result[] results = null;
            byte[] qualifier = (byte[])quals.pollFirst();
            byte[] weightQualifier = weighted ? (byte[])quals.pollLast() : qualifier;
            Object value = null;
            do {
                if ((results = scanner.next(cacheSize)) == null || results.length <= 0) continue;
                for (int i = 0; i < results.length; ++i) {
                    Result r = results[i];
                    Cell kv = r.getColumnLatestCell(colFamily, weightQualifier);
                    Object newValue = ci.getValue(colFamily, weightQualifier, kv);
                    Object s = ci.castToReturnType(newValue);
                    double newSumVal = movingSumVal + ci.divideForAvg(s, Long.valueOf(1L));
                    if (newSumVal > halfSumVal) {
                        Object object = value;
                        return (R)object;
                    }
                    movingSumVal = newSumVal;
                    kv = r.getColumnLatestCell(colFamily, qualifier);
                    value = ci.getValue(colFamily, qualifier, kv);
                }
            } while (results != null && results.length > 0);
        }
        return null;
    }

    byte[] getBytesFromResponse(ByteString response) {
        return response.toByteArray();
    }

    static class AggregationClientRpcController
    implements RpcController {
        private String errorText;
        private boolean cancelled = false;
        private boolean failed = false;

        AggregationClientRpcController() {
        }

        public String errorText() {
            return this.errorText;
        }

        public boolean failed() {
            return this.failed;
        }

        public boolean isCanceled() {
            return this.cancelled;
        }

        public void notifyOnCancel(RpcCallback<Object> arg0) {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            this.errorText = null;
            this.cancelled = false;
            this.failed = false;
        }

        public void setFailed(String errorText) {
            this.failed = true;
            this.errorText = errorText;
        }

        public void startCancel() {
            this.cancelled = true;
        }
    }
}

