/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.CacheStats;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlock;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class MappableBlockLoader {
    abstract CacheStats initialize(DNConf var1) throws IOException;

    abstract MappableBlock load(long var1, FileInputStream var3, FileInputStream var4, String var5, ExtendedBlockId var6) throws IOException;

    abstract long reserve(ExtendedBlockId var1, long var2);

    abstract long release(ExtendedBlockId var1, long var2);

    abstract long getCacheUsed();

    abstract long getCacheCapacity();

    abstract boolean isTransientCache();

    abstract boolean isNativeLoader();

    abstract MappableBlock getRecoveredMappableBlock(File var1, String var2, byte var3) throws IOException;

    void shutdown() {
    }

    protected void verifyChecksum(long length, FileInputStream metaIn, FileChannel blockChannel, String blockFileName) throws IOException {
        BlockMetadataHeader header = BlockMetadataHeader.readHeader((DataInputStream)new DataInputStream(new BufferedInputStream(metaIn, BlockMetadataHeader.getHeaderSize())));
        try (FileChannel metaChannel = metaIn.getChannel();){
            if (metaChannel == null) {
                throw new IOException("Block InputStream meta file has no FileChannel.");
            }
            DataChecksum checksum = header.getChecksum();
            int bytesPerChecksum = checksum.getBytesPerChecksum();
            int checksumSize = checksum.getChecksumSize();
            int numChunks = 0x800000 / bytesPerChecksum;
            ByteBuffer blockBuf = ByteBuffer.allocate(numChunks * bytesPerChecksum);
            ByteBuffer checksumBuf = ByteBuffer.allocate(numChunks * checksumSize);
            int bytesVerified = 0;
            while ((long)bytesVerified < length) {
                Preconditions.checkState((bytesVerified % bytesPerChecksum == 0 ? 1 : 0) != 0, (Object)"Unexpected partial chunk before EOF");
                assert (bytesVerified % bytesPerChecksum == 0);
                int bytesRead = this.fillBuffer(blockChannel, blockBuf);
                if (bytesRead == -1) {
                    throw new IOException("checksum verification failed: premature EOF");
                }
                blockBuf.flip();
                int chunks = (bytesRead + bytesPerChecksum - 1) / bytesPerChecksum;
                checksumBuf.limit(chunks * checksumSize);
                this.fillBuffer(metaChannel, checksumBuf);
                checksumBuf.flip();
                checksum.verifyChunkedSums(blockBuf, checksumBuf, blockFileName, (long)bytesVerified);
                bytesVerified += bytesRead;
                blockBuf.clear();
                checksumBuf.clear();
            }
        }
    }

    protected int fillBuffer(FileChannel channel, ByteBuffer buf) throws IOException {
        int bytesRead = channel.read(buf);
        if (bytesRead < 0) {
            return bytesRead;
        }
        while (buf.remaining() > 0) {
            int n = channel.read(buf);
            if (n < 0) {
                return bytesRead;
            }
            bytesRead += n;
        }
        return bytesRead;
    }
}

