/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server;

import java.io.File;
import java.util.Properties;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class ServerConfig
extends Config {
    public static final ConfigEntry<Integer> SERVER_SHUTDOWN_TIMEOUT = new ConfigBuilder("gravitino.server.shutdown.timeout").doc("The stop idle timeout(millis) of the Gravitino Server").version("0.1.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)3000);

    public ServerConfig(boolean loadDefaults) {
        super(loadDefaults);
    }

    public ServerConfig() {
        this(true);
    }

    public static ServerConfig loadConfig(String confPath, String defaultConfigName) {
        ServerConfig serverConfig = new ServerConfig();
        try {
            if (confPath.isEmpty()) {
                serverConfig.loadFromFile(defaultConfigName);
            } else {
                Properties properties = serverConfig.loadPropertiesFromFile(new File(confPath));
                serverConfig.loadFromProperties(properties);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to load conf from file " + confPath, exception);
        }
        return serverConfig;
    }
}

