/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import java.nio.file.Path;
import org.springframework.boot.autoconfigure.ssl.BundleContentNotWatchableException;
import org.springframework.boot.ssl.pem.PemContent;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

record BundleContentProperty(String name, String value) {
    boolean isPemContent() {
        return PemContent.isPresentInText(this.value);
    }

    boolean hasValue() {
        return StringUtils.hasText(this.value);
    }

    Path toWatchPath(ResourceLoader resourceLoader) {
        try {
            Assert.state(!this.isPemContent(), "Value contains PEM content");
            Resource resource = resourceLoader.getResource(this.value);
            if (!resource.isFile()) {
                throw new BundleContentNotWatchableException(this);
            }
            return Path.of(resource.getFile().getAbsolutePath(), new String[0]);
        }
        catch (Exception ex) {
            if (ex instanceof BundleContentNotWatchableException) {
                BundleContentNotWatchableException bundleContentNotWatchableException = (BundleContentNotWatchableException)ex;
                throw bundleContentNotWatchableException;
            }
            throw new IllegalStateException("Unable to convert value of property '%s' to a path".formatted(this.name), ex);
        }
    }
}

