/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.profile.activation.ProfileActivator;

@Named
@Singleton
public class DefaultProfileSelector
implements ProfileSelector {
    @Inject
    private List<ProfileActivator> activators = new ArrayList<ProfileActivator>();

    public DefaultProfileSelector addProfileActivator(ProfileActivator profileActivator) {
        if (profileActivator != null) {
            this.activators.add(profileActivator);
        }
        return this;
    }

    @Override
    public List<Profile> getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
        HashSet<String> activatedIds = new HashSet<String>(context.getActiveProfileIds());
        HashSet<String> deactivatedIds = new HashSet<String>(context.getInactiveProfileIds());
        ArrayList<Profile> activeProfiles = new ArrayList<Profile>(profiles.size());
        ArrayList<Profile> activePomProfilesByDefault = new ArrayList<Profile>();
        boolean activatedPomProfileNotByDefault = false;
        for (Profile profile2 : profiles) {
            if (deactivatedIds.contains(profile2.getId())) continue;
            if (activatedIds.contains(profile2.getId()) || this.isActive(profile2, context, problems)) {
                activeProfiles.add(profile2);
                if (!"pom".equals(profile2.getSource())) continue;
                activatedPomProfileNotByDefault = true;
                continue;
            }
            if (!this.isActiveByDefault(profile2)) continue;
            if ("pom".equals(profile2.getSource())) {
                activePomProfilesByDefault.add(profile2);
                continue;
            }
            activeProfiles.add(profile2);
        }
        if (!activatedPomProfileNotByDefault) {
            activeProfiles.addAll(activePomProfilesByDefault);
        }
        return activeProfiles;
    }

    private boolean isActive(Profile profile2, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean isActive = false;
        for (ProfileActivator activator : this.activators) {
            if (!activator.presentInConfig(profile2, context, problems)) continue;
            isActive = true;
        }
        for (ProfileActivator activator : this.activators) {
            try {
                if (!activator.presentInConfig(profile2, context, problems)) continue;
                isActive &= activator.isActive(profile2, context, problems);
            }
            catch (RuntimeException e) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to determine activation for profile " + profile2.getId() + ": " + e.getMessage()).setLocation(profile2.getLocation("")).setException(e));
                return false;
            }
        }
        return isActive;
    }

    private boolean isActiveByDefault(Profile profile2) {
        Activation activation = profile2.getActivation();
        return activation != null && activation.isActiveByDefault();
    }
}

