/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.ConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.annotation.EnvironmentAnnotationValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
class EnvironmentConvertibleValuesMap<V>
extends ConvertibleValuesMap<V> {
    private final Environment environment;

    EnvironmentConvertibleValuesMap(Map<? extends CharSequence, V> map, Environment environment2) {
        super(map, environment2);
        this.environment = environment2;
    }

    @Override
    public <T> Optional<T> get(CharSequence name, Class<T> requiredType) {
        return this.get(name, ConversionContext.of(requiredType));
    }

    @Override
    public <T> Optional<T> get(CharSequence name, Argument<T> requiredType) {
        return this.get(name, ConversionContext.of(requiredType));
    }

    @Override
    public <T> T get(CharSequence name, Class<T> requiredType, T defaultValue) {
        return this.get(name, ConversionContext.of(requiredType)).orElse(defaultValue);
    }

    @Override
    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        Object value = this.map.get(name);
        if (value instanceof AnnotationClassValue) {
            AnnotationClassValue acv = (AnnotationClassValue)value;
            return this.environment.convert((Object)acv, conversionContext);
        }
        if (value instanceof CharSequence) {
            PropertyPlaceholderResolver placeholderResolver = this.environment.getPlaceholderResolver();
            String str = this.doResolveIfNecessary((CharSequence)value, placeholderResolver);
            return this.environment.convert((Object)str, conversionContext);
        }
        if (value instanceof String[]) {
            PropertyPlaceholderResolver placeholderResolver = this.environment.getPlaceholderResolver();
            String[] resolved = (String[])Arrays.stream((String[])value).flatMap(val -> {
                try {
                    String[] values = placeholderResolver.resolveRequiredPlaceholder((String)val, String[].class);
                    return Arrays.stream(values);
                }
                catch (ConfigurationException e) {
                    return Stream.of(this.doResolveIfNecessary((CharSequence)val, placeholderResolver));
                }
            }).toArray(String[]::new);
            return this.environment.convert((Object)resolved, conversionContext);
        }
        if (value instanceof AnnotationValue[]) {
            AnnotationValue[] annotationValues = (AnnotationValue[])value;
            AnnotationValue[] b = new AnnotationValue[annotationValues.length];
            for (int i2 = 0; i2 < annotationValues.length; ++i2) {
                AnnotationValue annotationValue = annotationValues[i2];
                b[i2] = new EnvironmentAnnotationValue(this.environment, annotationValue);
            }
            return this.environment.convert((Object)b, conversionContext);
        }
        if (value instanceof AnnotationValue) {
            EnvironmentAnnotationValue av = (EnvironmentAnnotationValue)value;
            av = new EnvironmentAnnotationValue(this.environment, av);
            return this.environment.convert(av, conversionContext);
        }
        return super.get(name, conversionContext);
    }

    @Override
    public Collection<V> values() {
        return super.values().stream().map(v -> {
            if (v instanceof CharSequence) {
                v = this.environment.getPlaceholderResolver().resolveRequiredPlaceholders(v.toString());
            }
            return v;
        }).collect(Collectors.toList());
    }

    private String doResolveIfNecessary(CharSequence value, PropertyPlaceholderResolver placeholderResolver) {
        String str = value.toString();
        if (str.contains(placeholderResolver.getPrefix())) {
            str = placeholderResolver.resolveRequiredPlaceholders(str);
        }
        return str;
    }

    static <T> ConvertibleValues<T> of(Environment environment2, Map<? extends CharSequence, T> values) {
        if (values == null) {
            return ConvertibleValuesMap.empty();
        }
        return new EnvironmentConvertibleValuesMap<T>(values, environment2);
    }
}

