/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.common.collect;

import java.util.Spliterator;
import java.util.function.Consumer;
import org.gradle.internal.impldep.com.google.common.annotations.GwtCompatible;
import org.gradle.internal.impldep.com.google.common.annotations.GwtIncompatible;
import org.gradle.internal.impldep.com.google.common.annotations.J2ktIncompatible;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.CollectSpliterators;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableAsList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.UnmodifiableIterator;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;

@GwtCompatible(emulated=true)
abstract class IndexedImmutableSet<E>
extends ImmutableSet.CachingAsList<E> {
    IndexedImmutableSet() {
    }

    abstract E get(int var1);

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1297, this::get);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            consumer.accept(this.get(i2));
        }
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        return this.asList().copyIntoArray(dst, offset);
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableAsList<E>(){

            @Override
            public E get(int index2) {
                return IndexedImmutableSet.this.get(index2);
            }

            @Override
            boolean isPartialView() {
                return IndexedImmutableSet.this.isPartialView();
            }

            @Override
            public int size() {
                return IndexedImmutableSet.this.size();
            }

            @Override
            ImmutableCollection<E> delegateCollection() {
                return IndexedImmutableSet.this;
            }

            @Override
            @J2ktIncompatible
            @GwtIncompatible
            Object writeReplace() {
                return super.writeReplace();
            }
        };
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

