/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.input;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.table.runtime.operators.multipleinput.input.InputSelectionSpec;
import org.apache.flink.table.runtime.operators.multipleinput.input.InputSpec;
import org.apache.flink.util.Preconditions;

public class InputSelectionHandler {
    private final List<InputSelectionSpec> inputSelectionSpecs;
    private final int numberOfInput;
    private final List<List<Integer>> sortedAvailableInputs;
    private InputSelection inputSelection;

    public static InputSelectionHandler fromInputSpecs(List<InputSpec> inputSpecs) {
        return new InputSelectionHandler(inputSpecs.stream().map(InputSpec::getInputSelectionSpec).collect(Collectors.toList()));
    }

    public InputSelectionHandler(List<InputSelectionSpec> inputSelectionSpecs) {
        this.inputSelectionSpecs = inputSelectionSpecs;
        this.numberOfInput = inputSelectionSpecs.size();
        this.sortedAvailableInputs = this.buildSortedAvailableInputs();
        this.inputSelection = this.buildInputSelection(this.sortedAvailableInputs.get(0));
    }

    public InputSelection getInputSelection() {
        return this.inputSelection;
    }

    public void endInput(int inputId) {
        List<Integer> inputIds = this.sortedAvailableInputs.get(0);
        Preconditions.checkState((boolean)inputIds.remove((Object)inputId), (Object)"This should not happen.");
        if (inputIds.isEmpty()) {
            this.sortedAvailableInputs.remove(0);
            inputIds = this.sortedAvailableInputs.isEmpty() ? new ArrayList<Integer>() : this.sortedAvailableInputs.get(0);
            this.inputSelection = this.buildInputSelection(inputIds);
        }
    }

    private List<List<Integer>> buildSortedAvailableInputs() {
        TreeMap<Integer, List> orderedAvailableInputIds = new TreeMap<Integer, List>();
        for (InputSelectionSpec inputSelectionSpecs : this.inputSelectionSpecs) {
            List inputIds = orderedAvailableInputIds.computeIfAbsent(inputSelectionSpecs.getReadOrder(), k -> new LinkedList());
            inputIds.add(inputSelectionSpecs.getMultipleInputId());
        }
        return new LinkedList<List<Integer>>(orderedAvailableInputIds.values());
    }

    private InputSelection buildInputSelection(List<Integer> inputIds) {
        if (inputIds.isEmpty()) {
            return InputSelection.ALL;
        }
        InputSelection.Builder builder = new InputSelection.Builder();
        inputIds.forEach(arg_0 -> ((InputSelection.Builder)builder).select(arg_0));
        return builder.build(this.numberOfInput);
    }
}

