/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.table;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.StreamSupport;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.guava33.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava33.com.google.common.cache.CacheBuilder;
import org.apache.flink.state.api.functions.KeyedStateReaderFunction;
import org.apache.flink.state.table.StateValueColumnConfiguration;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public class KeyedStateReader
extends KeyedStateReaderFunction<Object, RowData> {
    private static final long CACHE_MAX_SIZE = 64000L;
    private final Tuple2<Integer, List<StateValueColumnConfiguration>> keyValueProjections;
    private final RowType rowType;
    private final Map<Integer, State> states = new HashMap<Integer, State>();
    private final Cache<Tuple2<Class, String>, Field> classFieldCache;
    private final Cache<Tuple2<Class, String>, Method> classMethodCache;

    public KeyedStateReader(RowType rowType, Tuple2<Integer, List<StateValueColumnConfiguration>> keyValueProjections) {
        this.keyValueProjections = keyValueProjections;
        this.rowType = rowType;
        this.classMethodCache = CacheBuilder.newBuilder().maximumSize(64000L).build();
        this.classFieldCache = CacheBuilder.newBuilder().maximumSize(64000L).build();
    }

    public void open(OpenContext openContext) throws Exception {
        block5: for (StateValueColumnConfiguration columnConfig : (List)this.keyValueProjections.f1) {
            switch (columnConfig.getStateType()) {
                case VALUE: {
                    this.states.put(columnConfig.getColumnIndex(), (State)this.getRuntimeContext().getState((ValueStateDescriptor)columnConfig.getStateDescriptor()));
                    continue block5;
                }
                case LIST: {
                    this.states.put(columnConfig.getColumnIndex(), (State)this.getRuntimeContext().getListState((ListStateDescriptor)columnConfig.getStateDescriptor()));
                    continue block5;
                }
                case MAP: {
                    this.states.put(columnConfig.getColumnIndex(), (State)this.getRuntimeContext().getMapState((MapStateDescriptor)columnConfig.getStateDescriptor()));
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unsupported state type: " + String.valueOf((Object)columnConfig.getStateType()));
        }
    }

    public void close() {
        this.states.clear();
    }

    @Override
    public void readKey(Object key, KeyedStateReaderFunction.Context context, Collector<RowData> out) throws Exception {
        GenericRowData row = new GenericRowData(RowKind.INSERT, 1 + ((List)this.keyValueProjections.f1).size());
        List fields = this.rowType.getFields();
        int columnIndex = (Integer)this.keyValueProjections.f0;
        LogicalType keyLogicalType = ((RowType.RowField)fields.get(columnIndex)).getType();
        row.setField(columnIndex, this.getValue(keyLogicalType, key));
        block5: for (StateValueColumnConfiguration columnConfig : (List)this.keyValueProjections.f1) {
            LogicalType valueLogicalType = ((RowType.RowField)fields.get(columnConfig.getColumnIndex())).getType();
            switch (columnConfig.getStateType()) {
                case VALUE: {
                    row.setField(columnConfig.getColumnIndex(), this.getValue(valueLogicalType, ((ValueState)this.states.get(columnConfig.getColumnIndex())).value()));
                    continue block5;
                }
                case LIST: {
                    row.setField(columnConfig.getColumnIndex(), this.getValue(valueLogicalType, ((ListState)this.states.get(columnConfig.getColumnIndex())).get()));
                    continue block5;
                }
                case MAP: {
                    row.setField(columnConfig.getColumnIndex(), this.getValue(valueLogicalType, ((MapState)this.states.get(columnConfig.getColumnIndex())).entries()));
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unsupported state type: " + String.valueOf((Object)columnConfig.getStateType()));
        }
        out.collect((Object)row);
    }

    private Object getValue(LogicalType logicalType, Object object) {
        if (object == null) {
            return null;
        }
        switch (logicalType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return StringData.fromString((String)object.toString());
            }
            case BOOLEAN: {
                return object;
            }
            case BINARY: 
            case VARBINARY: {
                return this.convertToBytes(object);
            }
            case DECIMAL: {
                return KeyedStateReader.convertToDecimal(object, logicalType);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: {
                return object;
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return object;
            }
            case ARRAY: {
                return this.convertToArray(object, logicalType);
            }
            case MAP: {
                return this.convertToMap(object, logicalType);
            }
            case ROW: {
                return this.convertToRow(object, logicalType);
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(logicalType));
    }

    private Object getObjectField(Object object, RowType.RowField rowField) {
        Object objectField;
        String rowFieldName = rowField.getName();
        Class<?> objectClass = object.getClass();
        try {
            Field field = (Field)this.classFieldCache.get((Object)Tuple2.of(objectClass, (Object)rowFieldName), () -> objectClass.getField(rowFieldName));
            objectField = field.get(object);
        }
        catch (ExecutionException e1) {
            Method method = this.getMethod(objectClass, rowFieldName);
            try {
                objectField = method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Cannot access field by either public member or getter function: " + rowField.getName());
        }
        return objectField;
    }

    private Method getMethod(Class objectClass, String rowFieldName) {
        String upperRowFieldName = rowFieldName.substring(0, 1).toUpperCase() + rowFieldName.substring(1);
        try {
            String methodName = "get" + upperRowFieldName;
            return (Method)this.classMethodCache.get((Object)Tuple2.of((Object)objectClass, (Object)methodName), () -> objectClass.getMethod(methodName, new Class[0]));
        }
        catch (ExecutionException e1) {
            try {
                String methodName = "is" + upperRowFieldName;
                return (Method)this.classMethodCache.get((Object)Tuple2.of((Object)objectClass, (Object)methodName), () -> objectClass.getMethod(methodName, new Class[0]));
            }
            catch (ExecutionException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static DecimalData convertToDecimal(Object object, LogicalType logicalType) {
        DecimalType decimalType = (DecimalType)logicalType;
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        if (object instanceof BigDecimal) {
            return DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)object), (int)precision, (int)scale);
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return DecimalData.fromUnscaledBytes((byte[])bytes, (int)precision, (int)scale);
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return DecimalData.fromUnscaledBytes((byte[])bytes, (int)precision, (int)scale);
        }
        throw new UnsupportedOperationException("Decimal conversion supports only BigDecimal, ByteBuffer and byte[] but received: " + object.getClass().getName());
    }

    private byte[] convertToBytes(Object object) {
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new UnsupportedOperationException("Byte array conversion supports only ByteBuffer and byte[] but received: " + object.getClass().getName());
    }

    private GenericArrayData convertToArray(Object object, LogicalType logicalType) {
        LogicalType elementLogicalType = ((ArrayType)logicalType).getElementType();
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return new GenericArrayData(StreamSupport.stream(iterable.spliterator(), false).map(v -> this.getValue(elementLogicalType, v)).toArray());
        }
        throw new UnsupportedOperationException("Array conversion supports only Iterable but received: " + object.getClass().getName());
    }

    private GenericMapData convertToMap(Object object, LogicalType logicalType) {
        MapType mapType = (MapType)logicalType;
        LogicalType keyLogicalType = mapType.getKeyType();
        LogicalType valueLogicalType = mapType.getValueType();
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            Iterator iterator = iterable.iterator();
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            boolean typeChecked = false;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!typeChecked && !(e instanceof Map.Entry)) {
                    throw new UnsupportedOperationException("Map conversion supports only Iterable<Map.Entry> but received: " + object.getClass().getName());
                }
                typeChecked = true;
                Map.Entry entry = (Map.Entry)e;
                result.put(this.getValue(keyLogicalType, entry.getKey()), this.getValue(valueLogicalType, entry.getValue()));
            }
            return new GenericMapData(result);
        }
        throw new UnsupportedOperationException("Map conversion supports only Iterable<Map.Entry> but received: " + object.getClass().getName());
    }

    private GenericRowData convertToRow(Object object, LogicalType logicalType) {
        RowType rowType = (RowType)logicalType;
        GenericRowData result = new GenericRowData(RowKind.INSERT, rowType.getFieldCount());
        List fields = rowType.getFields();
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            RowType.RowField subRowField = (RowType.RowField)fields.get(i);
            Object subObject = this.getObjectField(object, subRowField);
            result.setField(i, this.getValue(subRowField.getType(), subObject));
        }
        return result;
    }
}

