/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.planner.plan.nodes.exec.serde.CompiledPlanSerdeUtil;

@Internal
final class ResolvedCatalogTableJsonDeserializer
extends StdDeserializer<ResolvedCatalogTable> {
    private static final long serialVersionUID = 1L;

    ResolvedCatalogTableJsonDeserializer() {
        super(ResolvedCatalogTable.class);
    }

    public ResolvedCatalogTable deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        ObjectNode jsonNode = (ObjectNode)jsonParser.readValueAsTree();
        ObjectCodec codec = jsonParser.getCodec();
        ResolvedSchema resolvedSchema = (ResolvedSchema)ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)jsonNode.required("schema"), codec), ResolvedSchema.class);
        TableDistribution distribution = CompiledPlanSerdeUtil.deserializeFieldOrNull(jsonNode, "distribution", TableDistribution.class, codec, ctx);
        List<String> partitionKeys = CompiledPlanSerdeUtil.deserializeListOrEmpty(jsonNode, "partitionKeys", String.class, codec, ctx);
        String comment = CompiledPlanSerdeUtil.deserializeFieldOrNull(jsonNode, "comment", String.class, codec, ctx);
        Map<String, String> options = CompiledPlanSerdeUtil.deserializeMapOrEmpty(jsonNode, "options", String.class, String.class, codec, ctx);
        return new ResolvedCatalogTable(CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment(comment).distribution(distribution).partitionKeys(partitionKeys).options(options).build(), resolvedSchema);
    }
}

