/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.types.variant.Variant;

@PublicEvolving
public interface ArrayData {
    public int size();

    public boolean isNullAt(int var1);

    public boolean getBoolean(int var1);

    public byte getByte(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public StringData getString(int var1);

    public DecimalData getDecimal(int var1, int var2, int var3);

    public TimestampData getTimestamp(int var1, int var2);

    public <T> RawValueData<T> getRawValue(int var1);

    public Variant getVariant(int var1);

    public byte[] getBinary(int var1);

    public ArrayData getArray(int var1);

    public MapData getMap(int var1);

    public RowData getRow(int var1, int var2);

    public boolean[] toBooleanArray();

    public byte[] toByteArray();

    public short[] toShortArray();

    public int[] toIntArray();

    public long[] toLongArray();

    public float[] toFloatArray();

    public double[] toDoubleArray();

    public static ElementGetter createElementGetter(LogicalType elementType) {
        ElementGetter elementGetter;
        switch (elementType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                elementGetter = ArrayData::getString;
                break;
            }
            case BOOLEAN: {
                elementGetter = ArrayData::getBoolean;
                break;
            }
            case BINARY: 
            case VARBINARY: {
                elementGetter = ArrayData::getBinary;
                break;
            }
            case DECIMAL: {
                int decimalPrecision = LogicalTypeChecks.getPrecision(elementType);
                int decimalScale = LogicalTypeChecks.getScale(elementType);
                elementGetter = (array, pos) -> array.getDecimal(pos, decimalPrecision, decimalScale);
                break;
            }
            case TINYINT: {
                elementGetter = ArrayData::getByte;
                break;
            }
            case SMALLINT: {
                elementGetter = ArrayData::getShort;
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                elementGetter = ArrayData::getInt;
                break;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                elementGetter = ArrayData::getLong;
                break;
            }
            case FLOAT: {
                elementGetter = ArrayData::getFloat;
                break;
            }
            case DOUBLE: {
                elementGetter = ArrayData::getDouble;
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = LogicalTypeChecks.getPrecision(elementType);
                elementGetter = (array, pos) -> array.getTimestamp(pos, timestampPrecision);
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException();
            }
            case ARRAY: {
                elementGetter = ArrayData::getArray;
                break;
            }
            case MULTISET: 
            case MAP: {
                elementGetter = ArrayData::getMap;
                break;
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                int rowFieldCount = LogicalTypeChecks.getFieldCount(elementType);
                elementGetter = (array, pos) -> array.getRow(pos, rowFieldCount);
                break;
            }
            case DISTINCT_TYPE: {
                elementGetter = ArrayData.createElementGetter(((DistinctType)elementType).getSourceType());
                break;
            }
            case RAW: {
                elementGetter = ArrayData::getRawValue;
                break;
            }
            case VARIANT: {
                elementGetter = ArrayData::getVariant;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return (array, pos) -> {
            if (array.isNullAt(pos)) {
                return null;
            }
            return elementGetter.getElementOrNull(array, pos);
        };
    }

    @PublicEvolving
    public static interface ElementGetter
    extends Serializable {
        @Nullable
        public Object getElementOrNull(ArrayData var1, int var2);
    }
}

