/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.util.Clock;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public final class CredentialFromAccessTokenProviderClassFactory {
    public static Credential credential(AccessTokenProvider accessTokenProvider, Collection<String> scopes) {
        if (accessTokenProvider != null) {
            return CredentialFromAccessTokenProviderClassFactory.getCredentialFromAccessTokenProvider(accessTokenProvider, scopes);
        }
        return null;
    }

    public static Credential credential(Configuration config, List<String> keyPrefixes, Collection<String> scopes) throws IOException {
        AccessTokenProvider accessTokenProvider = HadoopCredentialConfiguration.getAccessTokenProvider(config, keyPrefixes);
        return CredentialFromAccessTokenProviderClassFactory.credential(accessTokenProvider, scopes);
    }

    private static Credential getCredentialFromAccessTokenProvider(AccessTokenProvider accessTokenProvider, Collection<String> scopes) {
        Preconditions.checkArgument(accessTokenProvider.getAccessToken() != null, "Access Token cannot be null!");
        GoogleCredential credential = GoogleCredentialWithAccessTokenProvider.fromAccessTokenProvider(Clock.SYSTEM, accessTokenProvider);
        return credential.createScoped(scopes);
    }

    static final class GoogleCredentialWithAccessTokenProvider
    extends GoogleCredential {
        private final Clock clock;
        private final AccessTokenProvider accessTokenProvider;

        private GoogleCredentialWithAccessTokenProvider(Clock clock, AccessTokenProvider accessTokenProvider) {
            this.clock = clock;
            this.accessTokenProvider = accessTokenProvider;
        }

        static GoogleCredential fromAccessTokenProvider(Clock clock, AccessTokenProvider accessTokenProvider) {
            AccessTokenProvider.AccessToken accessToken = Preconditions.checkNotNull(accessTokenProvider.getAccessToken(), "Access Token cannot be null!");
            return new GoogleCredentialWithAccessTokenProvider(clock, accessTokenProvider).setAccessToken(accessToken.getToken()).setExpirationTimeMilliseconds(accessToken.getExpirationTimeMilliSeconds());
        }

        @Override
        protected TokenResponse executeRefreshToken() throws IOException {
            this.accessTokenProvider.refresh();
            AccessTokenProvider.AccessToken accessToken = Preconditions.checkNotNull(this.accessTokenProvider.getAccessToken(), "Access Token cannot be null!");
            String token = Preconditions.checkNotNull(accessToken.getToken(), "Access Token cannot be null!");
            Long expirationTimeMilliSeconds = accessToken.getExpirationTimeMilliSeconds();
            return new TokenResponse().setAccessToken(token).setExpiresInSeconds(expirationTimeMilliSeconds == null ? null : Long.valueOf((expirationTimeMilliSeconds - this.clock.currentTimeMillis()) / 1000L));
        }
    }
}

