/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.logical;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Snapshot;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.Litmus;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot$;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\b\u0011\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015i\u0007\u0001\"\u0011o\u000f\u0015q\b\u0003#\u0001\u0000\r\u0019y\u0001\u0003#\u0001\u0002\u0002!1aI\u0003C\u0001\u0003\u0013A\u0011\"a\u0003\u000b\u0005\u0004%\t!!\u0004\t\u0011\u0005m!\u0002)A\u0005\u0003\u001fAq!!\b\u000b\t\u0003\tyB\u0001\u000bGY&t7\u000eT8hS\u000e\fGn\u00158baNDw\u000e\u001e\u0006\u0003#I\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0014)\u0005)an\u001c3fg*\u0011QCF\u0001\u0005a2\fgN\u0003\u0002\u00181\u00059\u0001\u000f\\1o]\u0016\u0014(BA\r\u001b\u0003\u0015!\u0018M\u00197f\u0015\tYB$A\u0003gY&t7N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001A\n\u0004\u0001\tb\u0003CA\u0012+\u001b\u0005!#BA\u0013'\u0003\u0011\u0019wN]3\u000b\u0005\u001dB\u0013a\u0001:fY*\u0011\u0011\u0006H\u0001\bG\u0006d7-\u001b;f\u0013\tYCE\u0001\u0005T]\u0006\u00048\u000f[8u!\tic&D\u0001\u0011\u0013\ty\u0003CA\bGY&t7\u000eT8hS\u000e\fGNU3m\u0003\u001d\u0019G.^:uKJ\u0004\"A\r\u001b\u000e\u0003MR!!\u0006\u0015\n\u0005U\u001a$!\u0004*fY>\u0003Ho\u00117vgR,'/\u0001\u0004ue\u0006LGo\u001d\t\u0003eaJ!!O\u001a\u0003\u0017I+G\u000e\u0016:bSR\u001cV\r^\u0001\u0006G\"LG\u000e\u001a\t\u0003yuj\u0011AJ\u0005\u0003}\u0019\u0012qAU3m\u001d>$W-\u0001\u0004qKJLw\u000e\u001a\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\"\n1A]3y\u0013\t)%IA\u0004SKbtu\u000eZ3\u0002\rqJg.\u001b;?)\u0015A\u0015JS&M!\ti\u0003\u0001C\u00031\u000b\u0001\u0007\u0011\u0007C\u00037\u000b\u0001\u0007q\u0007C\u0003;\u000b\u0001\u00071\bC\u0003@\u000b\u0001\u0007\u0001)A\u0004jgZ\u000bG.\u001b3\u0015\u0007=+V\f\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016KA\u0004C_>dW-\u00198\t\u000bY3\u0001\u0019A,\u0002\r1LG/\\;t!\tA6,D\u0001Z\u0015\tQ\u0006&\u0001\u0003vi&d\u0017B\u0001/Z\u0005\u0019a\u0015\u000e^7vg\")aL\u0002a\u0001?\u000691m\u001c8uKb$\bC\u00011d\u001d\ta\u0014-\u0003\u0002cM\u00059!+\u001a7O_\u0012,\u0017B\u00013f\u0005\u001d\u0019uN\u001c;fqRT!A\u0019\u0014\u0002\t\r|\u0007/\u001f\u000b\u0005E!TG\u000eC\u0003j\u000f\u0001\u0007q'\u0001\u0005ue\u0006LGoU3u\u0011\u0015Yw\u00011\u0001<\u0003\u0015Ig\u000e];u\u0011\u0015yt\u00011\u0001A\u0003=\u0019w.\u001c9vi\u0016\u001cV\r\u001c4D_N$HcA8smB\u0011!\u0007]\u0005\u0003cN\u0012!BU3m\u001fB$8i\\:u\u0011\u00159\u0002\u00021\u0001t!\t\u0011D/\u0003\u0002vg\ti!+\u001a7PaR\u0004F.\u00198oKJDQa\u001e\u0005A\u0002a\f!!\\9\u0011\u0005edX\"\u0001>\u000b\u0005m4\u0013\u0001C7fi\u0006$\u0017\r^1\n\u0005uT(\u0001\u0005*fY6+G/\u00193bi\u0006\fV/\u001a:z\u0003Q1E.\u001b8l\u0019><\u0017nY1m':\f\u0007o\u001d5piB\u0011QFC\n\u0004\u0015\u0005\r\u0001c\u0001)\u0002\u0006%\u0019\u0011qA)\u0003\r\u0005s\u0017PU3g)\u0005y\u0018!C\"P\u001dZ+%\u000bV#S+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BJ\u0001\bG>tg/\u001a:u\u0013\u0011\tI\"a\u0005\u0003\u001b\r{gN^3si\u0016\u0014(+\u001e7f\u0003)\u0019uJ\u0014,F%R+%\u000bI\u0001\u0007GJ,\u0017\r^3\u0015\u000b!\u000b\t#a\t\t\u000b-t\u0001\u0019A\u001e\t\u000b}r\u0001\u0019\u0001!")
public class FlinkLogicalSnapshot
extends Snapshot
implements FlinkLogicalRel {
    private final RelOptCluster cluster;
    private final RexNode period;

    public static FlinkLogicalSnapshot create(RelNode relNode, RexNode rexNode) {
        return FlinkLogicalSnapshot$.MODULE$.create(relNode, rexNode);
    }

    public static ConverterRule CONVERTER() {
        return FlinkLogicalSnapshot$.MODULE$.CONVERTER();
    }

    @Override
    public String getRelDetailedDescription() {
        return FlinkRelNode.getRelDetailedDescription$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionDetail);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, expressionDetail);
    }

    @Override
    public Enumeration.Value convertToExpressionDetail(SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.convertToExpressionDetail$(this, sqlExplainLevel);
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        String msg = "Temporal table can only be used in temporal join and only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.\nQuerying a temporal table using 'FOR SYSTEM TIME AS OF' syntax with %s is not supported yet.";
        RexNode rexNode = this.period;
        if (!(rexNode instanceof RexFieldAccess ? true : rexNode instanceof RexLiteral)) {
            return litmus.fail(String.format(msg, new StringBuilder(21).append("an expression call '").append(this.period.toString()).append("'").toString()), new Object[0]);
        }
        RelDataType dataType = this.period.getType();
        SqlTypeFamily sqlTypeFamily = this.period.getType().getSqlTypeName().getFamily();
        SqlTypeFamily sqlTypeFamily2 = SqlTypeFamily.TIMESTAMP;
        Object object = (sqlTypeFamily == null ? sqlTypeFamily2 != null : !sqlTypeFamily.equals(sqlTypeFamily2)) ? BoxesRunTime.boxToBoolean((boolean)litmus.fail(new StringBuilder(102).append("The system time period specification expects TIMESTAMP or TIMESTAMP WITH LOCAL TIME ZONE ype but is '").append((Object)dataType.getSqlTypeName()).append("'").toString(), new Object[0])) : BoxedUnit.UNIT;
        return litmus.succeed();
    }

    @Override
    public Snapshot copy(RelTraitSet traitSet, RelNode input, RexNode period) {
        return new FlinkLogicalSnapshot(this.cluster, traitSet, input, period);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double rowCnt = mq.getRowCount(this);
        Double rowSize = mq.getAverageRowSize(this);
        return planner.getCostFactory().makeCost(Predef$.MODULE$.Double2double(rowCnt), Predef$.MODULE$.Double2double(rowCnt), Predef$.MODULE$.Double2double(rowCnt) * Predef$.MODULE$.Double2double(rowSize));
    }

    public FlinkLogicalSnapshot(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode period) {
        this.cluster = cluster;
        this.period = period;
        super(cluster, traits, child, period);
        FlinkRelNode.$init$(this);
        this.isValid(Litmus.THROW, null);
    }
}

