/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractCharacterFamilyTargetRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class TimeToStringCastRule
extends AbstractCharacterFamilyTargetRule<Long> {
    static final TimeToStringCastRule INSTANCE = new TimeToStringCastRule();

    private TimeToStringCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE).target((LogicalType)VarCharType.STRING_TYPE).build());
    }

    @Override
    public String generateStringExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return CastRuleUtils.staticCall(BuiltInMethods.UNIX_TIME_TO_STRING(), inputTerm, LogicalTypeChecks.getPrecision((LogicalType)inputLogicalType));
    }
}

