/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.StringData;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.BinaryToBinaryCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class StringToBinaryCastRule
extends AbstractNullAwareCodeGeneratorCastRule<StringData, byte[]> {
    static final StringToBinaryCastRule INSTANCE = new StringToBinaryCastRule();

    private StringToBinaryCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.CHARACTER_STRING).target(LogicalTypeFamily.BINARY_STRING).build());
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (context.legacyBehaviour()) {
            return new CastRuleUtils.CodeWriter().assignStmt(returnVariable, CastRuleUtils.methodCall(inputTerm, "toBytes", new Object[0])).toString();
        }
        int targetLength = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
        String byteArrayTerm = CodeGenUtils.newName(context.getCodeGeneratorContext(), "byteArrayTerm");
        return new CastRuleUtils.CodeWriter().declStmt(byte[].class, byteArrayTerm, CastRuleUtils.methodCall(inputTerm, "toBytes", new Object[0])).ifStmt(CastRuleUtils.arrayLength(byteArrayTerm) + " <= " + targetLength, thenWriter -> {
            if (BinaryToBinaryCastRule.couldPad(targetLogicalType, targetLength)) {
                BinaryToBinaryCastRule.trimOrPadByteArray(returnVariable, targetLength, byteArrayTerm, thenWriter);
            } else {
                thenWriter.assignStmt(returnVariable, byteArrayTerm);
            }
        }, elseWriter -> BinaryToBinaryCastRule.trimOrPadByteArray(returnVariable, targetLength, byteArrayTerm, elseWriter)).toString();
    }
}

