/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.gs.GSFileSystemOptions;
import org.apache.flink.fs.gs.storage.GSBlobIdentifier;
import org.apache.flink.fs.gs.storage.GSBlobStorage;
import org.apache.flink.fs.gs.utils.BlobUtils;
import org.apache.flink.fs.gs.writer.GSCommitRecoverable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSRecoverableWriterCommitter
implements RecoverableFsDataOutputStream.Committer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSRecoverableWriterCommitter.class);
    private final GSBlobStorage storage;
    @VisibleForTesting
    final GSFileSystemOptions options;
    @VisibleForTesting
    final GSCommitRecoverable recoverable;
    private final int composeMaxBlobs;
    private List<GSBlobIdentifier> composedTempBlobIdentifiers = new ArrayList<GSBlobIdentifier>();

    GSRecoverableWriterCommitter(GSBlobStorage storage, GSFileSystemOptions options, GSCommitRecoverable recoverable, int composeMaxBlobs) {
        LOGGER.trace("Creating GSRecoverableWriterCommitter with options {} for recoverable: {}", (Object)options, (Object)recoverable);
        this.storage = (GSBlobStorage)Preconditions.checkNotNull((Object)storage);
        this.options = (GSFileSystemOptions)Preconditions.checkNotNull((Object)options);
        this.recoverable = (GSCommitRecoverable)Preconditions.checkNotNull((Object)recoverable);
        Preconditions.checkArgument((composeMaxBlobs > 0 ? 1 : 0) != 0);
        this.composeMaxBlobs = composeMaxBlobs;
    }

    GSRecoverableWriterCommitter(GSBlobStorage storage, GSFileSystemOptions options, GSCommitRecoverable recoverable) {
        this(storage, options, recoverable, 32);
    }

    public void commit() throws IOException {
        LOGGER.trace("Committing recoverable with options {}: {}", (Object)this.options, (Object)this.recoverable);
        Optional<GSBlobStorage.BlobMetadata> blobMetadata = this.storage.getMetadata(this.recoverable.finalBlobIdentifier);
        if (blobMetadata.isPresent()) {
            throw new IOException(String.format("Blob %s already exists during attempted commit", this.recoverable.finalBlobIdentifier));
        }
        this.writeFinalBlob();
        this.cleanupTemporaryBlobs();
    }

    public void commitAfterRecovery() throws IOException {
        LOGGER.trace("Committing recoverable after recovery with options {}: {}", (Object)this.options, (Object)this.recoverable);
        Optional<GSBlobStorage.BlobMetadata> blobMetadata = this.storage.getMetadata(this.recoverable.finalBlobIdentifier);
        if (!blobMetadata.isPresent()) {
            this.writeFinalBlob();
        }
        this.cleanupTemporaryBlobs();
    }

    public RecoverableWriter.CommitRecoverable getRecoverable() {
        return this.recoverable;
    }

    private void composeBlobs(List<GSBlobIdentifier> sourceBlobIdentifiers, GSBlobIdentifier targetBlobIdentifier) {
        LOGGER.trace("Composing blobs {} to {} for commit with options {}", new Object[]{sourceBlobIdentifiers, targetBlobIdentifier, this.options});
        Preconditions.checkNotNull(sourceBlobIdentifiers);
        Preconditions.checkArgument((sourceBlobIdentifiers.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)targetBlobIdentifier);
        int composeToIndex = Math.min(this.composeMaxBlobs, sourceBlobIdentifiers.size());
        List<GSBlobIdentifier> composeBlobIds = sourceBlobIdentifiers.subList(0, composeToIndex);
        List<GSBlobIdentifier> remainingBlobIds = sourceBlobIdentifiers.subList(composeToIndex, sourceBlobIdentifiers.size());
        UUID temporaryObjectId = UUID.randomUUID();
        GSBlobIdentifier composedBlobId = remainingBlobIds.isEmpty() ? targetBlobIdentifier : BlobUtils.getTemporaryBlobIdentifier(this.recoverable.finalBlobIdentifier, temporaryObjectId, this.options);
        this.storage.compose(composeBlobIds, composedBlobId);
        if (!remainingBlobIds.isEmpty()) {
            remainingBlobIds.add(0, composedBlobId);
            this.composeBlobs(remainingBlobIds, targetBlobIdentifier);
        }
    }

    private void writeFinalBlob() {
        List<GSBlobIdentifier> blobIdentifiers = this.recoverable.getComponentBlobIds(this.options);
        if (blobIdentifiers.isEmpty()) {
            this.storage.createBlob(this.recoverable.finalBlobIdentifier);
        } else {
            String temporaryBucketName = BlobUtils.getTemporaryBucketName(this.recoverable.finalBlobIdentifier, this.options);
            if (this.recoverable.finalBlobIdentifier.bucketName.equals(temporaryBucketName)) {
                this.composeBlobs(this.recoverable.getComponentBlobIds(this.options), this.recoverable.finalBlobIdentifier);
            } else {
                UUID temporaryObjectId = UUID.randomUUID();
                GSBlobIdentifier intermediateBlobIdentifier = BlobUtils.getTemporaryBlobIdentifier(this.recoverable.finalBlobIdentifier, temporaryObjectId, this.options);
                this.composeBlobs(this.recoverable.getComponentBlobIds(this.options), intermediateBlobIdentifier);
                this.composedTempBlobIdentifiers.add(intermediateBlobIdentifier);
                this.storage.copy(intermediateBlobIdentifier, this.recoverable.finalBlobIdentifier);
            }
        }
    }

    private void cleanupTemporaryBlobs() {
        LOGGER.trace("Cleaning up temporary blobs for recoverable with options {}: {}", (Object)this.options, (Object)this.recoverable);
        List<Object> foundTempBlobIdentifiers = new ArrayList<GSBlobIdentifier>();
        String temporaryBucketName = BlobUtils.getTemporaryBucketName(this.recoverable.finalBlobIdentifier, this.options);
        if (this.options.isFileSinkEntropyEnabled().booleanValue()) {
            if (!this.recoverable.finalBlobIdentifier.bucketName.equals(temporaryBucketName)) {
                foundTempBlobIdentifiers.addAll(this.composedTempBlobIdentifiers);
            }
            foundTempBlobIdentifiers.addAll(this.recoverable.getComponentBlobIds(this.options));
        } else {
            String temporaryObjectPartialName = BlobUtils.getTemporaryObjectPartialName(this.recoverable.finalBlobIdentifier);
            foundTempBlobIdentifiers = this.storage.list(temporaryBucketName, temporaryObjectPartialName);
        }
        if (!foundTempBlobIdentifiers.isEmpty()) {
            this.storage.delete(foundTempBlobIdentifiers);
        }
    }
}

