/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.test.data.paymenttype;

public enum DefaultPaymentType implements PaymentType {

    MONEY_TRANSFER("Money Transfer"), // This is how Fineract defines the payment type
    REPAYMENT_ADJUSTMENT_CHARGEBACK("Repayment Adjustment Chargeback"), //
    REPAYMENT_ADJUSTMENT_REFUND("Repayment Adjustment Refund"), //
    AUTOPAY, //
    DOWN_PAYMENT, //
    REAL_TIME, //
    SCHEDULED, //
    CHECK_PAYMENT, //
    OCA_PAYMENT; //

    private final String customName;

    DefaultPaymentType() {
        this(null);
    }

    DefaultPaymentType(String customName) {
        this.customName = customName;
    }

    @Override
    public String getName() {
        if (customName != null) {
            return customName;
        }
        return name();
    }
}
