package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.ExternalEventConfigurationResponse;
import org.apache.fineract.client.models.ExternalEventConfigurationUpdateRequest;
import org.apache.fineract.client.models.ExternalEventConfigurationUpdateResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ExternalEventConfigurationApi {
    /**
    * List all external event configurations
    * 
    * @return Call&lt;ExternalEventConfigurationResponse&gt;
    */
    @GET("v1/externalevents/configuration")
    Call<ExternalEventConfigurationResponse> getExternalEventConfigurations();

    /**
    * Enable/Disable external events posting
    * 
        * @param idempotencyKey  (optional)
        * @param externalEventConfigurationUpdateRequest  (optional)
    * @return Call&lt;ExternalEventConfigurationUpdateResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/externalevents/configuration")
    Call<ExternalEventConfigurationUpdateResponse> updateExternalEventConfigurations(@retrofit2.http.Header("Idempotency-Key") String idempotencyKey, @retrofit2.http.Body ExternalEventConfigurationUpdateRequest externalEventConfigurationUpdateRequest);


        /**
        * Enable/Disable external events posting
        * 
            * @param idempotencyKey  (optional)
            * @param externalEventConfigurationUpdateRequest  (optional)
        * @return Call&lt;ExternalEventConfigurationUpdateResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/externalevents/configuration")
    Call<ExternalEventConfigurationUpdateResponse> updateExternalEventConfigurations(@retrofit2.http.Header("Idempotency-Key") String idempotencyKey);

        /**
        * List all external event configurations
        * 
        * @return Call&lt;ExternalEventConfigurationResponse&gt;
        */
    @GET("v1/externalevents/configuration")
    Call<ExternalEventConfigurationResponse> getExternalEventConfigurations(@HeaderMap Map<String, String> headers);

        /**
        * Enable/Disable external events posting
        * 
            * @param idempotencyKey  (optional)
            * @param externalEventConfigurationUpdateRequest  (optional)
        * @return Call&lt;ExternalEventConfigurationUpdateResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/externalevents/configuration")
    Call<ExternalEventConfigurationUpdateResponse> updateExternalEventConfigurations(@retrofit2.http.Header("Idempotency-Key") String idempotencyKey, @retrofit2.http.Body ExternalEventConfigurationUpdateRequest externalEventConfigurationUpdateRequest, @HeaderMap Map<String, String> headers);


        /**
        * Enable/Disable external events posting
        * 
            * @param idempotencyKey  (optional)
            * @param externalEventConfigurationUpdateRequest  (optional)
        * @return Call&lt;ExternalEventConfigurationUpdateResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/externalevents/configuration")
    Call<ExternalEventConfigurationUpdateResponse> updateExternalEventConfigurations(@retrofit2.http.Header("Idempotency-Key") String idempotencyKey, @HeaderMap Map<String, String> headers);
}
