/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.account.service;

import java.util.Collection;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.self.account.data.SelfAccountTemplateData;
import org.apache.fineract.portfolio.self.account.data.SelfBeneficiariesTPTData;
import org.apache.fineract.portfolio.self.account.service.SelfBeneficiariesTPTReadPlatformService;
import org.apache.fineract.portfolio.self.account.service.SelfBeneficiariesTPTReadPlatformServiceImpl;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SelfBeneficiariesTPTReadPlatformServiceImpl
implements SelfBeneficiariesTPTReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final BeneficiaryMapper mapper;
    private final AccountTemplateMapper accountTemplateMapper;

    public SelfBeneficiariesTPTReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.mapper = new BeneficiaryMapper();
        this.accountTemplateMapper = new AccountTemplateMapper();
    }

    public Collection<SelfBeneficiariesTPTData> retrieveAll() {
        AppUser user = this.context.authenticatedUser();
        return this.jdbcTemplate.query(this.mapper.schema(), (RowMapper)this.mapper, new Object[]{user.getId(), user.getId()});
    }

    public Collection<SelfAccountTemplateData> retrieveTPTSelfAccountTemplateData(AppUser user) {
        return this.jdbcTemplate.query(this.accountTemplateMapper.schema(), (RowMapper)this.accountTemplateMapper, new Object[]{user.getId(), user.getId()});
    }

    public Long getTransferLimit(Long appUserId, Long accountId, Integer accountType) {
        StringBuilder sqlBuilder = new StringBuilder("select b.transfer_limit ");
        sqlBuilder.append(" from m_selfservice_beneficiaries_tpt as b ");
        sqlBuilder.append(" where b.app_user_id = ? ");
        sqlBuilder.append(" and b.account_id = ? ");
        sqlBuilder.append(" and b.account_type = ? ");
        sqlBuilder.append(" and b.is_active = true; ");
        return (Long)this.jdbcTemplate.queryForObject(sqlBuilder.toString(), Long.class, new Object[]{appUserId, accountId, accountType});
    }
}

