/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.meeting.data;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.meeting.attendance.data.ClientAttendanceData;

public final class MeetingData {
    private final Long id;
    private final LocalDate meetingDate;
    private final Collection<ClientAttendanceData> clientsAttendance;
    private final Collection<ClientData> clients;
    private final CalendarData calendarData;
    private final List<EnumOptionData> attendanceTypeOptions;

    public static MeetingData instance(Long id, LocalDate meetingDate) {
        Collection clientsAttendance = null;
        Collection clients = null;
        CalendarData calendarData = null;
        List attendanceTypeOptions = null;
        return new MeetingData(id, meetingDate, clientsAttendance, clients, calendarData, attendanceTypeOptions);
    }

    public static MeetingData withClientsAttendanceAndAttendanceTypeOptions(MeetingData meetingData, Collection<ClientAttendanceData> clientsAttendance, List<EnumOptionData> attendanceTypesOptions) {
        return new MeetingData(meetingData.id, meetingData.meetingDate, clientsAttendance, meetingData.clients, meetingData.calendarData, attendanceTypesOptions);
    }

    public static MeetingData template(Collection<ClientData> clients, CalendarData calendarData, List<EnumOptionData> attendanceTypeOptions) {
        Long id = null;
        LocalDate meetingDate = null;
        Collection clientsAttendance = null;
        return new MeetingData(id, meetingDate, clientsAttendance, clients, calendarData, attendanceTypeOptions);
    }

    public static MeetingData withAttendanceTypeOptions(MeetingData meetingData, List<EnumOptionData> attendanceTypeOptions) {
        return new MeetingData(meetingData.id, meetingData.meetingDate, meetingData.clientsAttendance, meetingData.clients, meetingData.calendarData, attendanceTypeOptions);
    }

    private MeetingData(Long id, LocalDate meetingDate, Collection<ClientAttendanceData> clientsAttendance, Collection<ClientData> clients, CalendarData calendarData, List<EnumOptionData> attendanceTypeOptions) {
        this.id = id;
        this.meetingDate = meetingDate;
        this.clientsAttendance = clientsAttendance;
        this.clients = clients;
        this.calendarData = calendarData;
        this.attendanceTypeOptions = attendanceTypeOptions;
    }

    public LocalDate getMeetingDate() {
        return this.meetingDate;
    }
}

