/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service.contracttermination;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAdjustTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanBalanceChangedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionContractTerminationPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanUndoContractTerminationBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanSubStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanaccount.service.ProgressiveLoanTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoanContractTerminationServiceImpl {
    private final LoanAssembler loanAssembler;
    private final LoanRepository loanRepository;
    private final LoanTransactionRepository loanTransactionRepository;
    private final NoteRepository noteRepository;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;
    private final LoanUtilService loanUtilService;
    private final ExternalIdFactory externalIdFactory;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanScheduleService loanScheduleService;
    private final LoanChargeValidator loanChargeValidator;
    private final ProgressiveLoanTransactionValidator loanTransactionValidator;
    private final LoanTransactionService loanTransactionService;

    public CommandProcessingResult applyContractTermination(JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(command.getLoanId());
        this.loanUtilService.checkClientOrGroupActive(loan);
        this.validateContractTermination(loan);
        ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        LoanTransaction contractTermination = LoanTransaction.contractTermination((Loan)loan, (LocalDate)DateUtils.getBusinessLocalDate(), (ExternalId)externalId);
        loan.setLoanSubStatus(LoanSubStatus.CONTRACT_TERMINATION);
        changes.put("subStatus", loan.getLoanSubStatus().getCode());
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanScheduleService.regenerateRepaymentSchedule(loan);
            this.reprocessLoanTransactionsService.reprocessTransactions(loan, List.of(contractTermination));
            loan.addLoanTransaction(contractTermination);
        } else {
            this.reprocessLoanTransactionsService.processLatestTransaction(contractTermination, loan);
            loan.addLoanTransaction(contractTermination);
        }
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)contractTermination, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.loanTransactionRepository.saveAndFlush((Object)contractTermination);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanTransactionContractTerminationPostBusinessEvent(contractTermination));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)contractTermination.getId()).withEntityExternalId(contractTermination.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(command.getLoanId()).with(changes).build();
    }

    public CommandProcessingResult undoContractTermination(JsonCommand command) {
        Long loanId = command.getLoanId();
        this.loanTransactionValidator.validateContractTerminationUndo(command, loanId);
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        LoanTransaction contractTerminationTransaction = loan.findContractTerminationTransaction();
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanUndoContractTerminationBusinessEvent(contractTerminationTransaction));
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(new LoanAdjustTransactionBusinessEvent.Data(contractTerminationTransaction)));
        String reversalExternalId = command.stringValueOfParameterNamedAllowingNull("reversalExternalId");
        ExternalId reversalTxnExternalId = ExternalIdFactory.produce((String)reversalExternalId);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)contractTerminationTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(contractTerminationTransaction.getLoan(), contractTerminationTransaction, "reversed");
        contractTerminationTransaction.reverse(reversalTxnExternalId);
        contractTerminationTransaction.manuallyAdjustedOrReversed();
        loan.liftContractTerminationSubStatus();
        changes.put("subStatus", (String)loan.getLoanSubStatus());
        this.loanTransactionRepository.saveAndFlush((Object)contractTerminationTransaction);
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null, null);
        if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
        } else if (loan.isProgressiveSchedule()) {
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoContractTerminationBusinessEvent(contractTerminationTransaction));
        LoanAdjustTransactionBusinessEvent.Data eventData = new LoanAdjustTransactionBusinessEvent.Data(contractTerminationTransaction);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(eventData));
        return new CommandProcessingResultBuilder().withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).withEntityId((Long)contractTerminationTransaction.getId()).withEntityExternalId(contractTerminationTransaction.getExternalId()).with(changes).build();
    }

    public void validateContractTermination(Loan loan) {
        ApiParameterError error;
        String defaultUserMessage;
        ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
        if (!loan.isOpen()) {
            defaultUserMessage = "Contract termination can not be applied, Loan Account is not Active.";
            error = ApiParameterError.generalError((String)"error.msg.loan.account.is.not.active.state", (String)"Contract termination can not be applied, Loan Account is not Active.", (Object[])new Object[0]);
            dataValidationErrors.add(error);
        }
        if (!loan.getLoanProduct().getLoanProductRelatedDetail().getLoanScheduleType().equals((Object)LoanScheduleType.PROGRESSIVE)) {
            defaultUserMessage = "Contract termination can not be applied, Loan product schedule type is not Progressive.";
            error = ApiParameterError.generalError((String)"error.msg.loan.contract.termination.is.only.supported.for.progressive.loan.schedule.type", (String)"Contract termination can not be applied, Loan product schedule type is not Progressive.", (Object[])new Object[0]);
            dataValidationErrors.add(error);
        }
        if (loan.isChargedOff()) {
            defaultUserMessage = "Contract termination can not be applied, Loan Account is Charge-Off.";
            error = ApiParameterError.generalError((String)"error.msg.loan.account.is.charge-off", (String)"Contract termination can not be applied, Loan Account is Charge-Off.", (Object[])new Object[0]);
            dataValidationErrors.add(error);
        }
        if (loan.isContractTermination()) {
            defaultUserMessage = "Contract termination can not be applied, Loan Account is already terminated.";
            error = ApiParameterError.generalError((String)"error.msg.loan.account.is.already.contract.termination.substate", (String)"Contract termination can not be applied, Loan Account is already terminated.", (Object[])new Object[0]);
            dataValidationErrors.add(error);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    @Generated
    public LoanContractTerminationServiceImpl(LoanAssembler loanAssembler, LoanRepository loanRepository, LoanTransactionRepository loanTransactionRepository, NoteRepository noteRepository, ReprocessLoanTransactionsService reprocessLoanTransactionsService, LoanUtilService loanUtilService, ExternalIdFactory externalIdFactory, BusinessEventNotifierService businessEventNotifierService, LoanScheduleService loanScheduleService, LoanChargeValidator loanChargeValidator, ProgressiveLoanTransactionValidator loanTransactionValidator, LoanTransactionService loanTransactionService) {
        this.loanAssembler = loanAssembler;
        this.loanRepository = loanRepository;
        this.loanTransactionRepository = loanTransactionRepository;
        this.noteRepository = noteRepository;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
        this.loanUtilService = loanUtilService;
        this.externalIdFactory = externalIdFactory;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanScheduleService = loanScheduleService;
        this.loanChargeValidator = loanChargeValidator;
        this.loanTransactionValidator = loanTransactionValidator;
        this.loanTransactionService = loanTransactionService;
    }
}

