/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.jobs.recalculateinterestforloan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.exception.OfficeNotFoundException;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.RecalculateInterestPoster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class RecalculateInterestForLoanTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecalculateInterestForLoanTasklet.class);
    private final LoanReadPlatformService loanReadPlatformService;
    private final LoanWritePlatformService loanWritePlatformService;
    private final ApplicationContext applicationContext;
    private final OfficeReadPlatformService officeReadPlatformService;
    @Qualifier(value="fineractConfigurableThreadPoolTaskExecutor")
    private final ThreadPoolTaskExecutor taskExecutor;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Map jobParameters = chunkContext.getStepContext().getStepExecution().getJobParameters().getParameters();
        if (!jobParameters.isEmpty()) {
            String officeId = (String)((JobParameter)jobParameters.get("officeId")).getValue();
            log.debug("recalculateInterest: officeId={}", (Object)officeId);
            Long officeIdLong = Long.valueOf(officeId);
            OfficeData office = this.officeReadPlatformService.retrieveOffice(officeIdLong);
            if (office == null) {
                throw new OfficeNotFoundException(officeIdLong);
            }
            int threadPoolSize = Integer.parseInt((String)((JobParameter)jobParameters.get("thread-pool-size")).getValue());
            int batchSize = Integer.parseInt((String)((JobParameter)jobParameters.get("batch-size")).getValue());
            this.recalculateInterest(office, threadPoolSize, batchSize);
        } else {
            Collection loanIds = this.loanReadPlatformService.fetchLoansForInterestRecalculation();
            if (!loanIds.isEmpty()) {
                ArrayList<Exception> errors = new ArrayList<Exception>();
                for (Long loanId : loanIds) {
                    log.debug("recalculateInterest: Loan ID = {}", (Object)loanId);
                    try {
                        this.loanWritePlatformService.recalculateInterest(loanId.longValue());
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                }
                if (!errors.isEmpty()) {
                    throw new JobExecutionException(errors);
                }
            }
        }
        return RepeatStatus.FINISHED;
    }

    private void recalculateInterest(OfficeData office, int threadPoolSize, int batchSize) {
        int pageSize = batchSize * threadPoolSize;
        this.taskExecutor.setCorePoolSize(threadPoolSize);
        this.taskExecutor.setMaxPoolSize(threadPoolSize);
        Long maxLoanIdInList = 0L;
        String officeHierarchy = office.getHierarchy() + "%";
        List loanIds = Collections.synchronizedList(this.loanReadPlatformService.fetchLoansForInterestRecalculation(Integer.valueOf(pageSize), maxLoanIdInList, officeHierarchy));
        do {
            int totalFilteredRecords = loanIds.size();
            log.debug("Starting accrual - total filtered records - {}", (Object)totalFilteredRecords);
            this.recalculateInterest(loanIds, threadPoolSize);
            maxLoanIdInList = maxLoanIdInList + (long)(pageSize + 1);
        } while (!CollectionUtils.isEmpty(loanIds = Collections.synchronizedList(this.loanReadPlatformService.fetchLoansForInterestRecalculation(Integer.valueOf(pageSize), maxLoanIdInList, officeHierarchy))));
    }

    private void recalculateInterest(List<Long> loanIds, int threadPoolSize) {
        if (loanIds == null || loanIds.isEmpty()) {
            return;
        }
        int actualBatchSize = (int)Math.ceil((double)loanIds.size() / (double)threadPoolSize);
        List<Future> responses = ListUtils.partition(loanIds, (int)actualBatchSize).stream().filter(subList -> !subList.isEmpty()).map(subList -> {
            RecalculateInterestPoster recalculateInterestPoster = (RecalculateInterestPoster)this.applicationContext.getBean(RecalculateInterestPoster.class);
            recalculateInterestPoster.setLoanIds((Collection)subList);
            recalculateInterestPoster.setFineractContext(ThreadLocalContextUtil.getContext());
            return recalculateInterestPoster;
        }).map(arg_0 -> ((ThreadPoolTaskExecutor)this.taskExecutor).submit(arg_0)).toList();
        this.checkCompletion(responses);
    }

    private void checkCompletion(List<Future<Void>> responses) {
        try {
            for (Future<Void> f : responses) {
                f.get();
            }
            boolean allThreadsExecuted = false;
            int noOfThreadsExecuted = 0;
            for (Future<Void> future : responses) {
                if (!future.isDone()) continue;
                ++noOfThreadsExecuted;
            }
            boolean bl = allThreadsExecuted = noOfThreadsExecuted == responses.size();
            if (!allThreadsExecuted) {
                log.error("All threads could not execute.");
            }
        }
        catch (InterruptedException e1) {
            log.error("Interrupted while posting IR entries", (Throwable)e1);
        }
        catch (ExecutionException e2) {
            log.error("Execution exception while posting IR entries", (Throwable)e2);
        }
    }

    @Generated
    public RecalculateInterestForLoanTasklet(LoanReadPlatformService loanReadPlatformService, LoanWritePlatformService loanWritePlatformService, ApplicationContext applicationContext, OfficeReadPlatformService officeReadPlatformService, @Qualifier(value="fineractConfigurableThreadPoolTaskExecutor") ThreadPoolTaskExecutor taskExecutor) {
        this.loanReadPlatformService = loanReadPlatformService;
        this.loanWritePlatformService = loanWritePlatformService;
        this.applicationContext = applicationContext;
        this.officeReadPlatformService = officeReadPlatformService;
        this.taskExecutor = taskExecutor;
    }
}

