/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.data.FineractJwtAuthenticationToken;
import org.apache.fineract.infrastructure.security.domain.TFAccessToken;
import org.apache.fineract.infrastructure.security.service.TwoFactorService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.filter.GenericFilterBean;

public class TwoFactorAuthenticationFilter
extends GenericFilterBean {
    private final TwoFactorService twoFactorService;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = null;
        if (context != null) {
            authentication = context.getAuthentication();
        }
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof AppUser) {
            AppUser user = (AppUser)authentication.getPrincipal();
            if (user == null) {
                return;
            }
            if (!user.hasSpecificPermissionTo("BYPASS_TWOFACTOR")) {
                String token = request.getHeader("Fineract-Platform-TFA-Token");
                if (token != null) {
                    TFAccessToken accessToken = this.twoFactorService.fetchAccessTokenForUser(user, token);
                    if (accessToken == null || !accessToken.isValid()) {
                        response.addHeader("WWW-Authenticate", "Basic realm=\"Fineract Platform API Two Factor\"");
                        response.sendError(401, "Invalid two-factor access token provided");
                        return;
                    }
                } else {
                    chain.doFilter(req, res);
                    return;
                }
            }
            ArrayList<SimpleGrantedAuthority> updatedAuthorities = new ArrayList<SimpleGrantedAuthority>(authentication.getAuthorities());
            updatedAuthorities.add(new SimpleGrantedAuthority("TWOFACTOR_AUTHENTICATED"));
            context.setAuthentication(this.createUpdatedAuthentication(authentication, updatedAuthorities));
        }
        chain.doFilter(req, res);
    }

    private Authentication createUpdatedAuthentication(Authentication currentAuthentication, List<GrantedAuthority> updatedAuthorities) throws ServletException {
        if (currentAuthentication instanceof UsernamePasswordAuthenticationToken) {
            UsernamePasswordAuthenticationToken updatedAuthentication = new UsernamePasswordAuthenticationToken(currentAuthentication.getPrincipal(), currentAuthentication.getCredentials(), updatedAuthorities);
            return updatedAuthentication;
        }
        if (currentAuthentication instanceof FineractJwtAuthenticationToken) {
            FineractJwtAuthenticationToken fineractJwtAuthenticationToken = (FineractJwtAuthenticationToken)currentAuthentication;
            FineractJwtAuthenticationToken updatedAuthentication = new FineractJwtAuthenticationToken((Jwt)fineractJwtAuthenticationToken.getToken(), updatedAuthorities, (UserDetails)currentAuthentication.getPrincipal());
            return updatedAuthentication;
        }
        throw new ServletException("Unknown authentication type: " + currentAuthentication.getClass().getName());
    }

    @Generated
    public TwoFactorAuthenticationFilter(TwoFactorService twoFactorService) {
        this.twoFactorService = twoFactorService;
    }
}

