/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.domain;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.fineract.infrastructure.security.data.OTPRequest;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
@ConditionalOnProperty(value={"fineract.security.2fa.enabled"})
public class OTPRequestRepository {
    private static final ConcurrentHashMap<Long, OTPRequest> OTT_REQUESTS = new ConcurrentHashMap();

    public OTPRequest getOTPRequestForUser(AppUser user) {
        Assert.notNull((Object)user, (String)"User must not be null");
        return (OTPRequest)OTT_REQUESTS.get(user.getId());
    }

    public void addOTPRequest(AppUser user, OTPRequest request) {
        Assert.notNull((Object)user, (String)"User must not be null");
        Assert.notNull((Object)request, (String)"Request must not be null");
        OTT_REQUESTS.put((Long)user.getId(), request);
    }

    public void deleteOTPRequestForUser(AppUser user) {
        OTT_REQUESTS.remove(user.getId());
    }
}

