/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.aggregationjob;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.data.JournalEntryAggregationSummaryData;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.services.JournalEntryAggregationWriterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class JournalEntryAggregationJobWriter
implements ItemWriter<JournalEntryAggregationSummaryData>,
StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JournalEntryAggregationJobWriter.class);
    private final JournalEntryAggregationWriterService journalEntryAggregationWriterService;
    private StepExecution stepExecution;

    public void beforeStep(@NonNull StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(@NonNull Chunk<? extends JournalEntryAggregationSummaryData> journalEntrySummaries) {
        Long jobExecutionId = this.stepExecution.getJobExecution().getId();
        List<JournalEntryAggregationSummaryData> summariesList = journalEntrySummaries.getItems().stream().map(item -> {
            item.setJobExecutionId(jobExecutionId);
            return item;
        }).toList();
        this.journalEntryAggregationWriterService.insertJournalEntrySummaryBatch(summariesList);
    }

    @Generated
    public JournalEntryAggregationJobWriter(JournalEntryAggregationWriterService journalEntryAggregationWriterService) {
        this.journalEntryAggregationWriterService = journalEntryAggregationWriterService;
    }
}

