/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.domain;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableCustom;
import org.apache.fineract.infrastructure.hooks.domain.HookConfiguration;
import org.apache.fineract.infrastructure.hooks.domain.HookResource;
import org.apache.fineract.infrastructure.hooks.domain.HookTemplate;
import org.apache.fineract.template.domain.Template;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="m_hook")
public final class Hook
extends AbstractAuditableCustom
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @Column(name="name", nullable=false, length=100)
    private String name;
    @Column(name="is_active", nullable=false)
    private Boolean isActive;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="hook", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<HookResource> events;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="hook", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<HookConfiguration> config;
    @ManyToOne(optional=true)
    @JoinColumn(name="template_id", referencedColumnName="id", nullable=false)
    private HookTemplate template;
    @ManyToOne(optional=true)
    @JoinColumn(name="ugd_template_id", referencedColumnName="id", nullable=true)
    private Template ugdTemplate;
    static final long serialVersionUID = -7156821376900219370L;

    public static Hook fromJson(JsonCommand command, HookTemplate template, Set<HookConfiguration> config, Set<HookResource> events, Template ugdTemplate) {
        String displayName = command.stringValueOfParameterNamed("displayName");
        Boolean isActive = command.booleanObjectValueOfParameterNamed("isActive");
        if (isActive == null) {
            isActive = false;
        }
        return new Hook(template, displayName, isActive, config, events, ugdTemplate);
    }

    private Hook(HookTemplate template, String displayName, Boolean isActive, Set<HookConfiguration> config, Set<HookResource> events, Template ugdTemplate) {
        this.events = new HashSet();
        this.config = new HashSet();
        this.template = template;
        this.name = StringUtils.isNotBlank((CharSequence)displayName) ? displayName.trim() : template.getName();
        this.isActive = isActive;
        if (!CollectionUtils.isEmpty(config)) {
            this.config = this.associateConfigWithThisHook(config);
        }
        if (!CollectionUtils.isEmpty(events)) {
            this.events = this.associateEventsWithThisHook(events);
        }
        this.ugdTemplate = ugdTemplate;
    }

    private Set<HookConfiguration> associateConfigWithThisHook(Set<HookConfiguration> config) {
        for (HookConfiguration hookConfiguration : config) {
            hookConfiguration.setHook(this);
        }
        return config;
    }

    private Set<HookResource> associateEventsWithThisHook(Set<HookResource> events) {
        for (HookResource hookResource : events) {
            hookResource.setHook(this);
        }
        return events;
    }

    public Long getUgdTemplateId() {
        Long templateId = null;
        if (this._persistence_get_ugdTemplate() != null) {
            templateId = (Long)this._persistence_get_ugdTemplate().getId();
        }
        return templateId;
    }

    public Map<String, Object> update(JsonCommand command) {
        JsonElement element;
        JsonArray jsonArray;
        Object newValue;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(5);
        if (command.isChangeInStringParameterNamed("displayName", this._persistence_get_name())) {
            newValue = command.stringValueOfParameterNamed("displayName");
            actualChanges.put("displayName", newValue);
            this._persistence_set_name((String)newValue);
        }
        if (command.isChangeInBooleanParameterNamed("isActive", this._persistence_get_isActive())) {
            newValue = command.booleanObjectValueOfParameterNamed("isActive");
            actualChanges.put("isActive", newValue);
            this._persistence_set_isActive((Boolean)newValue);
        }
        if (command.isChangeInLongParameterNamed("templateId", this.getUgdTemplateId())) {
            newValue = command.longValueOfParameterNamed("templateId");
            actualChanges.put("templateId", newValue);
        }
        if (command.hasParameter("events") && (jsonArray = command.arrayOfParameterNamed("events")) != null) {
            actualChanges.put("events", jsonArray);
        }
        if (command.hasParameter("config") && (element = command.parsedJson().getAsJsonObject().get("config")) != null) {
            actualChanges.put("config", element);
        }
        return actualChanges;
    }

    public boolean updateEvents(Set<HookResource> newHookEvents) {
        if (newHookEvents == null) {
            return false;
        }
        if (this._persistence_get_events() == null) {
            this._persistence_set_events(new HashSet());
        }
        this._persistence_get_events().clear();
        this._persistence_get_events().addAll(this.associateEventsWithThisHook(newHookEvents));
        return true;
    }

    public boolean updateConfig(Set<HookConfiguration> newHookConfig) {
        if (newHookConfig == null) {
            return false;
        }
        if (this._persistence_get_config() == null) {
            this._persistence_set_config(new HashSet());
        }
        this._persistence_get_config().clear();
        this._persistence_get_config().addAll(this.associateConfigWithThisHook(newHookConfig));
        return true;
    }

    @Generated
    public String getName() {
        return this._persistence_get_name();
    }

    @Generated
    public Boolean getIsActive() {
        return this._persistence_get_isActive();
    }

    @Generated
    public Set<HookResource> getEvents() {
        return this._persistence_get_events();
    }

    @Generated
    public Set<HookConfiguration> getConfig() {
        return this._persistence_get_config();
    }

    @Generated
    public HookTemplate getTemplate() {
        return this._persistence_get_template();
    }

    @Generated
    public Template getUgdTemplate() {
        return this._persistence_get_ugdTemplate();
    }

    @Generated
    public Hook setName(String name) {
        this._persistence_set_name(name);
        return this;
    }

    @Generated
    public Hook setIsActive(Boolean isActive) {
        this._persistence_set_isActive(isActive);
        return this;
    }

    @Generated
    public Hook setEvents(Set<HookResource> events) {
        this._persistence_set_events(events);
        return this;
    }

    @Generated
    public Hook setConfig(Set<HookConfiguration> config) {
        this._persistence_set_config(config);
        return this;
    }

    @Generated
    public Hook setTemplate(HookTemplate template) {
        this._persistence_set_template(template);
        return this;
    }

    @Generated
    public Hook setUgdTemplate(Template ugdTemplate) {
        this._persistence_set_ugdTemplate(ugdTemplate);
        return this;
    }

    @Generated
    public Hook() {
        this.events = new HashSet();
        this.config = new HashSet();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Hook(persistenceObject);
    }

    public Hook(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "template") {
            return this.template;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "isActive") {
            return this.isActive;
        }
        if (string == "config") {
            return this.config;
        }
        if (string == "ugdTemplate") {
            return this.ugdTemplate;
        }
        if (string == "events") {
            return this.events;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "template") {
            this.template = (HookTemplate)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "isActive") {
            this.isActive = (Boolean)object;
            return;
        }
        if (string == "config") {
            this.config = (Set)object;
            return;
        }
        if (string == "ugdTemplate") {
            this.ugdTemplate = (Template)object;
            return;
        }
        if (string == "events") {
            this.events = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public HookTemplate _persistence_get_template() {
        this._persistence_checkFetched("template");
        return this.template;
    }

    public void _persistence_set_template(HookTemplate hookTemplate) {
        this._persistence_checkFetchedForSet("template");
        this.template = hookTemplate;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public Boolean _persistence_get_isActive() {
        this._persistence_checkFetched("isActive");
        return this.isActive;
    }

    public void _persistence_set_isActive(Boolean bl) {
        this._persistence_checkFetchedForSet("isActive");
        this.isActive = bl;
    }

    public Set _persistence_get_config() {
        this._persistence_checkFetched("config");
        return this.config;
    }

    public void _persistence_set_config(Set set) {
        this._persistence_checkFetchedForSet("config");
        this.config = set;
    }

    public Template _persistence_get_ugdTemplate() {
        this._persistence_checkFetched("ugdTemplate");
        return this.ugdTemplate;
    }

    public void _persistence_set_ugdTemplate(Template template) {
        this._persistence_checkFetchedForSet("ugdTemplate");
        this.ugdTemplate = template;
    }

    public Set _persistence_get_events() {
        this._persistence_checkFetched("events");
        return this.events;
    }

    public void _persistence_set_events(Set set) {
        this._persistence_checkFetchedForSet("events");
        this.events = set;
    }
}

