/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreditBureauTokenCommandFromApiJsonDeserializer {
    public static final String ACCESS_TOKEN = "access_token";
    public static final String TOKEN_TYPE = "token_type";
    public static final String EXPIRES_IN = "expires_in";
    public static final String USER_NAME = "userName";
    public static final String ISSUED = ".issued";
    public static final String EXPIRES = ".expires";
    public static final String PASSWORD = "password";
    public static final String SUBSCRIPTION_ID = "subscriptionId";
    public static final String SUBSCRIPTION_KEY = "subscriptionKey";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("access_token", "token_type", "expires_in", "userName", ".issued", ".expires"));
    private static final Set<String> SUPPORTED_TOKEN_CONFIG_PARAMETERS = new HashSet<String>(Arrays.asList("userName", "password", "subscriptionId", "subscriptionKey"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public CreditBureauTokenCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("tokens");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String access_token = this.fromApiJsonHelper.extractStringNamed(ACCESS_TOKEN, element);
        baseDataValidator.reset().parameter(ACCESS_TOKEN).value((Object)access_token).notBlank().notExceedingLengthOf(Integer.valueOf(1000));
        String token_type = this.fromApiJsonHelper.extractStringNamed(TOKEN_TYPE, element);
        baseDataValidator.reset().parameter(TOKEN_TYPE).value((Object)token_type).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String expires_in = this.fromApiJsonHelper.extractStringNamed(EXPIRES_IN, element);
        baseDataValidator.reset().parameter(EXPIRES_IN).value((Object)expires_in).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String userName = this.fromApiJsonHelper.extractStringNamed(USER_NAME, element);
        baseDataValidator.reset().parameter(USER_NAME).value((Object)userName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String issued = this.fromApiJsonHelper.extractStringNamed(ISSUED, element);
        baseDataValidator.reset().parameter(ISSUED).value((Object)issued).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String expires = this.fromApiJsonHelper.extractStringNamed(EXPIRES, element);
        baseDataValidator.reset().parameter(EXPIRES).value((Object)expires).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUsingTokenConfig(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_TOKEN_CONFIG_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("configdata");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String userName = this.fromApiJsonHelper.extractStringNamed(USER_NAME, element);
        baseDataValidator.reset().parameter(USER_NAME).value((Object)userName).notBlank().notExceedingLengthOf(Integer.valueOf(1000));
        String password = this.fromApiJsonHelper.extractStringNamed(PASSWORD, element);
        baseDataValidator.reset().parameter(PASSWORD).value((Object)password).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String subscriptionId = this.fromApiJsonHelper.extractStringNamed(SUBSCRIPTION_ID, element);
        baseDataValidator.reset().parameter(SUBSCRIPTION_ID).value((Object)subscriptionId).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String subscriptionKey = this.fromApiJsonHelper.extractStringNamed(SUBSCRIPTION_KEY, element);
        baseDataValidator.reset().parameter(SUBSCRIPTION_KEY).value((Object)subscriptionKey).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

