/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.service;

import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.accounting.glaccount.data.GLAccountData;
import org.apache.fineract.accounting.glaccount.service.GLAccountReadPlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.populator.CenterSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ChargeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ClientSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ExtrasSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.FixedDepositProductSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.GlAccountSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.GroupSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.LoanProductSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.PersonnelSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.RecurringDepositProductSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.RoleSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.SavingsAccountSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.SavingsProductSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.SharedProductsSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.WorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.centers.CentersWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.chartofaccounts.ChartOfAccountsWorkbook;
import org.apache.fineract.infrastructure.bulkimport.populator.client.ClientEntityWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.client.ClientPersonWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.fixeddeposits.FixedDepositTransactionWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.fixeddeposits.FixedDepositWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.group.GroupsWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.guarantor.GuarantorWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.journalentry.JournalEntriesWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.loan.LoanWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.loanrepayment.LoanRepaymentWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.office.OfficeWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.recurringdeposit.RecurringDepositTransactionWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.recurringdeposit.RecurringDepositWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.savings.SavingsTransactionsWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.savings.SavingsWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.shareaccount.SharedAccountWorkBookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.staff.StaffWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.users.UserWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.fund.data.FundData;
import org.apache.fineract.portfolio.fund.service.FundReadPlatformService;
import org.apache.fineract.portfolio.group.data.CenterData;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.service.CenterReadPlatformService;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.paymenttype.data.PaymentTypeData;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.products.data.ProductData;
import org.apache.fineract.portfolio.products.service.ShareProductReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.DepositProductData;
import org.apache.fineract.portfolio.savings.data.FixedDepositProductData;
import org.apache.fineract.portfolio.savings.data.RecurringDepositProductData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsProductData;
import org.apache.fineract.portfolio.savings.service.DepositProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductData;
import org.apache.fineract.useradministration.data.RoleData;
import org.apache.fineract.useradministration.service.RoleReadPlatformService;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BulkImportWorkbookPopulatorServiceImpl
implements BulkImportWorkbookPopulatorService {
    private static final Logger LOG = LoggerFactory.getLogger(BulkImportWorkbookPopulatorServiceImpl.class);
    private final PlatformSecurityContext context;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final ClientReadPlatformService clientReadPlatformService;
    private final CenterReadPlatformService centerReadPlatformService;
    private final GroupReadPlatformService groupReadPlatformService;
    private final FundReadPlatformService fundReadPlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final LoanReadPlatformService loanReadPlatformService;
    private final GLAccountReadPlatformService glAccountReadPlatformService;
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final SavingsProductReadPlatformService savingsProductReadPlatformService;
    private final ShareProductReadPlatformService shareProductReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final DepositProductReadPlatformService depositProductReadPlatformService;
    private final RoleReadPlatformService roleReadPlatformService;

    @Autowired
    public BulkImportWorkbookPopulatorServiceImpl(PlatformSecurityContext context, OfficeReadPlatformService officeReadPlatformService, StaffReadPlatformService staffReadPlatformService, ClientReadPlatformService clientReadPlatformService, CenterReadPlatformService centerReadPlatformService, GroupReadPlatformService groupReadPlatformService, FundReadPlatformService fundReadPlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService, LoanProductReadPlatformService loanProductReadPlatformService, CurrencyReadPlatformService currencyReadPlatformService, LoanReadPlatformService loanReadPlatformService, GLAccountReadPlatformService glAccountReadPlatformService, SavingsAccountReadPlatformService savingsAccountReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, SavingsProductReadPlatformService savingsProductReadPlatformService, ShareProductReadPlatformService shareProductReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, DepositProductReadPlatformService depositProductReadPlatformService, RoleReadPlatformService roleReadPlatformService) {
        this.officeReadPlatformService = officeReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.context = context;
        this.clientReadPlatformService = clientReadPlatformService;
        this.centerReadPlatformService = centerReadPlatformService;
        this.groupReadPlatformService = groupReadPlatformService;
        this.fundReadPlatformService = fundReadPlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.loanReadPlatformService = loanReadPlatformService;
        this.glAccountReadPlatformService = glAccountReadPlatformService;
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.savingsProductReadPlatformService = savingsProductReadPlatformService;
        this.shareProductReadPlatformService = shareProductReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.depositProductReadPlatformService = depositProductReadPlatformService;
        this.roleReadPlatformService = roleReadPlatformService;
    }

    public Response getTemplate(String entityType, Long officeId, Long staffId, String dateFormat) {
        WorkbookPopulator populator = null;
        HSSFWorkbook workbook = new HSSFWorkbook();
        if (entityType != null) {
            if (entityType.trim().equalsIgnoreCase(GlobalEntityType.CLIENTS_PERSON.toString()) || entityType.trim().equalsIgnoreCase(GlobalEntityType.CLIENTS_ENTITY.toString())) {
                populator = this.populateClientWorkbook(entityType, officeId, staffId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.CENTERS.toString())) {
                populator = this.populateCenterWorkbook(officeId, staffId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.GROUPS.toString())) {
                populator = this.populateGroupsWorkbook(officeId, staffId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.LOANS.toString())) {
                populator = this.populateLoanWorkbook(officeId, staffId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.LOAN_TRANSACTIONS.toString())) {
                populator = this.populateLoanRepaymentWorkbook(officeId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.GL_JOURNAL_ENTRIES.toString())) {
                populator = this.populateJournalEntriesWorkbook(officeId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.GUARANTORS.toString())) {
                populator = this.populateGuarantorWorkbook(officeId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.OFFICES.toString())) {
                populator = this.populateOfficeWorkbook();
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.CHART_OF_ACCOUNTS.toString())) {
                populator = this.populateChartOfAccountsWorkbook(officeId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.STAFF.toString())) {
                populator = this.populateStaffWorkbook(officeId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.SHARE_ACCOUNTS.toString())) {
                populator = this.populateSharedAcountsWorkbook(officeId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.SAVINGS_ACCOUNT.toString())) {
                populator = this.populateSavingsAccountWorkbook(officeId, staffId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.SAVINGS_TRANSACTIONS.toString())) {
                populator = this.populateSavingsTransactionWorkbook(officeId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS.toString())) {
                populator = this.populateRecurringDepositWorkbook(officeId, staffId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS_TRANSACTIONS.toString())) {
                populator = this.populateRecurringDepositTransactionWorkbook(officeId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.FIXED_DEPOSIT_ACCOUNTS.toString())) {
                populator = this.populateFixedDepositWorkbook(officeId, staffId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.FIXED_DEPOSIT_TRANSACTIONS.toString())) {
                populator = this.populateFixedDepositTransactionsWorkbook(officeId);
            } else if (entityType.trim().equalsIgnoreCase(GlobalEntityType.USERS.toString())) {
                populator = this.populateUserWorkbook(officeId, staffId);
            } else {
                throw new GeneralPlatformDomainRuleException("error.msg.unable.to.find.resource", "Unable to find requested resource", new Object[0]);
            }
            populator.populate((Workbook)workbook, dateFormat);
            return this.buildResponse((Workbook)workbook, entityType);
        }
        throw new GeneralPlatformDomainRuleException("error.msg.given.entity.type.null", "Given Entity type is null", new Object[0]);
    }

    private WorkbookPopulator populateClientWorkbook(String entityType, Long officeId, Long staffId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("STAFF");
        List offices = this.fetchOffices(officeId);
        List staff = this.fetchStaff(staffId);
        List clientTypeCodeValues = this.fetchCodeValuesByCodeName("ClientType");
        List clientClassification = this.fetchCodeValuesByCodeName("ClientClassification");
        List addressTypesCodeValues = this.fetchCodeValuesByCodeName("ADDRESS_TYPE");
        List stateProvinceCodeValues = this.fetchCodeValuesByCodeName("STATE");
        List countryCodeValues = this.fetchCodeValuesByCodeName("COUNTRY");
        if (entityType.trim().equalsIgnoreCase(GlobalEntityType.CLIENTS_PERSON.toString())) {
            List genderCodeValues = this.fetchCodeValuesByCodeName("Gender");
            return new ClientPersonWorkbookPopulator(new OfficeSheetPopulator(offices), new PersonnelSheetPopulator(staff, offices), clientTypeCodeValues, genderCodeValues, clientClassification, addressTypesCodeValues, stateProvinceCodeValues, countryCodeValues);
        }
        if (entityType.trim().equalsIgnoreCase(GlobalEntityType.CLIENTS_ENTITY.toString())) {
            List constitutionCodeValues = this.fetchCodeValuesByCodeName("Constitution");
            List mainBusinessline = this.fetchCodeValuesByCodeName("Main Business Line");
            return new ClientEntityWorkbookPopulator(new OfficeSheetPopulator(offices), new PersonnelSheetPopulator(staff, offices), clientTypeCodeValues, constitutionCodeValues, mainBusinessline, clientClassification, addressTypesCodeValues, stateProvinceCodeValues, countryCodeValues);
        }
        return null;
    }

    private Response buildResponse(Workbook workbook, String entity) {
        String filename = entity + DateUtils.getBusinessLocalDate().toString() + ".xls";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)baos);
        }
        catch (IOException e) {
            LOG.error("Problem occurred in buildResponse function", (Throwable)e);
        }
        Response.ResponseBuilder response = Response.ok((Object)baos.toByteArray());
        response.header("Content-Disposition", (Object)("attachment; filename=\"" + filename + "\""));
        response.header("Content-Type", (Object)"application/vnd.ms-excel");
        return response.build();
    }

    private List<OfficeData> fetchOffices(Long officeId) {
        List<Object> offices = null;
        if (officeId == null) {
            Boolean includeAllOffices = Boolean.TRUE;
            offices = (List)this.officeReadPlatformService.retrieveAllOffices(includeAllOffices.booleanValue(), SearchParameters.builder().orderBy("id").sortOrder("asc").build());
        } else {
            offices = new ArrayList<OfficeData>();
            offices.add(this.officeReadPlatformService.retrieveOffice(officeId));
        }
        return offices;
    }

    private List<ChargeData> fetchCharges() {
        return this.chargeReadPlatformService.retrieveAllCharges();
    }

    private List<StaffData> fetchStaff(Long staffId) {
        ArrayList<StaffData> staff = null;
        if (staffId == null) {
            staff = this.staffReadPlatformService.retrieveAllStaff(null, Boolean.FALSE.booleanValue(), null);
        } else {
            staff = new ArrayList<StaffData>();
            staff.add(this.staffReadPlatformService.retrieveStaff(staffId));
        }
        return staff;
    }

    private List<CodeValueData> fetchCodeValuesByCodeName(String codeName) {
        List codeValues = null;
        if (codeName == null) {
            throw new NullPointerException();
        }
        codeValues = this.codeValueReadPlatformService.retrieveCodeValuesByCode(codeName);
        return codeValues;
    }

    private List<SavingsProductData> fetchSavingsProducts() {
        List savingsProducts = (List)this.savingsProductReadPlatformService.retrieveAll();
        return savingsProducts;
    }

    private WorkbookPopulator populateCenterWorkbook(Long officeId, Long staffId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("STAFF");
        this.context.authenticatedUser().validateHasReadPermission("GROUP");
        List offices = this.fetchOffices(officeId);
        List staff = this.fetchStaff(staffId);
        List groups = this.fetchGroups(officeId);
        return new CentersWorkbookPopulator(new OfficeSheetPopulator(offices), new PersonnelSheetPopulator(staff, offices), new GroupSheetPopulator(groups, offices));
    }

    private WorkbookPopulator populateGroupsWorkbook(Long officeId, Long staffId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("STAFF");
        this.context.authenticatedUser().validateHasReadPermission("CENTER");
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        List offices = this.fetchOffices(officeId);
        List staff = this.fetchStaff(staffId);
        List centers = this.fetchCenters(officeId);
        List clients = this.fetchClients(officeId);
        return new GroupsWorkbookPopulator(new OfficeSheetPopulator(offices), new PersonnelSheetPopulator(staff, offices), new CenterSheetPopulator(centers, offices), new ClientSheetPopulator(clients, offices));
    }

    private List<CenterData> fetchCenters(Long officeId) {
        List centers = null;
        if (officeId == null) {
            centers = (List)this.centerReadPlatformService.retrieveAll(null, null);
        } else {
            SearchParameters searchParameters = SearchParameters.builder().officeId(officeId).build();
            centers = (List)this.centerReadPlatformService.retrieveAll(searchParameters, null);
        }
        return centers;
    }

    private List<ClientData> fetchClients(Long officeId) {
        ArrayList<ClientData> clients;
        block4: {
            block3: {
                clients = null;
                if (officeId != null) break block3;
                Page clientDataPage = this.clientReadPlatformService.retrieveAll(null);
                if (clientDataPage == null) break block4;
                clients = new ArrayList<ClientData>();
                for (ClientData client : clientDataPage.getPageItems()) {
                    clients.add(client);
                }
                break block4;
            }
            SearchParameters searchParameters = SearchParameters.builder().officeId(officeId).build();
            Page clientDataPage = this.clientReadPlatformService.retrieveAll(searchParameters);
            if (clientDataPage != null) {
                clients = new ArrayList();
                for (ClientData client : clientDataPage.getPageItems()) {
                    clients.add(client);
                }
            }
        }
        return clients;
    }

    private WorkbookPopulator populateLoanWorkbook(Long officeId, Long staffId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("STAFF");
        this.context.authenticatedUser().validateHasReadPermission("GROUP");
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        this.context.authenticatedUser().validateHasReadPermission("LOANPRODUCT");
        this.context.authenticatedUser().validateHasReadPermission("FUNDS");
        this.context.authenticatedUser().validateHasReadPermission("PAYMENTTYPE");
        this.context.authenticatedUser().validateHasReadPermission("CURRENCY");
        List offices = this.fetchOffices(officeId);
        List staff = this.fetchStaff(staffId);
        List clients = this.fetchClients(officeId);
        List groups = this.fetchGroups(officeId);
        List charges = this.fetchCharges();
        List loanproducts = this.fetchLoanProducts();
        List funds = this.fetchFunds();
        List paymentTypes = this.fetchPaymentTypes();
        List currencies = this.fetchCurrencies();
        return new LoanWorkbookPopulator(new OfficeSheetPopulator(offices), new ClientSheetPopulator(clients, offices), new GroupSheetPopulator(groups, offices), new PersonnelSheetPopulator(staff, offices), new LoanProductSheetPopulator(loanproducts), new ChargeSheetPopulator(charges), new ExtrasSheetPopulator(funds, paymentTypes, currencies));
    }

    private List<CurrencyData> fetchCurrencies() {
        List currencies = this.currencyReadPlatformService.retrieveAllPlatformCurrencies();
        return currencies;
    }

    private List<PaymentTypeData> fetchPaymentTypes() {
        List paymentTypeData = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        return paymentTypeData;
    }

    private List<FundData> fetchFunds() {
        List funds = this.fundReadPlatformService.retrieveAllFunds();
        return funds;
    }

    private List<LoanProductData> fetchLoanProducts() {
        List loanproducts = (List)this.loanProductReadPlatformService.retrieveAllLoanProducts();
        return loanproducts;
    }

    private List<GroupGeneralData> fetchGroups(Long officeId) {
        List groups = null;
        if (officeId == null) {
            groups = (List)this.groupReadPlatformService.retrieveAll(null, null);
        } else {
            SearchParameters searchParameters = SearchParameters.builder().officeId(officeId).build();
            groups = (List)this.groupReadPlatformService.retrieveAll(searchParameters, null);
        }
        return groups;
    }

    private WorkbookPopulator populateLoanRepaymentWorkbook(Long officeId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        this.context.authenticatedUser().validateHasReadPermission("FUNDS");
        this.context.authenticatedUser().validateHasReadPermission("PAYMENTTYPE");
        this.context.authenticatedUser().validateHasReadPermission("CURRENCY");
        List offices = this.fetchOffices(officeId);
        List clients = this.fetchClients(officeId);
        List funds = this.fetchFunds();
        List paymentTypes = this.fetchPaymentTypes();
        List currencies = this.fetchCurrencies();
        List loans = this.fetchLoanAccounts(officeId);
        return new LoanRepaymentWorkbookPopulator(loans, new OfficeSheetPopulator(offices), new ClientSheetPopulator(clients, offices), new ExtrasSheetPopulator(funds, paymentTypes, currencies));
    }

    private List<LoanAccountData> fetchLoanAccounts(Long officeId) {
        List loanAccounts = null;
        if (officeId == null) {
            loanAccounts = this.loanReadPlatformService.retrieveAll(null).getPageItems();
        } else {
            SearchParameters searchParameters = SearchParameters.builder().officeId(officeId).build();
            loanAccounts = this.loanReadPlatformService.retrieveAll(searchParameters).getPageItems();
        }
        return loanAccounts;
    }

    private WorkbookPopulator populateJournalEntriesWorkbook(Long officeId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("GLACCOUNT");
        this.context.authenticatedUser().validateHasReadPermission("FUNDS");
        this.context.authenticatedUser().validateHasReadPermission("PAYMENTTYPE");
        this.context.authenticatedUser().validateHasReadPermission("CURRENCY");
        List offices = this.fetchOffices(officeId);
        List glAccounts = this.fetchGLAccounts();
        List funds = this.fetchFunds();
        List paymentTypes = this.fetchPaymentTypes();
        List currencies = this.fetchCurrencies();
        return new JournalEntriesWorkbookPopulator(new OfficeSheetPopulator(offices), new GlAccountSheetPopulator(glAccounts), new ExtrasSheetPopulator(funds, paymentTypes, currencies));
    }

    private List<GLAccountData> fetchGLAccounts() {
        List glaccounts = this.glAccountReadPlatformService.retrieveAllGLAccounts(null, null, null, null, null, null);
        return glaccounts;
    }

    private WorkbookPopulator populateGuarantorWorkbook(Long officeId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("STAFF");
        List offices = this.fetchOffices(officeId);
        List clients = this.fetchClients(officeId);
        List loans = this.fetchLoanAccounts(officeId);
        List savingsaccounts = this.fetchSavingsAccounts(officeId);
        List guarantorRelationshipTypes = this.fetchCodeValuesByCodeName("GuarantorRelationship");
        return new GuarantorWorkbookPopulator(new OfficeSheetPopulator(offices), new ClientSheetPopulator(clients, offices), loans, savingsaccounts, guarantorRelationshipTypes);
    }

    private List<SavingsAccountData> fetchSavingsAccounts(Long officeId) {
        List savingsAccounts = null;
        if (officeId != null) {
            SearchParameters searchParameters = SearchParameters.builder().officeId(officeId).status("300").build();
            savingsAccounts = this.savingsAccountReadPlatformService.retrieveAll(searchParameters).getPageItems();
        } else {
            SearchParameters searchParameters = SearchParameters.builder().status("300").build();
            savingsAccounts = this.savingsAccountReadPlatformService.retrieveAll(searchParameters).getPageItems();
        }
        return savingsAccounts;
    }

    private WorkbookPopulator populateOfficeWorkbook() {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        List offices = this.fetchOffices(null);
        return new OfficeWorkbookPopulator(offices);
    }

    private WorkbookPopulator populateChartOfAccountsWorkbook(Long officeId) {
        this.context.authenticatedUser().validateHasReadPermission("GLACCOUNT");
        List glAccounts = this.fetchGLAccounts();
        List offices = this.fetchOffices(null);
        return new ChartOfAccountsWorkbook(glAccounts, offices, this.currencyReadPlatformService.retrieveAllowedCurrencies());
    }

    private WorkbookPopulator populateStaffWorkbook(Long officeId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        List offices = this.fetchOffices(officeId);
        return new StaffWorkbookPopulator(new OfficeSheetPopulator(offices));
    }

    private WorkbookPopulator populateSharedAcountsWorkbook(Long officeId) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        this.context.authenticatedUser().validateHasReadPermission("SHAREDACCOUNT");
        List shareProductDataList = this.fetchSharedProducts();
        List chargesForShares = this.fetchChargesForShares();
        List clientDataList = this.fetchClients(officeId);
        List officeDataList = this.fetchOffices(officeId);
        List savingsAccounts = this.fetchSavingsAccounts(officeId);
        return new SharedAccountWorkBookPopulator(new SharedProductsSheetPopulator(shareProductDataList, chargesForShares), new ClientSheetPopulator(clientDataList, officeDataList), new SavingsAccountSheetPopulator(savingsAccounts));
    }

    private List<ChargeData> fetchChargesForShares() {
        List chargesForShares = this.chargeReadPlatformService.retrieveSharesApplicableCharges();
        return chargesForShares;
    }

    private List<ShareProductData> fetchSharedProducts() {
        List productDataList = this.shareProductReadPlatformService.retrieveAllProducts(Integer.valueOf(0), Integer.valueOf(50)).getPageItems();
        ArrayList<ShareProductData> sharedProductDataList = new ArrayList<ShareProductData>();
        if (productDataList != null) {
            for (ProductData data : productDataList) {
                ShareProductData shareProduct = (ShareProductData)data;
                sharedProductDataList.add(shareProduct);
            }
        }
        return sharedProductDataList;
    }

    private WorkbookPopulator populateSavingsAccountWorkbook(Long officeId, Long staffId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("STAFF");
        this.context.authenticatedUser().validateHasReadPermission("GROUP");
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        this.context.authenticatedUser().validateHasReadPermission("SAVINGSPRODUCT");
        List offices = this.fetchOffices(officeId);
        List staff = this.fetchStaff(staffId);
        List clients = this.fetchClients(officeId);
        List groups = this.fetchGroups(officeId);
        List savingsProducts = this.fetchSavingsProducts();
        return new SavingsWorkbookPopulator(new OfficeSheetPopulator(offices), new ClientSheetPopulator(clients, offices), new GroupSheetPopulator(groups, offices), new PersonnelSheetPopulator(staff, offices), new SavingsProductSheetPopulator(savingsProducts));
    }

    private WorkbookPopulator populateSavingsTransactionWorkbook(Long officeId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        this.context.authenticatedUser().validateHasReadPermission("FUNDS");
        this.context.authenticatedUser().validateHasReadPermission("PAYMENTTYPE");
        this.context.authenticatedUser().validateHasReadPermission("CURRENCY");
        List offices = this.fetchOffices(officeId);
        List clients = this.fetchClients(officeId);
        List funds = this.fetchFunds();
        List paymentTypes = this.fetchPaymentTypes();
        List currencies = this.fetchCurrencies();
        List savingsAccounts = this.fetchSavingsAccounts(officeId);
        return new SavingsTransactionsWorkbookPopulator(new OfficeSheetPopulator(offices), new ClientSheetPopulator(clients, offices), new ExtrasSheetPopulator(funds, paymentTypes, currencies), savingsAccounts);
    }

    private WorkbookPopulator populateRecurringDepositWorkbook(Long officeId, Long staffId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        this.context.authenticatedUser().validateHasReadPermission("STAFF");
        this.context.authenticatedUser().validateHasReadPermission("RECURRINGDEPOSITPRODUCT");
        List offices = this.fetchOffices(officeId);
        List clients = this.fetchClients(officeId);
        List staff = this.fetchStaff(staffId);
        List recurringDepositProducts = this.fetchRecurringDepositProducts();
        return new RecurringDepositWorkbookPopulator(new OfficeSheetPopulator(offices), new ClientSheetPopulator(clients, offices), new PersonnelSheetPopulator(staff, offices), new RecurringDepositProductSheetPopulator(recurringDepositProducts));
    }

    private List<RecurringDepositProductData> fetchRecurringDepositProducts() {
        List depositProducts = (List)this.depositProductReadPlatformService.retrieveAll(DepositAccountType.RECURRING_DEPOSIT);
        ArrayList<RecurringDepositProductData> recurringDepositProducts = new ArrayList<RecurringDepositProductData>();
        for (DepositProductData depositproduct : depositProducts) {
            RecurringDepositProductData recurringDepositProduct = (RecurringDepositProductData)depositproduct;
            recurringDepositProducts.add(recurringDepositProduct);
        }
        return recurringDepositProducts;
    }

    private WorkbookPopulator populateRecurringDepositTransactionWorkbook(Long officeId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        this.context.authenticatedUser().validateHasReadPermission("FUNDS");
        this.context.authenticatedUser().validateHasReadPermission("PAYMENTTYPE");
        this.context.authenticatedUser().validateHasReadPermission("CURRENCY");
        List offices = this.fetchOffices(officeId);
        List clients = this.fetchClients(officeId);
        List funds = this.fetchFunds();
        List paymentTypes = this.fetchPaymentTypes();
        List currencies = this.fetchCurrencies();
        List savingsAccounts = this.fetchSavingsAccounts(officeId);
        return new RecurringDepositTransactionWorkbookPopulator(new OfficeSheetPopulator(offices), new ClientSheetPopulator(clients, offices), new ExtrasSheetPopulator(funds, paymentTypes, currencies), savingsAccounts);
    }

    private WorkbookPopulator populateFixedDepositWorkbook(Long officeId, Long staffId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        this.context.authenticatedUser().validateHasReadPermission("STAFF");
        this.context.authenticatedUser().validateHasReadPermission("FIXEDDEPOSITPRODUCT");
        List offices = this.fetchOffices(officeId);
        List clients = this.fetchClients(officeId);
        List staff = this.fetchStaff(staffId);
        List fixedDepositProducts = this.fetchFixedDepositProducts();
        return new FixedDepositWorkbookPopulator(new OfficeSheetPopulator(offices), new ClientSheetPopulator(clients, offices), new PersonnelSheetPopulator(staff, offices), new FixedDepositProductSheetPopulator(fixedDepositProducts));
    }

    private List<FixedDepositProductData> fetchFixedDepositProducts() {
        List depositProducts = (List)this.depositProductReadPlatformService.retrieveAll(DepositAccountType.FIXED_DEPOSIT);
        ArrayList<FixedDepositProductData> fixedDepositProducts = new ArrayList<FixedDepositProductData>();
        for (DepositProductData depositproduct : depositProducts) {
            FixedDepositProductData fixedDepositProduct = (FixedDepositProductData)depositproduct;
            fixedDepositProducts.add(fixedDepositProduct);
        }
        return fixedDepositProducts;
    }

    private WorkbookPopulator populateUserWorkbook(Long officeId, Long staffId) {
        this.context.authenticatedUser().validateHasReadPermission("USER");
        List offices = this.fetchOffices(officeId);
        List staff = this.fetchStaff(staffId);
        List roles = this.fetchRoles();
        return new UserWorkbookPopulator(new OfficeSheetPopulator(offices), new PersonnelSheetPopulator(staff, offices), new RoleSheetPopulator(roles));
    }

    private List<RoleData> fetchRoles() {
        List rolesList = (List)this.roleReadPlatformService.retrieveAllActiveRoles();
        return rolesList;
    }

    private WorkbookPopulator populateFixedDepositTransactionsWorkbook(Long officeId) {
        this.context.authenticatedUser().validateHasReadPermission("OFFICE");
        this.context.authenticatedUser().validateHasReadPermission("CLIENT");
        this.context.authenticatedUser().validateHasReadPermission("FUNDS");
        this.context.authenticatedUser().validateHasReadPermission("PAYMENTTYPE");
        this.context.authenticatedUser().validateHasReadPermission("CURRENCY");
        List offices = this.fetchOffices(officeId);
        List clients = this.fetchClients(officeId);
        List funds = this.fetchFunds();
        List paymentTypes = this.fetchPaymentTypes();
        List currencies = this.fetchCurrencies();
        List savingsAccounts = this.fetchSavingsAccounts(officeId);
        return new FixedDepositTransactionWorkbookPopulator(new OfficeSheetPopulator(offices), new ClientSheetPopulator(clients, offices), new ExtrasSheetPopulator(funds, paymentTypes, currencies), savingsAccounts);
    }
}

