/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.loanrepayment;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ClientSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ExtrasSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.comparator.LoanComparatorByStatusActive;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class LoanRepaymentWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final OfficeSheetPopulator officeSheetPopulator;
    private final ClientSheetPopulator clientSheetPopulator;
    private final ExtrasSheetPopulator extrasSheetPopulator;
    private final List<LoanAccountData> allloans;
    private Map<Long, String> clientIdToClientExternalId;

    public LoanRepaymentWorkbookPopulator(List<LoanAccountData> loans, OfficeSheetPopulator officeSheetPopulator, ClientSheetPopulator clientSheetPopulator, ExtrasSheetPopulator extrasSheetPopulator) {
        this.allloans = loans;
        this.officeSheetPopulator = officeSheetPopulator;
        this.clientSheetPopulator = clientSheetPopulator;
        this.extrasSheetPopulator = extrasSheetPopulator;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet loanRepaymentSheet = workbook.createSheet("LoanRepayment");
        this.setLayout(loanRepaymentSheet);
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.clientSheetPopulator.populate(workbook, dateFormat);
        this.extrasSheetPopulator.populate(workbook, dateFormat);
        this.setClientIdToClientExternalId();
        this.populateLoansTable(loanRepaymentSheet, dateFormat);
        this.setRules(loanRepaymentSheet, dateFormat);
        this.setDefaults(loanRepaymentSheet, dateFormat);
    }

    private void setClientIdToClientExternalId() {
        this.clientIdToClientExternalId = new HashMap();
        List allclients = this.clientSheetPopulator.getClients();
        for (ClientData client : allclients) {
            if (client.getExternalId().isEmpty()) continue;
            this.clientIdToClientExternalId.put(client.getId(), client.getExternalId().getValue());
        }
    }

    private void setDefaults(Sheet worksheet, String dateFormat) {
        Integer rowNo = 1;
        while (rowNo < 3000) {
            Row row = worksheet.getRow(rowNo.intValue());
            if (row == null) {
                row = worksheet.createRow(rowNo.intValue());
            }
            this.writeFormula(2, row, "IF(ISERROR(VLOOKUP($B" + (rowNo + 1) + ",$R$2:$S$" + (this.allloans.size() + 1) + ",2,FALSE)),\"\",(VLOOKUP($B" + (rowNo + 1) + ",$R$2:$S$" + (this.allloans.size() + 1) + ",2,FALSE)))");
            this.writeFormula(4, row, "IF(ISERROR(VLOOKUP($D" + (rowNo + 1) + ",$T$2:$X$" + (this.allloans.size() + 1) + ",2,FALSE)),\"\",VLOOKUP($D" + (rowNo + 1) + ",$T$2:$X$" + (this.allloans.size() + 1) + ",2,FALSE))");
            this.writeFormula(5, row, "IF(ISERROR(VLOOKUP($D" + (rowNo + 1) + ",$T$2:$X$" + (this.allloans.size() + 1) + ",3,FALSE)),\"\",VLOOKUP($D" + (rowNo + 1) + ",$T$2:$X$" + (this.allloans.size() + 1) + ",3,FALSE))");
            this.writeFormula(6, row, "IF(ISERROR(VLOOKUP($D" + (rowNo + 1) + ",$T$2:$X$" + (this.allloans.size() + 1) + ",4,FALSE)),\"\",VLOOKUP($D" + (rowNo + 1) + ",$T$2:$X$" + (this.allloans.size() + 1) + ",4,FALSE))");
            this.writeFormula(7, row, "IF(ISERROR(VLOOKUP($D" + (rowNo + 1) + ",$T$2:$X$" + (this.allloans.size() + 1) + ",5,FALSE)),\"\",VLOOKUP($D" + (rowNo + 1) + ",$T$2:$X$" + (this.allloans.size() + 1) + ",5,FALSE))");
            Workbook workbook = worksheet.getWorkbook();
            CellStyle dateCellStyle = workbook.createCellStyle();
            short df = workbook.createDataFormat().getFormat(dateFormat);
            dateCellStyle.setDataFormat(df);
            row.getCell(7).setCellStyle(dateCellStyle);
            Integer n = rowNo;
            rowNo = rowNo + 1;
        }
    }

    private void setRules(Sheet worksheet, String dateFormat) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList clientNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList accountNumberRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList repaymentTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 10, 10);
        CellRangeAddressList repaymentDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 9, 9);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        this.setNames(worksheet);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint clientNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Client_\",$A1))");
        DataValidationConstraint accountNumberConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Account_\",SUBSTITUTE(SUBSTITUTE(SUBSTITUTE($B1,\" \",\"_\"),\"(\",\"_\"),\")\",\"_\")))");
        DataValidationConstraint paymentTypeConstraint = validationHelper.createFormulaListConstraint("PaymentTypes");
        DataValidationConstraint repaymentDateConstraint = validationHelper.createDateConstraint(0, "=VLOOKUP($D1,$T$2:$X$" + (this.allloans.size() + 1) + ",4,FALSE)", "=TODAY()", dateFormat);
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation clientValidation = validationHelper.createValidation(clientNameConstraint, clientNameRange);
        DataValidation accountNumberValidation = validationHelper.createValidation(accountNumberConstraint, accountNumberRange);
        DataValidation repaymentTypeValidation = validationHelper.createValidation(paymentTypeConstraint, repaymentTypeRange);
        DataValidation repaymentDateValidation = validationHelper.createValidation(repaymentDateConstraint, repaymentDateRange);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(clientValidation);
        worksheet.addValidationData(accountNumberValidation);
        worksheet.addValidationData(repaymentTypeValidation);
        worksheet.addValidationData(repaymentDateValidation);
    }

    private void setNames(Sheet worksheet) {
        ArrayList officeNames = new ArrayList(this.officeSheetPopulator.getOfficeNames());
        Workbook loanRepaymentWorkbook = worksheet.getWorkbook();
        Name officeGroup = loanRepaymentWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (officeNames.size() + 1));
        Integer i = 0;
        while (i < officeNames.size()) {
            Object officeNameToBeginEndIndexesOfClients = (Integer[])this.clientSheetPopulator.getOfficeNameToBeginEndIndexesOfClients().get(i);
            Name name = loanRepaymentWorkbook.createName();
            if (officeNameToBeginEndIndexesOfClients != null) {
                this.setSanitized(name, "Client_" + (String)officeNames.get(i));
                name.setRefersToFormula("Clients!$B$" + officeNameToBeginEndIndexesOfClients[0] + ":$B$" + officeNameToBeginEndIndexesOfClients[1]);
            }
            officeNameToBeginEndIndexesOfClients = i;
            i = i + 1;
        }
        HashMap<String, Integer[]> clientNameToBeginEndIndexes = new HashMap<String, Integer[]>();
        ArrayList<String> clientsWithActiveLoans = new ArrayList<String>();
        ArrayList<String> clientIdsWithActiveLoans = new ArrayList<String>();
        int startIndex = 1;
        int endIndex = 1;
        String clientName = "";
        String clientId = "";
        for (int i2 = 0; i2 < this.allloans.size(); ++i2) {
            if (!Objects.equals(clientName, ((LoanAccountData)this.allloans.get(i2)).getClientName())) {
                endIndex = i2 + 1;
                clientNameToBeginEndIndexes.put(clientName, new Integer[]{startIndex, endIndex});
                startIndex = i2 + 2;
                clientName = ((LoanAccountData)this.allloans.get(i2)).getClientName();
                clientId = String.valueOf(((LoanAccountData)this.allloans.get(i2)).getClientId());
                if (!clientsWithActiveLoans.contains(clientName)) {
                    clientsWithActiveLoans.add(clientName);
                    clientIdsWithActiveLoans.add(clientId);
                }
            }
            if (i2 != this.allloans.size() - 1) continue;
            endIndex = i2 + 2;
            clientNameToBeginEndIndexes.put(clientName, new Integer[]{startIndex, endIndex});
        }
        for (int j = 0; j < clientsWithActiveLoans.size(); ++j) {
            Name name = loanRepaymentWorkbook.createName();
            this.setSanitized(name, "Account_" + (String)clientsWithActiveLoans.get(j) + "_" + (String)clientIdsWithActiveLoans.get(j) + "_");
            name.setRefersToFormula("LoanRepayment!$T$" + ((Integer[])clientNameToBeginEndIndexes.get(clientsWithActiveLoans.get(j)))[0] + ":$T$" + ((Integer[])clientNameToBeginEndIndexes.get(clientsWithActiveLoans.get(j)))[1]);
        }
        Name paymentTypeGroup = loanRepaymentWorkbook.createName();
        paymentTypeGroup.setNameName("PaymentTypes");
        paymentTypeGroup.setRefersToFormula("Extras!$D$2:$D$" + (this.extrasSheetPopulator.getPaymentTypesSize() + 1));
    }

    private void populateLoansTable(Sheet loanRepaymentSheet, String dateFormat) {
        int rowIndex = 1;
        Workbook workbook = loanRepaymentSheet.getWorkbook();
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        DateTimeFormatter outputFormat = new DateTimeFormatterBuilder().appendPattern(dateFormat).toFormatter();
        Collections.sort(this.allloans, new LoanComparatorByStatusActive());
        for (LoanAccountData loan : this.allloans) {
            Row row = loanRepaymentSheet.createRow(rowIndex++);
            this.writeString(17, row, loan.getClientName() + "(" + loan.getClientId() + ")");
            this.writeString(18, row, (String)this.clientIdToClientExternalId.get(loan.getClientId()));
            this.writeString(19, row, loan.getAccountNo() + "-" + loan.getStatus().getValue());
            this.writeString(20, row, loan.getLoanProductName());
            this.writeDouble(21, row, loan.getPrincipal().doubleValue());
            if (loan.getSummary() != null && loan.getSummary().getTotalOutstanding() != null) {
                this.writeBigDecimal(22, row, loan.getSummary().getTotalOutstanding());
            }
            if (loan.getTimeline() == null || loan.getTimeline().getDisbursementDate() == null) continue;
            this.writeDate(23, row, outputFormat.format(loan.getTimeline().getDisbursementDate()), dateCellStyle, dateFormat);
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 6000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(6, 6000);
        worksheet.setColumnWidth(7, 6000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(15, 4000);
        worksheet.setColumnWidth(17, 6000);
        worksheet.setColumnWidth(18, 4000);
        worksheet.setColumnWidth(19, 4000);
        worksheet.setColumnWidth(20, 4000);
        worksheet.setColumnWidth(21, 4000);
        worksheet.setColumnWidth(22, 8000);
        worksheet.setColumnWidth(23, 4000);
        this.writeString(0, rowHeader, "Office Name*");
        this.writeString(1, rowHeader, "Client Name*");
        this.writeString(2, rowHeader, "Client Ext.Id");
        this.writeString(3, rowHeader, "Loan Account No.*");
        this.writeString(4, rowHeader, "Product Name");
        this.writeString(5, rowHeader, "Principal");
        this.writeString(6, rowHeader, "Total Outstanding Amount");
        this.writeString(7, rowHeader, "Loan Disbursement Date");
        this.writeString(8, rowHeader, "Amount Repaid*");
        this.writeString(9, rowHeader, "Date*");
        this.writeString(10, rowHeader, "Type*");
        this.writeString(11, rowHeader, "Account No");
        this.writeString(12, rowHeader, "Check No");
        this.writeString(14, rowHeader, "Receipt No");
        this.writeString(13, rowHeader, "Routing Code");
        this.writeString(15, rowHeader, "Bank No");
        this.writeString(17, rowHeader, "Lookup Client");
        this.writeString(18, rowHeader, "Lookup ClientExtId");
        this.writeString(19, rowHeader, "Lookup Account");
        this.writeString(20, rowHeader, "Lookup Product");
        this.writeString(21, rowHeader, "Lookup Principal");
        this.writeString(22, rowHeader, "Lookup Total Outstanding amount");
        this.writeString(23, rowHeader, "Lookup Loan Disbursement Date");
    }
}

