/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.guarantor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ClientSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class GuarantorWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final OfficeSheetPopulator officeSheetPopulator;
    private final ClientSheetPopulator clientSheetPopulator;
    private final List<LoanAccountData> loans;
    private final List<SavingsAccountData> savings;
    private final List<CodeValueData> guarantorRelationshipTypes;

    public GuarantorWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, ClientSheetPopulator clientSheetPopulator, List<LoanAccountData> loans, List<SavingsAccountData> savings, List<CodeValueData> guarantorRelationshipTypes) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.clientSheetPopulator = clientSheetPopulator;
        this.loans = loans;
        this.savings = savings;
        this.guarantorRelationshipTypes = guarantorRelationshipTypes;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet addGuarantorSheet = workbook.createSheet("guarantor");
        this.setLayout(addGuarantorSheet);
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.clientSheetPopulator.populate(workbook, dateFormat);
        this.populateLoansTable(addGuarantorSheet, dateFormat);
        this.populateSavingsTable(addGuarantorSheet, dateFormat);
        this.populateGuarantorRelationshipTypes(addGuarantorSheet, dateFormat);
        this.setRules(addGuarantorSheet);
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 6000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(15, 4000);
        worksheet.setColumnWidth(81, 4000);
        worksheet.setColumnWidth(82, 4000);
        worksheet.setColumnWidth(83, 4000);
        worksheet.setColumnWidth(84, 4000);
        this.writeString(0, rowHeader, "Office Name*");
        this.writeString(1, rowHeader, "Client Name*");
        this.writeString(2, rowHeader, " Loan Account NO");
        this.writeString(3, rowHeader, "Guranter_type*");
        this.writeString(4, rowHeader, "Client Relationship type*");
        this.writeString(5, rowHeader, "Guranter office");
        this.writeString(6, rowHeader, "Gurantor client id*");
        this.writeString(7, rowHeader, "First Name*");
        this.writeString(8, rowHeader, "Last Name");
        this.writeString(9, rowHeader, "ADDRESS LINE 1");
        this.writeString(10, rowHeader, "ADDRESS LINE 2");
        this.writeString(11, rowHeader, "City");
        this.writeString(12, rowHeader, "Date of Birth");
        this.writeString(13, rowHeader, "Zip*");
        this.writeString(14, rowHeader, "Savings Account Id");
        this.writeString(15, rowHeader, "Amount");
        this.writeString(81, rowHeader, "Lookup Client");
        this.writeString(82, rowHeader, "Lookup Loan Account");
        this.writeString(83, rowHeader, "Savings Lookup Client");
        this.writeString(84, rowHeader, "Savings Lookup Account");
    }

    private void populateSavingsTable(Sheet addGuarantorSheet, String dateFormat) {
        Workbook workbook = addGuarantorSheet.getWorkbook();
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        int rowIndex = 1;
        Collections.sort(this.savings, SavingsAccountData.ClientNameComparator);
        for (SavingsAccountData savingsAccount : this.savings) {
            Row row = addGuarantorSheet.getRow(rowIndex) == null ? addGuarantorSheet.createRow(rowIndex++) : addGuarantorSheet.getRow(rowIndex++);
            this.writeString(83, row, savingsAccount.getClientName() + "(" + savingsAccount.getClientId() + ")");
            this.writeString(84, row, savingsAccount.getAccountNo());
        }
    }

    private void populateLoansTable(Sheet addGuarantorSheet, String dateFormat) {
        Workbook workbook = addGuarantorSheet.getWorkbook();
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        int rowIndex = 1;
        this.loans.sort(LoanAccountData.LOAN_ACCOUNT_DATA_COMPARATOR_BY_CLIENT_NAME);
        for (LoanAccountData loan : this.loans) {
            Row row = addGuarantorSheet.getRow(rowIndex) == null ? addGuarantorSheet.createRow(rowIndex++) : addGuarantorSheet.getRow(rowIndex++);
            this.writeString(81, row, loan.getClientName() + "(" + loan.getClientId() + ")");
            this.writeString(82, row, Long.parseLong(loan.getAccountNo()) + "-" + loan.getStatus().getValue());
        }
    }

    private void populateGuarantorRelationshipTypes(Sheet addGuarantorSheet, String dateFormat) {
        Workbook workbook = addGuarantorSheet.getWorkbook();
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        int rowIndex = 1;
        for (CodeValueData relationshipType : this.guarantorRelationshipTypes) {
            Row row = addGuarantorSheet.getRow(rowIndex) == null ? addGuarantorSheet.createRow(rowIndex++) : addGuarantorSheet.getRow(rowIndex++);
            this.writeString(85, row, relationshipType.getName() + "-" + relationshipType.getId());
        }
    }

    private void setRules(Sheet worksheet) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList clientNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList entityofficeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 5, 5);
        CellRangeAddressList entityclientNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 6, 6);
        CellRangeAddressList accountNumberRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList savingsaccountNumberRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 14, 14);
        CellRangeAddressList guranterTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList guranterRelationshipTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 4, 4);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        this.setNames(worksheet);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint clientNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Client_\",$A1))");
        DataValidationConstraint accountNumberConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Account_\",SUBSTITUTE(SUBSTITUTE(SUBSTITUTE($B1,\" \",\"_\"),\"(\",\"_\"),\")\",\"_\")))");
        DataValidationConstraint savingsaccountNumberConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"SavingsAccount_\",SUBSTITUTE(SUBSTITUTE(SUBSTITUTE($G1,\" \",\"_\"),\"(\",\"_\"),\")\",\"_\")))");
        DataValidationConstraint guranterTypeConstraint = validationHelper.createExplicitListConstraint(new String[]{"Internal", "External"});
        DataValidationConstraint guarantorRelationshipConstraint = validationHelper.createFormulaListConstraint("GuarantorRelationship");
        DataValidationConstraint entityofficeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint entityclientNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Client_\",$F1))");
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation clientValidation = validationHelper.createValidation(clientNameConstraint, clientNameRange);
        DataValidation accountNumberValidation = validationHelper.createValidation(accountNumberConstraint, accountNumberRange);
        DataValidation savingsaccountNumberValidation = validationHelper.createValidation(savingsaccountNumberConstraint, savingsaccountNumberRange);
        DataValidation guranterTypeValidation = validationHelper.createValidation(guranterTypeConstraint, guranterTypeRange);
        DataValidation guarantorRelationshipValidation = validationHelper.createValidation(guarantorRelationshipConstraint, guranterRelationshipTypeRange);
        DataValidation entityofficeValidation = validationHelper.createValidation(entityofficeNameConstraint, entityofficeNameRange);
        DataValidation entityclientValidation = validationHelper.createValidation(entityclientNameConstraint, entityclientNameRange);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(clientValidation);
        worksheet.addValidationData(accountNumberValidation);
        worksheet.addValidationData(guranterTypeValidation);
        worksheet.addValidationData(guarantorRelationshipValidation);
        worksheet.addValidationData(entityofficeValidation);
        worksheet.addValidationData(entityclientValidation);
        worksheet.addValidationData(savingsaccountNumberValidation);
    }

    private void setNames(Sheet worksheet) {
        Workbook addGurarantorWorkbook = worksheet.getWorkbook();
        ArrayList officeNames = new ArrayList(this.officeSheetPopulator.getOfficeNames());
        Name officeGroup = addGurarantorWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (officeNames.size() + 1));
        Name guarantorRelationshipsGroup = addGurarantorWorkbook.createName();
        guarantorRelationshipsGroup.setNameName("GuarantorRelationship");
        guarantorRelationshipsGroup.setRefersToFormula("guarantor!$CH$2:$CH$" + (this.guarantorRelationshipTypes.size() + 1));
        Integer i = 0;
        while (i < officeNames.size()) {
            Object officeNameToBeginEndIndexesOfClients = (Integer[])this.clientSheetPopulator.getOfficeNameToBeginEndIndexesOfClients().get(i);
            Name name = addGurarantorWorkbook.createName();
            if (officeNameToBeginEndIndexesOfClients != null) {
                this.setSanitized(name, "Client_" + (String)officeNames.get(i));
                name.setRefersToFormula("Clients!$B$" + officeNameToBeginEndIndexesOfClients[0] + ":$B$" + officeNameToBeginEndIndexesOfClients[1]);
            }
            officeNameToBeginEndIndexesOfClients = i;
            i = i + 1;
        }
        HashMap<String, Integer[]> clientNameToBeginEndIndexes = new HashMap<String, Integer[]>();
        ArrayList<String> clientsWithActiveLoans = new ArrayList<String>();
        ArrayList<String> clientIdsWithActiveLoans = new ArrayList<String>();
        int startIndex = 1;
        int endIndex = 1;
        String clientName = "";
        String clientId = "";
        for (int i2 = 0; i2 < this.loans.size(); ++i2) {
            if (!clientName.equals(((LoanAccountData)this.loans.get(i2)).getClientName())) {
                endIndex = i2 + 1;
                clientNameToBeginEndIndexes.put(clientName, new Integer[]{startIndex, endIndex});
                startIndex = i2 + 2;
                clientName = ((LoanAccountData)this.loans.get(i2)).getClientName();
                clientId = ((LoanAccountData)this.loans.get(i2)).getClientId().toString();
                clientsWithActiveLoans.add(clientName);
                clientIdsWithActiveLoans.add(clientId);
            }
            if (i2 != this.loans.size() - 1) continue;
            endIndex = i2 + 2;
            clientNameToBeginEndIndexes.put(clientName, new Integer[]{startIndex, endIndex});
        }
        for (int j = 0; j < clientsWithActiveLoans.size(); ++j) {
            Name name = addGurarantorWorkbook.createName();
            this.setSanitized(name, "Account_" + (String)clientsWithActiveLoans.get(j) + "_" + (String)clientIdsWithActiveLoans.get(j) + "_");
            name.setRefersToFormula("guarantor!$CE$" + ((Integer[])clientNameToBeginEndIndexes.get(clientsWithActiveLoans.get(j)))[0] + ":$CE$" + ((Integer[])clientNameToBeginEndIndexes.get(clientsWithActiveLoans.get(j)))[1]);
        }
        ArrayList<String> clientsWithActiveSavings = new ArrayList<String>();
        ArrayList<String> clientIdsWithActiveSavings = new ArrayList<String>();
        clientName = "";
        clientId = "";
        for (int i3 = 0; i3 < this.savings.size(); ++i3) {
            if (!clientName.equals(((SavingsAccountData)this.savings.get(i3)).getClientName())) {
                endIndex = i3 + 1;
                clientNameToBeginEndIndexes.put(clientName, new Integer[]{startIndex, endIndex});
                startIndex = i3 + 2;
                clientName = ((SavingsAccountData)this.savings.get(i3)).getClientName();
                clientId = ((SavingsAccountData)this.savings.get(i3)).getClientId().toString();
                clientsWithActiveSavings.add(clientName);
                clientIdsWithActiveSavings.add(clientId);
            }
            if (i3 != this.savings.size() - 1) continue;
            endIndex = i3 + 2;
            clientNameToBeginEndIndexes.put(clientName, new Integer[]{startIndex, endIndex});
        }
        for (int j = 0; j < clientsWithActiveSavings.size(); ++j) {
            Name name = addGurarantorWorkbook.createName();
            this.setSanitized(name, "SavingsAccount_" + (String)clientsWithActiveSavings.get(j) + "_" + (String)clientIdsWithActiveSavings.get(j) + "_");
            name.setRefersToFormula("guarantor!$CG$" + ((Integer[])clientNameToBeginEndIndexes.get(clientsWithActiveSavings.get(j)))[0] + ":$CG$" + ((Integer[])clientNameToBeginEndIndexes.get(clientsWithActiveSavings.get(j)))[1]);
        }
    }
}

